/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.codeInsight.navigation.actions.GotoTypeDeclarationAction;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CtrlMouseHandler {
    private static final Logger LOG = Logger.getInstance(CtrlMouseHandler.class);
    private final Project myProject;
    private final EditorColorsManager myEditorColorsManager;
    private HighlightersSet myHighlighter;
    @JdkConstants.InputEventMask
    private int myStoredModifiers = 0;
    private TooltipProvider myTooltipProvider = null;
    private final FileEditorManager myFileEditorManager;
    private final DocumentationManager myDocumentationManager;
    @Nullable
    private Point myPrevMouseLocation;
    private LightweightHint myHint;
    private final KeyListener myEditorKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            this.handleKey(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.handleKey(e);
        }

        private void handleKey(KeyEvent e) {
            int modifiers = e.getModifiers();
            if (modifiers == CtrlMouseHandler.this.myStoredModifiers) {
                return;
            }
            BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(modifiers);
            if (browseMode == BrowseMode.None) {
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            } else {
                TooltipProvider tooltipProvider = CtrlMouseHandler.this.myTooltipProvider;
                if (tooltipProvider != null) {
                    if (browseMode != tooltipProvider.getBrowseMode()) {
                        CtrlMouseHandler.this.disposeHighlighter();
                    }
                    CtrlMouseHandler.this.myStoredModifiers = modifiers;
                    CtrlMouseHandler.this.cancelPreviousTooltip();
                    CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(tooltipProvider);
                    CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
                }
            }
        }
    };
    private final FileEditorManagerListener myFileEditorManagerListener = new FileEditorManagerListener(){

        public void selectionChanged(@NotNull FileEditorManagerEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.cancelPreviousTooltip();
        }
    };
    private final VisibleAreaListener myVisibleAreaListener = new VisibleAreaListener(){

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.cancelPreviousTooltip();
        }
    };
    private final EditorMouseListener myEditorMouseAdapter = new EditorMouseListener(){

        public void mouseReleased(@NotNull EditorMouseEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.cancelPreviousTooltip();
        }
    };
    private final EditorMouseMotionListener myEditorMouseMotionListener = new EditorMouseMotionListener(){

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e.isConsumed() || !CtrlMouseHandler.this.myProject.isInitialized() || CtrlMouseHandler.this.myProject.isDisposed()) {
                return;
            }
            MouseEvent mouseEvent = e.getMouseEvent();
            Point prevLocation = CtrlMouseHandler.this.myPrevMouseLocation;
            CtrlMouseHandler.this.myPrevMouseLocation = mouseEvent.getLocationOnScreen();
            if (CtrlMouseHandler.this.isMouseOverTooltip(mouseEvent.getLocationOnScreen()) || ScreenUtil.isMovementTowards((Point)prevLocation, (Point)mouseEvent.getLocationOnScreen(), (Rectangle)CtrlMouseHandler.this.getHintBounds())) {
                return;
            }
            CtrlMouseHandler.this.cancelPreviousTooltip();
            CtrlMouseHandler.this.myStoredModifiers = mouseEvent.getModifiers();
            BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(CtrlMouseHandler.this.myStoredModifiers);
            if (browseMode == BrowseMode.None || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            Editor editor = e.getEditor();
            if (!(editor instanceof EditorEx) || editor.getProject() != null && editor.getProject() != CtrlMouseHandler.this.myProject) {
                return;
            }
            Point point = new Point(mouseEvent.getPoint());
            if (editor.getInlayModel().getElementAt(point) != null) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider((EditorEx)editor, editor.xyToLogicalPosition(point));
            CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
        }
    };

    private void cancelPreviousTooltip() {
        if (this.myTooltipProvider != null) {
            this.myTooltipProvider.dispose();
            this.myTooltipProvider = null;
        }
    }

    public CtrlMouseHandler(final Project project, StartupManager startupManager, EditorColorsManager colorsManager, FileEditorManager fileEditorManager, @NotNull DocumentationManager documentationManager, final @NotNull EditorFactory editorFactory) {
        this.myProject = project;
        this.myEditorColorsManager = colorsManager;
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                EditorEventMulticaster eventMulticaster = editorFactory.getEventMulticaster();
                eventMulticaster.addEditorMouseListener(CtrlMouseHandler.this.myEditorMouseAdapter, (Disposable)project);
                eventMulticaster.addEditorMouseMotionListener(CtrlMouseHandler.this.myEditorMouseMotionListener, (Disposable)project);
                eventMulticaster.addCaretListener(new CaretListener(){

                    public void caretPositionChanged(@NotNull CaretEvent e) {
                        if (CtrlMouseHandler.this.myHint != null) {
                            CtrlMouseHandler.this.myDocumentationManager.updateToolwindowContext();
                        }
                    }
                }, (Disposable)project);
            }
        });
        this.myFileEditorManager = fileEditorManager;
        this.myDocumentationManager = documentationManager;
    }

    private boolean isMouseOverTooltip(@NotNull Point mouseLocationOnScreen) {
        Rectangle bounds2 = this.getHintBounds();
        return bounds2 != null && bounds2.contains(mouseLocationOnScreen);
    }

    @Nullable
    private Rectangle getHintBounds() {
        LightweightHint hint = this.myHint;
        if (hint == null) {
            return null;
        }
        JComponent hintComponent = hint.getComponent();
        if (!hintComponent.isShowing()) {
            return null;
        }
        return new Rectangle(hintComponent.getLocationOnScreen(), hintComponent.getSize());
    }

    @NotNull
    private static BrowseMode getBrowseMode(@JdkConstants.InputEventMask int modifiers) {
        if (modifiers != 0) {
            Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoDeclaration")) {
                return BrowseMode.Declaration;
            }
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoTypeDeclaration")) {
                return BrowseMode.TypeDeclaration;
            }
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoImplementation")) {
                return BrowseMode.Implementation;
            }
        }
        return BrowseMode.None;
    }

    @Nullable
    public static String getInfo(PsiElement element, PsiElement atPointer) {
        return CtrlMouseHandler.generateInfo((PsiElement)element, (PsiElement)atPointer, (boolean)true).text;
    }

    @Nullable
    public static String getInfo(@NotNull Editor editor, BrowseMode browseMode) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        Info info = CtrlMouseHandler.getInfoAt(project, editor, file2, editor.getCaretModel().getOffset(), browseMode);
        return info == null ? null : info.getInfo().text;
    }

    @NotNull
    private static DocInfo generateInfo(PsiElement element, PsiElement atPointer, boolean fallbackToBasicInfo) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element, atPointer);
        String result2 = documentationProvider.getQuickNavigateInfo(element, atPointer);
        if (result2 == null && fallbackToBasicInfo) {
            result2 = CtrlMouseHandler.doGenerateInfo(element);
        }
        return result2 == null ? DocInfo.EMPTY : new DocInfo(result2, documentationProvider);
    }

    @Nullable
    private static String doGenerateInfo(@NotNull PsiElement element) {
        ItemPresentation presentation;
        VirtualFile virtualFile;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null) {
            return virtualFile.getPresentableUrl();
        }
        String info = CtrlMouseHandler.getQuickNavigateInfo(element);
        if (info != null) {
            return info;
        }
        if (element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        return null;
    }

    @Nullable
    private static String getQuickNavigateInfo(PsiElement element) {
        String name = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        String typeName = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
        PsiFile file2 = element.getContainingFile();
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotEmpty((String)typeName)) {
            sb.append(typeName).append(" ");
        }
        sb.append("\"").append(name).append("\"");
        if (file2 != null && file2.isPhysical()) {
            sb.append(" [").append(file2.getName()).append("]");
        }
        return sb.toString();
    }

    private static void showDumbModeNotification(@NotNull Project project) {
        DumbService.getInstance((Project)project).showDumbModeNotification("Element information is not available during index update");
    }

    @Nullable
    private Info getInfoAt(@NotNull Editor editor, @NotNull PsiFile file2, int offset, @NotNull BrowseMode browseMode) {
        return CtrlMouseHandler.getInfoAt(this.myProject, editor, file2, offset, browseMode);
    }

    @Nullable
    public static Info getInfoAt(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, int offset, @NotNull BrowseMode browseMode) {
        PsiElement identifier;
        PsiElement elementAtPointer;
        PsiElement element;
        PsiElement targetElement = null;
        if (browseMode == BrowseMode.TypeDeclaration) {
            try {
                targetElement = GotoTypeDeclarationAction.findSymbolType(editor, offset);
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(project);
            }
        } else if (browseMode == BrowseMode.Declaration) {
            PsiReference ref = TargetElementUtil.findReference(editor, offset);
            List<Object> resolvedElements = ref == null ? Collections.emptyList() : CtrlMouseHandler.resolve(ref);
            PsiElement resolvedElement = resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
            PsiElement[] targetElements = GotoDeclarationAction.findTargetElementsNoVS(project, editor, offset, false);
            PsiElement elementAtPointer2 = file2.findElementAt(TargetElementUtil.adjustOffset(file2, editor.getDocument(), offset));
            if (targetElements != null) {
                if (targetElements.length == 0) {
                    return null;
                }
                if (targetElements.length == 1) {
                    if (targetElements[0] != resolvedElement && elementAtPointer2 != null && targetElements[0].isPhysical()) {
                        return ref != null ? new InfoSingle(ref, targetElements[0]) : new InfoSingle(elementAtPointer2, targetElements[0]);
                    }
                } else {
                    return elementAtPointer2 != null ? new InfoMultiple(elementAtPointer2) : null;
                }
            }
            if (resolvedElements.size() == 1) {
                return new InfoSingle(ref, (PsiElement)resolvedElements.get(0));
            }
            if (resolvedElements.size() > 1) {
                return elementAtPointer2 != null ? new InfoMultiple(elementAtPointer2, ref) : null;
            }
        } else if (browseMode == BrowseMode.Implementation) {
            element = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
            PsiElement[] targetElements = new ImplementationSearcher(){

                @Override
                @NotNull
                protected PsiElement[] searchDefinitions(PsiElement element, Editor editor) {
                    ArrayList found = new ArrayList(2);
                    DefinitionsScopedSearch.search((PsiElement)element, (SearchScope)7.getSearchScope(element, editor)).forEach(psiElement -> {
                        found.add(psiElement);
                        return found.size() != 2;
                    });
                    return PsiUtilCore.toPsiElementArray(found);
                }
            }.searchImplementations(editor, element, offset);
            if (targetElements == null) {
                return null;
            }
            if (targetElements.length > 1) {
                PsiElement elementAtPointer3 = file2.findElementAt(offset);
                if (elementAtPointer3 != null) {
                    return new InfoMultiple(elementAtPointer3);
                }
                return null;
            }
            if (targetElements.length == 1) {
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)targetElements[0]);
                if (descriptor == null || !descriptor.canNavigate()) {
                    return null;
                }
                targetElement = targetElements[0];
            }
        }
        if (targetElement != null && targetElement.isPhysical() && (elementAtPointer = file2.findElementAt(offset)) != null) {
            return new InfoSingle(elementAtPointer, targetElement);
        }
        element = GotoDeclarationAction.findElementToShowUsagesOf(editor, offset);
        if (element instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null && identifier.isValid()) {
            return new Info(identifier){

                @Override
                @NotNull
                public DocInfo getInfo() {
                    String name = UsageViewUtil.getType(element) + " '" + UsageViewUtil.getShortName(element) + "'";
                    return new DocInfo("Show usages of " + name, null);
                }

                @Override
                public boolean isValid(@NotNull Document document) {
                    return element.isValid();
                }

                @Override
                public boolean isNavigatable() {
                    return true;
                }
            };
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> resolve(@NotNull PsiReference ref) {
        PsiElement resolvedElement = ref.resolve();
        if (resolvedElement == null && ref instanceof PsiPolyVariantReference) {
            ResolveResult[] psiElements;
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (ResolveResult resolveResult : psiElements = ((PsiPolyVariantReference)ref).multiResolve(false)) {
                if (resolveResult.getElement() == null) continue;
                result2.add(resolveResult.getElement());
            }
            return result2;
        }
        return resolvedElement == null ? Collections.emptyList() : Collections.singletonList(resolvedElement);
    }

    private void disposeHighlighter() {
        if (this.myHighlighter != null) {
            HighlightersSet highlighter = this.myHighlighter;
            this.myHighlighter = null;
            highlighter.uninstall();
            HintManager.getInstance().hideAllHints();
        }
    }

    private void updateText(@NotNull String updatedText, @NotNull Consumer<? super String> newTextConsumer, @NotNull LightweightHint hint, @NotNull Editor editor) {
        UIUtil.invokeLaterIfNeeded(() -> {
            JComponent component = hint.getComponent();
            Dimension oldSize = component.getPreferredSize();
            newTextConsumer.consume((Object)updatedText);
            Dimension newSize = component.getPreferredSize();
            if (newSize.width == oldSize.width) {
                return;
            }
            component.setPreferredSize(new Dimension(newSize.width, newSize.height));
            if (hint.isRealPopup()) {
                TooltipProvider tooltipProvider = this.myTooltipProvider;
                if (tooltipProvider != null) {
                    hint.hide();
                    tooltipProvider.showHint(new LightweightHint(component), editor);
                } else {
                    component.setPreferredSize(new Dimension(newSize.width, oldSize.height));
                    hint.pack();
                }
                return;
            }
            Container topLevelLayeredPaneChild = null;
            boolean adjustBounds = false;
            for (Container current = component.getParent(); current != null; current = current.getParent()) {
                if (current instanceof JLayeredPane) {
                    adjustBounds = true;
                    break;
                }
                topLevelLayeredPaneChild = current;
            }
            if (adjustBounds && topLevelLayeredPaneChild != null) {
                Rectangle bounds2 = topLevelLayeredPaneChild.getBounds();
                topLevelLayeredPaneChild.setBounds(bounds2.x, bounds2.y, bounds2.width + newSize.width - oldSize.width, bounds2.height);
            }
        });
    }

    @NotNull
    private HighlightersSet installHighlighterSet(@NotNull Info info, @NotNull EditorEx editor) {
        editor.getContentComponent().addKeyListener(this.myEditorKeyListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        if (info.isNavigatable()) {
            editor.setCustomCursor(CtrlMouseHandler.class, Cursor.getPredefinedCursor(12));
        }
        this.myFileEditorManager.addFileEditorManagerListener(this.myFileEditorManagerListener);
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        TextAttributes attributes = info.isNavigatable() ? this.myEditorColorsManager.getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR) : new TextAttributes(null, HintUtil.getInformationColor(), null, null, 0);
        for (TextRange range2 : info.getRanges()) {
            TextAttributes attr = NavigationUtil.patchAttributesColor(attributes, range2, editor);
            RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 5900, attr, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add(highlighter);
        }
        return new HighlightersSet(highlighters, editor, info);
    }

    public boolean isCalculationInProgress() {
        TooltipProvider provider = this.myTooltipProvider;
        if (provider == null) {
            return false;
        }
        CompletableFuture progress = provider.myExecutionProgress;
        if (progress == null) {
            return false;
        }
        return !progress.isDone();
    }

    private class QuickDocHyperlinkListener
    implements HyperlinkListener {
        @NotNull
        private final DocumentationProvider myProvider;
        @NotNull
        private final PsiElement myContext;

        QuickDocHyperlinkListener(@NotNull DocumentationProvider provider, PsiElement context) {
            this.myProvider = provider;
            this.myContext = context;
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = e.getDescription();
            if (StringUtil.isEmpty((String)description) || !description.startsWith("psi_element://")) {
                return;
            }
            String elementName = e.getDescription().substring("psi_element://".length());
            DumbService.getInstance((Project)CtrlMouseHandler.this.myProject).withAlternativeResolveEnabled(() -> {
                PsiElement targetElement = this.myProvider.getDocumentationElementForLink(PsiManager.getInstance((Project)CtrlMouseHandler.this.myProject), elementName, this.myContext);
                if (targetElement != null) {
                    LightweightHint hint = CtrlMouseHandler.this.myHint;
                    if (hint != null) {
                        hint.hide(true);
                    }
                    CtrlMouseHandler.this.myDocumentationManager.showJavaDocInfo(targetElement, this.myContext, null);
                }
            });
        }
    }

    public static class DocInfo {
        public static final DocInfo EMPTY = new DocInfo(null, null);
        @Nullable
        public final String text;
        @Nullable
        public final DocumentationProvider docProvider;

        DocInfo(@Nullable String text, @Nullable DocumentationProvider provider) {
            this.text = text;
            this.docProvider = provider;
        }
    }

    private class HighlightersSet {
        @NotNull
        private final List<? extends RangeHighlighter> myHighlighters;
        @NotNull
        private final EditorEx myHighlighterView;
        @NotNull
        private final Info myStoredInfo;

        private HighlightersSet(@NotNull List<? extends RangeHighlighter> highlighters, @NotNull EditorEx highlighterView, Info storedInfo) {
            this.myHighlighters = highlighters;
            this.myHighlighterView = highlighterView;
            this.myStoredInfo = storedInfo;
        }

        public void uninstall() {
            for (RangeHighlighter rangeHighlighter : this.myHighlighters) {
                rangeHighlighter.dispose();
            }
            this.myHighlighterView.setCustomCursor(CtrlMouseHandler.class, null);
            this.myHighlighterView.getContentComponent().removeKeyListener(CtrlMouseHandler.this.myEditorKeyListener);
            this.myHighlighterView.getScrollingModel().removeVisibleAreaListener(CtrlMouseHandler.this.myVisibleAreaListener);
            CtrlMouseHandler.this.myFileEditorManager.removeFileEditorManagerListener(CtrlMouseHandler.this.myFileEditorManagerListener);
        }

        @NotNull
        public Info getStoredInfo() {
            return this.myStoredInfo;
        }
    }

    private class TooltipProvider {
        @NotNull
        private final EditorEx myHostEditor;
        private final int myHostOffset;
        private final boolean myInVirtualSpace;
        private BrowseMode myBrowseMode;
        private boolean myDisposed;
        private final ProgressIndicator myProgress = new ProgressIndicatorBase();
        private CompletableFuture myExecutionProgress;

        TooltipProvider(@NotNull EditorEx hostEditor, LogicalPosition hostPos) {
            this.myHostEditor = hostEditor;
            this.myHostOffset = hostEditor.logicalPositionToOffset(hostPos);
            this.myInVirtualSpace = EditorUtil.inVirtualSpace(hostEditor, hostPos);
        }

        TooltipProvider(TooltipProvider source) {
            this.myHostEditor = source.myHostEditor;
            this.myHostOffset = source.myHostOffset;
            this.myInVirtualSpace = source.myInVirtualSpace;
        }

        void dispose() {
            this.myDisposed = true;
            this.myProgress.cancel();
        }

        public BrowseMode getBrowseMode() {
            return this.myBrowseMode;
        }

        void execute(@NotNull BrowseMode browseMode) {
            this.myBrowseMode = browseMode;
            if (PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)this.myHostEditor.getDocument()) == null) {
                return;
            }
            if (this.myInVirtualSpace) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            int selStart = this.myHostEditor.getSelectionModel().getSelectionStart();
            int selEnd = this.myHostEditor.getSelectionModel().getSelectionEnd();
            if (this.myHostOffset >= selStart && this.myHostOffset < selEnd) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).performWhenAllCommitted(() -> {
                this.myExecutionProgress = ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myProgress, new ReadTask(){

                    @Override
                    @Nullable
                    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        return TooltipProvider.this.doExecute();
                    }

                    @Override
                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        LOG.debug("Highlighting was cancelled");
                    }
                });
            });
        }

        private ReadTask.Continuation createDisposalContinuation() {
            return new ReadTask.Continuation(() -> {
                if (!this.isTaskOutdated(this.myHostEditor)) {
                    CtrlMouseHandler.this.disposeHighlighter();
                }
            });
        }

        @Nullable
        private ReadTask.Continuation doExecute() {
            DocInfo docInfo;
            Info info;
            if (this.isTaskOutdated(this.myHostEditor)) {
                return null;
            }
            EditorEx editor = this.getPossiblyInjectedEditor();
            int offset = this.getOffset(editor);
            PsiFile file2 = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)editor.getDocument());
            if (file2 == null) {
                return this.createDisposalContinuation();
            }
            try {
                info = CtrlMouseHandler.this.getInfoAt(editor, file2, offset, this.myBrowseMode);
                if (info == null) {
                    return this.createDisposalContinuation();
                }
                docInfo = info.getInfo();
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                return this.createDisposalContinuation();
            }
            LOG.debug("Obtained info about element under cursor");
            return new ReadTask.Continuation(() -> {
                if (this.isTaskOutdated(editor)) {
                    return;
                }
                this.showHint(info, docInfo, editor);
            });
        }

        @NotNull
        private EditorEx getPossiblyInjectedEditor() {
            DocumentEx document = this.myHostEditor.getDocument();
            if (PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).isCommitted((Document)document)) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)document);
                return (EditorEx)InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myHostEditor, psiFile, this.myHostOffset);
            }
            return this.myHostEditor;
        }

        private boolean isTaskOutdated(@NotNull Editor editor) {
            return this.myDisposed || CtrlMouseHandler.this.myProject.isDisposed() || editor.isDisposed() || !ApplicationManager.getApplication().isUnitTestMode() && !editor.getComponent().isShowing();
        }

        private int getOffset(@NotNull Editor editor) {
            return editor instanceof EditorWindow ? ((EditorWindow)editor).getDocument().hostToInjected(this.myHostOffset) : this.myHostOffset;
        }

        private void showHint(@NotNull Info info, @NotNull DocInfo docInfo, @NotNull EditorEx editor) {
            if (this.myDisposed || editor.isDisposed()) {
                return;
            }
            if (CtrlMouseHandler.this.myHighlighter != null) {
                if (!info.isSimilarTo(CtrlMouseHandler.this.myHighlighter.getStoredInfo())) {
                    CtrlMouseHandler.this.disposeHighlighter();
                } else {
                    if (info.isNavigatable()) {
                        editor.setCustomCursor(CtrlMouseHandler.class, Cursor.getPredefinedCursor(12));
                    }
                    return;
                }
            }
            if (!info.isValid(editor.getDocument()) || !info.isNavigatable() && docInfo.text == null) {
                return;
            }
            CtrlMouseHandler.this.myHighlighter = CtrlMouseHandler.this.installHighlighterSet(info, editor);
            if (docInfo.text == null) {
                return;
            }
            QuickDocHyperlinkListener hyperlinkListener = docInfo.docProvider == null ? null : new QuickDocHyperlinkListener(docInfo.docProvider, info.myElementAtPointer);
            Ref newTextConsumerRef = new Ref();
            JComponent component = HintUtil.createInformationLabel(docInfo.text, hyperlinkListener, null, (Ref<Consumer<String>>)newTextConsumerRef);
            component.setBorder((Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6));
            LightweightHint hint = new LightweightHint(this.wrapInScrollPaneIfNeeded(component, editor));
            CtrlMouseHandler.this.myHint = hint;
            hint.addHintListener(new HintListener(){

                @Override
                public void hintHidden(@NotNull EventObject event) {
                    CtrlMouseHandler.this.myHint = null;
                }
            });
            this.showHint(hint, editor);
            Consumer newTextConsumer = (Consumer)newTextConsumerRef.get();
            if (newTextConsumer != null) {
                this.updateOnPsiChanges(hint, info, (Consumer<? super String>)newTextConsumer, docInfo.text, editor);
            }
        }

        @NotNull
        private JComponent wrapInScrollPaneIfNeeded(@NotNull JComponent component, @NotNull Editor editor) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                Dimension preferredSize = component.getPreferredSize();
                Dimension maxSize2 = this.getMaxPopupSize(editor);
                if (preferredSize.width > maxSize2.width || preferredSize.height > maxSize2.height) {
                    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)component, (boolean)true);
                    scrollPane.setPreferredSize(new Dimension(Math.min(preferredSize.width, maxSize2.width), Math.min(preferredSize.height, maxSize2.height)));
                    return scrollPane;
                }
            }
            return component;
        }

        @NotNull
        private Dimension getMaxPopupSize(@NotNull Editor editor) {
            Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)editor.getContentComponent());
            return new Dimension((int)(0.9 * (double)Math.max(640, rectangle.width)), (int)(0.33 * (double)Math.max(480, rectangle.height)));
        }

        private void updateOnPsiChanges(final @NotNull LightweightHint hint, final @NotNull Info info, final @NotNull Consumer<? super String> textConsumer, final @NotNull String oldText, final @NotNull Editor editor) {
            if (!hint.isVisible()) {
                return;
            }
            final Disposable hintDisposable = Disposer.newDisposable((String)"CtrlMouseHandler.TooltipProvider.updateOnPsiChanges");
            hint.addHintListener(new HintListener(){

                @Override
                public void hintHidden(@NotNull EventObject event) {
                    Disposer.dispose((Disposable)hintDisposable);
                }
            });
            final AtomicBoolean updating = new AtomicBoolean(false);
            CtrlMouseHandler.this.myProject.getMessageBus().connect(hintDisposable).subscribe(PsiModificationTracker.TOPIC, () -> {
                if (updating.getAndSet(true)) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).performWhenAllCommitted(() -> {
                    ProgressIndicatorBase progress = new ProgressIndicatorBase();
                    if (Disposer.isDisposed((Disposable)hintDisposable)) {
                        progress.cancel();
                    } else {
                        Disposer.register((Disposable)hintDisposable, () -> progress.cancel());
                    }
                    ProgressIndicatorUtils.scheduleWithWriteActionPriority(progress, new ReadTask(){

                        @Override
                        @Nullable
                        public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                            if (!info.isValid(editor.getDocument())) {
                                updating.set(false);
                                return null;
                            }
                            try {
                                DocInfo newDocInfo = info.getInfo();
                                return new ReadTask.Continuation(() -> {
                                    updating.set(false);
                                    if (newDocInfo.text != null && !oldText.equals(newDocInfo.text)) {
                                        CtrlMouseHandler.this.updateText(newDocInfo.text, (Consumer<? super String>)textConsumer, hint, editor);
                                    }
                                });
                            }
                            catch (IndexNotReadyException e) {
                                CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                                return TooltipProvider.this.createDisposalContinuation();
                            }
                        }

                        @Override
                        public void onCanceled(@NotNull ProgressIndicator indicator) {
                            updating.set(false);
                        }
                    });
                });
            });
        }

        public void showHint(@NotNull LightweightHint hint, @NotNull Editor editor) {
            if (ApplicationManager.getApplication().isUnitTestMode() || editor.isDisposed()) {
                return;
            }
            HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            short constraint = 1;
            LogicalPosition position = editor.offsetToLogicalPosition(this.getOffset(editor));
            Point p = HintManagerImpl.getHintPosition(hint, editor, position, constraint);
            if (p.y - hint.getComponent().getPreferredSize().height < 0) {
                constraint = 2;
                p = HintManagerImpl.getHintPosition(hint, editor, position, constraint);
            }
            hintManager.showEditorHint(hint, editor, p, 42, 0, false, HintManagerImpl.createHintHint(editor, p, hint, constraint).setContentActive(false));
        }
    }

    private static class InfoMultiple
    extends Info {
        InfoMultiple(@NotNull PsiElement elementAtPointer) {
            super(elementAtPointer);
        }

        InfoMultiple(@NotNull PsiElement elementAtPointer, @NotNull PsiReference ref) {
            super(elementAtPointer, ReferenceRange.getAbsoluteRanges((PsiReference)ref));
        }

        @Override
        @NotNull
        public DocInfo getInfo() {
            return new DocInfo(CodeInsightBundle.message((String)"multiple.implementations.tooltip", (Object[])new Object[0]), null);
        }

        @Override
        public boolean isValid(@NotNull Document document) {
            return this.rangesAreCorrect(document);
        }

        @Override
        public boolean isNavigatable() {
            return true;
        }
    }

    private static class InfoSingle
    extends Info {
        @NotNull
        private final PsiElement myTargetElement;

        InfoSingle(@NotNull PsiElement elementAtPointer, @NotNull PsiElement targetElement) {
            super(elementAtPointer);
            this.myTargetElement = targetElement;
        }

        InfoSingle(@NotNull PsiReference ref, @NotNull PsiElement targetElement) {
            super(ref.getElement(), ReferenceRange.getAbsoluteRanges((PsiReference)ref));
            this.myTargetElement = targetElement;
        }

        @Override
        @NotNull
        public DocInfo getInfo() {
            return this.areElementsValid() ? CtrlMouseHandler.generateInfo(this.myTargetElement, this.myElementAtPointer, this.isNavigatable()) : DocInfo.EMPTY;
        }

        private boolean areElementsValid() {
            return this.myTargetElement.isValid() && this.myElementAtPointer.isValid();
        }

        @Override
        public boolean isValid(@NotNull Document document) {
            return this.areElementsValid() && this.rangesAreCorrect(document);
        }

        @Override
        public boolean isNavigatable() {
            return this.myTargetElement != this.myElementAtPointer && this.myTargetElement != this.myElementAtPointer.getParent();
        }
    }

    public static abstract class Info {
        @NotNull
        protected final PsiElement myElementAtPointer;
        @NotNull
        private final List<TextRange> myRanges;

        public Info(@NotNull PsiElement elementAtPointer, @NotNull List<TextRange> ranges) {
            this.myElementAtPointer = elementAtPointer;
            this.myRanges = ranges;
        }

        public Info(@NotNull PsiElement elementAtPointer) {
            this(elementAtPointer, Info.getReferenceRanges(elementAtPointer));
        }

        @NotNull
        private static List<TextRange> getReferenceRanges(@NotNull PsiElement elementAtPointer) {
            if (!elementAtPointer.isPhysical()) {
                return Collections.emptyList();
            }
            int textOffset = elementAtPointer.getTextOffset();
            TextRange range2 = elementAtPointer.getTextRange();
            if (range2 == null) {
                throw new AssertionError((Object)("Null range for " + elementAtPointer + " of " + elementAtPointer.getClass()));
            }
            if (textOffset < range2.getStartOffset() || textOffset < 0) {
                LOG.error("Invalid text offset " + textOffset + " of element " + elementAtPointer + " of " + elementAtPointer.getClass());
                textOffset = range2.getStartOffset();
            }
            return Collections.singletonList(new TextRange(textOffset, range2.getEndOffset()));
        }

        boolean isSimilarTo(@NotNull Info that) {
            return Comparing.equal((Object)this.myElementAtPointer, (Object)that.myElementAtPointer) && this.myRanges.equals(that.myRanges);
        }

        @NotNull
        public List<TextRange> getRanges() {
            return this.myRanges;
        }

        @NotNull
        public abstract DocInfo getInfo();

        public abstract boolean isValid(@NotNull Document var1);

        public abstract boolean isNavigatable();

        protected boolean rangesAreCorrect(@NotNull Document document) {
            TextRange docRange = new TextRange(0, document.getTextLength());
            for (TextRange range2 : this.getRanges()) {
                if (docRange.contains(range2)) continue;
                return false;
            }
            return true;
        }
    }

    public static enum BrowseMode {
        None,
        Declaration,
        TypeDeclaration,
        Implementation;

    }
}

