/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoImplementationHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.implementation";
    }

    @Override
    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        if (source == null) {
            return null;
        }
        return this.createDataForSource(editor, offset, source);
    }

    private GotoTargetHandler.GotoData createDataForSource(@NotNull Editor editor, int offset, PsiElement source) {
        final PsiReference reference = TargetElementUtil.findReference(editor, offset);
        final TargetElementUtil instance = TargetElementUtil.getInstance();
        PsiElement[] targets2 = new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected boolean accept(PsiElement element) {
                return instance.acceptImplementationForReference(reference, element);
            }

            @Override
            protected boolean canShowPopupWithOneItem(PsiElement element) {
                return false;
            }
        }.searchImplementations(editor, source, offset);
        if (targets2 == null) {
            return null;
        }
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets2, Collections.emptyList());
        gotoData.listUpdaterTask = new ImplementationsUpdaterTask(gotoData, editor, offset, reference){

            @Override
            public void onSuccess() {
                super.onSuccess();
                PsiElement oneElement = this.getTheOnlyOneElement();
                if (oneElement != null && GotoImplementationHandler.this.navigateToElement(oneElement)) {
                    this.myPopup.cancel();
                }
            }
        };
        return gotoData;
    }

    @Override
    protected void chooseFromAmbiguousSources(Editor editor, PsiFile file2, Consumer<? super GotoTargetHandler.GotoData> successCallback) {
        int offset = editor.getCaretModel().getOffset();
        PsiElementProcessor navigateProcessor = element -> {
            GotoTargetHandler.GotoData data = this.createDataForSource(editor, offset, element);
            if (data != null) {
                successCallback.consume((Object)data);
            }
            return true;
        };
        GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, (PsiElementProcessor<? super PsiElement>)navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), null);
    }

    private static PsiElement getContainer(PsiElement refElement) {
        for (ContainerProvider provider : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished2) {
        String fullName;
        ItemPresentation presentation = ((NavigationItem)sourceElement).getPresentation();
        if (presentation == null) {
            fullName = name;
        } else {
            PsiElement container = GotoImplementationHandler.getContainer(sourceElement);
            ItemPresentation containerPresentation = container == null || container instanceof PsiFile ? null : ((NavigationItem)container).getPresentation();
            String containerText = containerPresentation == null ? null : containerPresentation.getPresentableText();
            fullName = (containerText == null ? "" : containerText + ".") + presentation.getPresentableText();
        }
        return CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)fullName), length, finished2 ? "" : " so far"});
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        return CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)name), length});
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        return CodeInsightBundle.message((String)"goto.implementation.notFound", (Object[])new Object[0]);
    }

    private class ImplementationsUpdaterTask
    extends BackgroundUpdaterTask {
        private final Editor myEditor;
        private final int myOffset;
        private final GotoTargetHandler.GotoData myGotoData;
        private final PsiReference myReference;

        ImplementationsUpdaterTask(final @NotNull GotoTargetHandler.GotoData gotoData, Editor editor, int offset, PsiReference reference) {
            super(gotoData.source.getProject(), ImplementationSearcher.SEARCHING_FOR_IMPLEMENTATIONS, ImplementationsUpdaterTask.createComparatorWrapper(Comparator.comparing(new Function<PsiElement, Comparable>(){

                @Override
                public Comparable apply(PsiElement e1) {
                    return GotoImplementationHandler.this.getRenderer(e1, gotoData).getComparingObject(e1);
                }
            })));
            this.myEditor = editor;
            this.myOffset = offset;
            this.myGotoData = gotoData;
            this.myReference = reference;
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            super.run(indicator);
            for (PsiElement element : this.myGotoData.targets) {
                if (this.updateComponent(element)) continue;
                return;
            }
            new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected void processElement(PsiElement element) {
                    indicator.checkCanceled();
                    if (!TargetElementUtil.getInstance().acceptImplementationForReference(ImplementationsUpdaterTask.this.myReference, element)) {
                        return;
                    }
                    if (ImplementationsUpdaterTask.this.myGotoData.addTarget(element) && !ImplementationsUpdaterTask.this.updateComponent(element)) {
                        indicator.cancel();
                    }
                }
            }.searchImplementations(this.myEditor, this.myGotoData.source, this.myOffset);
        }

        @Override
        public String getCaption(int size) {
            String name = ElementDescriptionUtil.getElementDescription((PsiElement)this.myGotoData.source, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
            return GotoImplementationHandler.this.getChooserTitle(this.myGotoData.source, name, size, this.isFinished());
        }
    }
}

