/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.diagnostic.PluginException;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.actions.GotoDeclarationAction");

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        DumbService.getInstance((Project)project).setAlternativeResolveEnabled(true);
        try {
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] elements = (PsiElement[])GotoDeclarationAction.underModalProgress(project, "Resolving Reference...", () -> GotoDeclarationAction.findAllTargetElements(project, editor, offset));
            FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.declaration");
            if (elements.length != 1) {
                if (elements.length == 0 && GotoDeclarationAction.suggestCandidates(TargetElementUtil.findReference(editor, offset)).isEmpty()) {
                    PsiElement element = GotoDeclarationAction.findElementToShowUsagesOf(editor, editor.getCaretModel().getOffset());
                    if (GotoDeclarationAction.startFindUsages(editor, project, element)) {
                        return;
                    }
                    if (GotoDeclarationAction.isKeywordUnderCaret(project, file2, offset)) {
                        return;
                    }
                }
                GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, elements, file2);
                return;
            }
            PsiElement element = elements[0];
            if (element == GotoDeclarationAction.findElementToShowUsagesOf(editor, editor.getCaretModel().getOffset()) && GotoDeclarationAction.startFindUsages(editor, project, element)) {
                return;
            }
            PsiElement navElement = element.getNavigationElement();
            navElement = TargetElementUtil.getInstance().getGotoDeclarationTarget(element, navElement);
            if (navElement != null) {
                GotoDeclarationAction.gotoTargetElement(navElement, editor, file2);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available here during index update");
        }
        finally {
            DumbService.getInstance((Project)project).setAlternativeResolveEnabled(false);
        }
    }

    private static boolean startFindUsages(@NotNull Editor editor, @NotNull Project project, PsiElement element) {
        if (element == null) {
            return false;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            AnAction action = ActionManager.getInstance().getAction("ShowUsages");
            String name = action.getTemplatePresentation().getText();
            DumbService.getInstance((Project)project).showDumbModeNotification(ActionUtil.getUnavailableMessage((String)name, (boolean)false));
        } else {
            RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
            new ShowUsagesAction().startFindUsages(element, popupPosition, editor, ShowUsagesAction.getUsagesPageSize());
        }
        return true;
    }

    static <T> T underModalProgress(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String progressTitle, @NotNull Computable<T> computable) throws ProcessCanceledException {
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            DumbService.getInstance((Project)project).setAlternativeResolveEnabled(true);
            try {
                Object object = ApplicationManager.getApplication().runReadAction(computable);
                return object;
            }
            finally {
                DumbService.getInstance((Project)project).setAlternativeResolveEnabled(false);
            }
        }, progressTitle, true, project);
    }

    public static PsiElement findElementToShowUsagesOf(@NotNull Editor editor, int offset) {
        return TargetElementUtil.getInstance().findTargetElement(editor, 2, offset);
    }

    private static void chooseAmbiguousTarget(Editor editor, int offset, PsiElement[] elements, PsiFile currentFile) {
        if (!editor.getComponent().isShowing()) {
            return;
        }
        PsiElementProcessor navigateProcessor = element -> {
            GotoDeclarationAction.gotoTargetElement(element, editor, currentFile);
            return true;
        };
        boolean found = GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, (PsiElementProcessor<? super PsiElement>)navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), elements);
        if (!found) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find declaration to go to");
        }
    }

    private static boolean navigateInCurrentEditor(@NotNull PsiElement element, @NotNull PsiFile currentFile, @NotNull Editor currentEditor) {
        int offset;
        PsiElement leaf;
        if (element.getContainingFile() == currentFile && !currentEditor.isDisposed() && (leaf = currentFile.findElementAt(offset = element.getTextOffset())) != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)leaf, (boolean)false)) {
            Project project = element.getProject();
            CommandProcessor.getInstance().executeCommand(project, () -> {
                IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
                new OpenFileDescriptor(project, currentFile.getViewProvider().getVirtualFile(), offset).navigateIn(currentEditor);
            }, "", null);
            return true;
        }
        return false;
    }

    private static void gotoTargetElement(@NotNull PsiElement element, @NotNull Editor currentEditor, @NotNull PsiFile currentFile) {
        Navigatable navigatable;
        if (GotoDeclarationAction.navigateInCurrentEditor(element, currentFile, currentEditor)) {
            return;
        }
        Navigatable navigatable2 = navigatable = element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)element);
        if (navigatable != null && navigatable.canNavigate()) {
            navigatable.navigate(true);
        }
    }

    public static boolean chooseAmbiguousTarget(@NotNull Editor editor, int offset, @NotNull PsiElementProcessor<? super PsiElement> processor2, @NotNull String titlePattern, @Nullable PsiElement[] elements) {
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            return false;
        }
        PsiReference reference = TargetElementUtil.findReference(editor, offset);
        if (elements == null || elements.length == 0) {
            PsiElement[] psiElementArray = elements = reference == null ? PsiElement.EMPTY_ARRAY : PsiUtilCore.toPsiElementArray((Collection)((Collection)GotoDeclarationAction.underModalProgress(reference.getElement().getProject(), "Resolving Reference...", () -> GotoDeclarationAction.suggestCandidates(reference))));
        }
        if (elements.length == 1) {
            PsiElement element = elements[0];
            LOG.assertTrue(element != null);
            processor2.execute(element);
            return true;
        }
        if (elements.length > 1) {
            String title;
            if (reference == null) {
                title = titlePattern;
            } else {
                TextRange range2 = reference.getRangeInElement();
                String elementText = reference.getElement().getText();
                LOG.assertTrue(range2.getStartOffset() >= 0 && range2.getEndOffset() <= elementText.length(), (Object)(Arrays.toString(elements) + ";" + reference));
                String refText = range2.substring(elementText);
                title = MessageFormat.format(titlePattern, refText);
            }
            NavigationUtil.getPsiElementPopup((PsiElement[])elements, (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)title, processor2).showInBestPositionFor(editor);
            return true;
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> suggestCandidates(@Nullable PsiReference reference) {
        if (reference == null) {
            return Collections.emptyList();
        }
        return TargetElementUtil.getInstance().getTargetCandidates(reference);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static PsiElement findTargetElement(Project project, Editor editor, int offset) {
        PsiElement[] targets2 = GotoDeclarationAction.findAllTargetElements(project, editor, offset);
        return targets2.length == 1 ? targets2[0] : null;
    }

    @NotNull
    @VisibleForTesting
    public static PsiElement[] findAllTargetElements(Project project, Editor editor, int offset) {
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] targets2 = GotoDeclarationAction.findTargetElementsNoVS(project, editor, offset, true);
        return targets2 != null ? targets2 : PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    static PsiElement[] findTargetElementsFromProviders(@NotNull Project project, @NotNull Editor editor, int offset) {
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        PsiElement elementAt = file2.findElementAt(TargetElementUtil.adjustOffset(file2, document, offset));
        for (GotoDeclarationHandler handler2 : GotoDeclarationHandler.EP_NAME.getExtensionList()) {
            PsiElement[] result2 = handler2.getGotoDeclarationTargets(elementAt, offset, editor);
            if (result2 == null || result2.length <= 0) continue;
            return GotoDeclarationAction.assertNotNullElements(result2, handler2.getClass()) ? result2 : null;
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiElement[] findTargetElementsNoVS(Project project, Editor editor, int offset, boolean lookupAccepted) {
        PsiElement element;
        PsiElement[] fromProviders = GotoDeclarationAction.findTargetElementsFromProviders(project, editor, offset);
        if (fromProviders == null || fromProviders.length > 0) {
            return fromProviders;
        }
        int flags = TargetElementUtil.getInstance().getAllAccepted() & 0xFFFFFFFD;
        if (!lookupAccepted) {
            flags &= 0xFFFFFFF7;
        }
        if ((element = TargetElementUtil.getInstance().findTargetElement(editor, flags, offset)) != null) {
            return new PsiElement[]{element};
        }
        if (editor instanceof EditorWindow) {
            EditorWindow window = (EditorWindow)editor;
            return GotoDeclarationAction.findTargetElementsNoVS(project, window.getDelegate(), window.getDocument().injectedToHost(offset), lookupAccepted);
        }
        return null;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event.getProject() == null || event.getData(EditorGutter.KEY) != null || Boolean.TRUE.equals(event.getData(CommonDataKeys.EDITOR_VIRTUAL_SPACE))) {
            event.getPresentation().setEnabled(false);
            return;
        }
        InputEvent inputEvent = event.getInputEvent();
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor != null && inputEvent instanceof MouseEvent && editor.getInlayModel().getElementAt(new RelativePoint((MouseEvent)inputEvent).getPoint((Component)editor.getContentComponent())) != null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        for (GotoDeclarationHandler handler2 : GotoDeclarationHandler.EP_NAME.getExtensionList()) {
            String text = handler2.getActionText(event.getDataContext());
            if (text == null) continue;
            Presentation presentation = event.getPresentation();
            presentation.setText(text);
            break;
        }
        super.update(event);
    }

    static boolean isKeywordUnderCaret(@NotNull Project project, @NotNull PsiFile file2, int offset) {
        PsiElement elementAtCaret = file2.findElementAt(offset);
        if (elementAtCaret == null) {
            return false;
        }
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(elementAtCaret.getLanguage());
        return namesValidator != null && namesValidator.isKeyword(elementAtCaret.getText(), project);
    }

    private static boolean assertNotNullElements(@NotNull PsiElement[] result2, Class<?> clazz) {
        for (PsiElement element : result2) {
            if (element != null) continue;
            PluginException.logPluginError((Logger)LOG, (String)("Null target element is returned by 'getGotoDeclarationTargets' in " + clazz.getName()), null, clazz);
            return false;
        }
        return true;
    }
}

