/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.navigation.IncrementalSearchHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class IncrementalSearchAction
extends AnAction
implements DumbAware {
    public IncrementalSearchAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        new IncrementalSearchHandler().invoke(project, editor);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }
}

