/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetAbbreviationBalloon;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetUpdateTagAction
extends BaseCodeInsightAction
implements DumbAware,
PopupAction {
    private static final String EMMET_RECENT_UPDATE_ABBREVIATIONS_KEY = "emmet.recent.update.abbreviations";
    private static final String EMMET_LAST_UPDATE_ABBREVIATIONS_KEY = "emmet.last.update.abbreviations";
    private static final String DOCUMENTATION = "Update HTML tag with Emmet abbreviation:<br/>.class[attribute] to overwrite value;<br/>.+class[attribute] to append value;<br/>.-class[attribute] to remove value.<br/><p/>For example, <code>.+c2[title=Hello]</code> abbreviation updates<br/><code>&lt;div class=\"c1\"&gt;</code> to<br/><code>&lt;div class=\"c1 c2\" title=\"Hello\"&gt;</code>.";
    private static final EmmetAbbreviationBalloon.EmmetContextHelp CONTEXT_HELP = new EmmetAbbreviationBalloon.EmmetContextHelp("Update HTML tag with Emmet abbreviation:<br/>.class[attribute] to overwrite value;<br/>.+class[attribute] to append value;<br/>.-class[attribute] to remove value.<br/><p/>For example, <code>.+c2[title=Hello]</code> abbreviation updates<br/><code>&lt;div class=\"c1\"&gt;</code> to<br/><code>&lt;div class=\"c1 c2\" title=\"Hello\"&gt;</code>.");

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file2) {
                final XmlTag tag = EmmetUpdateTagAction.findTag(editor, file2);
                if (tag != null) {
                    new EmmetAbbreviationBalloon(EmmetUpdateTagAction.EMMET_RECENT_UPDATE_ABBREVIATIONS_KEY, EmmetUpdateTagAction.EMMET_LAST_UPDATE_ABBREVIATIONS_KEY, new EmmetAbbreviationBalloon.Callback(){

                        @Override
                        public void onEnter(@NotNull String abbreviation) {
                            try {
                                EmmetUpdateTagAction.this.doUpdateTag(abbreviation, tag, file2, editor);
                            }
                            catch (EmmetException emmetException) {
                                // empty catch block
                            }
                        }
                    }, CONTEXT_HELP).show(new CustomTemplateCallback(editor, file2));
                }
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
    }

    public void doUpdateTag(@NotNull String abbreviation, @NotNull XmlTag tag, @NotNull PsiFile file2, @NotNull Editor editor) throws EmmetException {
        if (tag.isValid()) {
            String templateText = EmmetUpdateTagAction.expandTemplate(abbreviation, file2, editor);
            LinkedHashSet classNames = ContainerUtil.newLinkedHashSet();
            ContainerUtil.addAll((Collection)classNames, HtmlUtil.splitClassNames(tag.getAttributeValue("class")));
            LinkedHashMap attributes = ContainerUtil.newLinkedHashMap();
            Ref newTagName = Ref.create();
            EmmetUpdateTagAction.processTags(file2.getProject(), templateText, (PairProcessor<? super XmlTag, ? super Boolean>)((PairProcessor)(tag1, firstTag) -> {
                if (firstTag.booleanValue() && !abbreviation.isEmpty() && StringUtil.isJavaIdentifierPart((char)abbreviation.charAt(0))) {
                    newTagName.set((Object)tag1.getName());
                }
                for (String clazz : HtmlUtil.splitClassNames(tag1.getAttributeValue("class"))) {
                    if (StringUtil.startsWithChar((CharSequence)clazz, (char)'+')) {
                        classNames.add(clazz.substring(1));
                        continue;
                    }
                    if (StringUtil.startsWithChar((CharSequence)clazz, (char)'-')) {
                        classNames.remove(clazz.substring(1));
                        continue;
                    }
                    classNames.clear();
                    classNames.add(clazz);
                }
                if (!firstTag.booleanValue()) {
                    classNames.add(tag1.getName());
                }
                for (XmlAttribute xmlAttribute : tag1.getAttributes()) {
                    if ("class".equalsIgnoreCase(xmlAttribute.getName())) continue;
                    attributes.put(xmlAttribute.getName(), StringUtil.notNullize((String)xmlAttribute.getValue()));
                }
                return true;
            }));
            WriteCommandAction.writeCommandAction((Project)file2.getProject(), (PsiFile[])new PsiFile[]{file2}).run(EmmetUpdateTagAction.doUpdateTagAttributes(tag, file2, (String)newTagName.get(), classNames, attributes));
        }
    }

    @Nullable
    private static String expandTemplate(@NotNull String abbreviation, @NotNull PsiFile file2, @NotNull Editor editor) throws EmmetException {
        CollectCustomTemplateCallback callback2 = new CollectCustomTemplateCallback(editor, file2);
        ZenCodingTemplate.expand(abbreviation, callback2, XmlZenCodingGeneratorImpl.INSTANCE, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
        TemplateImpl template = callback2.getGeneratedTemplate();
        return template != null ? template.getTemplateText() : null;
    }

    private static void processTags(@NotNull Project project, @Nullable String templateText, @NotNull PairProcessor<? super XmlTag, ? super Boolean> processor2) {
        if (StringUtil.isNotEmpty((String)templateText)) {
            PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
            XmlFile xmlFile = (XmlFile)psiFileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.HTML, (CharSequence)templateText);
            XmlTag tag = xmlFile.getRootTag();
            boolean firstTag = true;
            while (tag != null) {
                processor2.process((Object)tag, (Object)firstTag);
                firstTag = false;
                tag = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, XmlTag.class);
            }
        }
    }

    @NotNull
    private static ThrowableRunnable<RuntimeException> doUpdateTagAttributes(@NotNull XmlTag tag, @NotNull PsiFile file2, @Nullable String newTagName, @NotNull Collection<String> classes, @NotNull Map<String, String> attributes) {
        return () -> {
            if (tag.isValid() && !ReadonlyStatusHandler.getInstance((Project)file2.getProject()).ensureFilesWritable(Collections.singletonList(file2.getVirtualFile())).hasReadonlyFiles()) {
                tag.setAttribute("class", StringUtil.join((Collection)classes, (String)" ").trim());
                for (Map.Entry attribute : attributes.entrySet()) {
                    XmlAttribute existingAttribute;
                    String attributeName = (String)attribute.getKey();
                    if (StringUtil.startsWithChar((CharSequence)attributeName, (char)'+')) {
                        existingAttribute = tag.getAttribute(attributeName.substring(1));
                        if (existingAttribute != null) {
                            existingAttribute.setValue(StringUtil.notNullize((String)(existingAttribute.getValue() + (String)attribute.getValue())));
                            continue;
                        }
                        tag.setAttribute(attributeName.substring(1), (String)attribute.getValue());
                        continue;
                    }
                    if (StringUtil.startsWithChar((CharSequence)attributeName, (char)'-')) {
                        existingAttribute = tag.getAttribute(attributeName.substring(1));
                        if (existingAttribute == null) continue;
                        existingAttribute.delete();
                        continue;
                    }
                    tag.setAttribute(attributeName, (String)attribute.getValue());
                }
                if (newTagName != null) {
                    tag.setName(newTagName);
                }
            }
        };
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        event.getPresentation().setVisible(event.getPresentation().isEnabled());
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        return super.isValidForFile(project, editor, file2) && EmmetOptions.getInstance().isEmmetEnabled() && EmmetUpdateTagAction.findTag(editor, file2) != null;
    }

    @Nullable
    private static XmlTag findTag(@NotNull Editor editor, @NotNull PsiFile file2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), (Class[])new Class[]{XmlTag.class});
        return tag != null && HtmlUtil.isHtmlTag(tag) ? tag : null;
    }
}

