/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class SingleLineEmmetFilter
extends ZenCodingFilter {
    @Override
    @NotNull
    public String getSuffix() {
        return "s";
    }

    @Override
    @NotNull
    public String filterText(@NotNull String text, @NotNull TemplateToken token) {
        return StringUtil.replace((String)text, (String)"\n", (String)"");
    }

    @Override
    @NotNull
    public GenerationNode filterNode(@NotNull GenerationNode node) {
        TemplateImpl template = node.getTemplateToken().getTemplate();
        if (template != null) {
            template.setToReformat(false);
        }
        for (GenerationNode generationNode : node.getChildren()) {
            this.filterNode(generationNode);
        }
        return node;
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        return context.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Single line";
    }
}

