/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerationNode
extends UserDataHolderBase {
    private final TemplateToken myTemplateToken;
    private final List<GenerationNode> myChildren = Lists.newArrayList();
    private final int myNumberInIteration;
    private final int myTotalIterations;
    private String mySurroundedText;
    private final boolean myInsertSurroundedTextAtTheEnd;
    private final boolean myInsertNewLineBetweenNodes;
    private GenerationNode myParent;
    private boolean myContainsSurroundedTextMarker = false;
    private static final Pattern ATTRIBUTE_VARIABLE_PATTERN = Pattern.compile("\\$[A-z_0-9]+\\$");
    private static final Pattern HREF_PATTERN = Pattern.compile("^(?:(?:https?|ftp|file)://|www\\.|ftp\\.)(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[-A-Z0-9+&@#/%=~_|$?!:,.])*(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[A-Z0-9+&@#/%=~_|$])", 2);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-z0-9._%+-]+@[A-z0-9.-]+\\.[A-z]{2,5}$");
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^([A-z]+:)?//");

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        this(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent, false);
    }

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent, boolean insertNewLineBetweenNodes) {
        this.myTemplateToken = templateToken;
        this.myNumberInIteration = numberInIteration;
        this.myTotalIterations = totalIterations;
        this.mySurroundedText = surroundedText;
        this.myInsertSurroundedTextAtTheEnd = insertSurroundedTextAtTheEnd;
        this.myInsertNewLineBetweenNodes = insertNewLineBetweenNodes;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean isInsertNewLineBetweenNodes() {
        return this.myInsertNewLineBetweenNodes;
    }

    public List<GenerationNode> getChildren() {
        return this.myChildren;
    }

    public void addChild(GenerationNode child2) {
        child2.setParent(this);
        this.myChildren.add(child2);
    }

    public void addChildren(Collection<? extends GenerationNode> children2) {
        for (GenerationNode generationNode : children2) {
            this.addChild(generationNode);
        }
    }

    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    private boolean isBlockTag() {
        XmlTag tag;
        if (this.myTemplateToken != null && (tag = this.myTemplateToken.getXmlTag()) != null) {
            return HtmlUtil.isHtmlBlockTagL(tag.getName());
        }
        return false;
    }

    @NotNull
    public TemplateImpl generate(@NotNull CustomTemplateCallback callback2, @Nullable ZenCodingGenerator generator, @NotNull Collection<ZenCodingFilter> filters, boolean insertSurroundedText, int segmentsLimit) {
        Map<String, String> predefinedValues;
        TemplateImpl parentTemplate;
        boolean hasChildren;
        String indentStr;
        this.myContainsSurroundedTextMarker = !insertSurroundedText || !this.myInsertSurroundedTextAtTheEnd;
        GenerationNode generationNode = this;
        if (generationNode != this) {
            return generationNode.generate(callback2, generator, Collections.emptyList(), insertSurroundedText, segmentsLimit);
        }
        boolean shouldNotReformatTemplate = false;
        boolean oneLineTemplateExpanding = false;
        for (ZenCodingFilter filter : filters) {
            generationNode = filter.filterNode(generationNode);
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            shouldNotReformatTemplate = true;
            oneLineTemplateExpanding = true;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)callback2.getFile());
        if (callback2.isInInjectedFragment()) {
            Editor editor = callback2.getEditor();
            Document document = editor.getDocument();
            if (document instanceof DocumentWindow && ((DocumentWindow)document).isOneLine()) {
                oneLineTemplateExpanding = true;
                filters.add(new SingleLineEmmetFilter());
            }
            indentStr = "";
        } else if (settings.useTabCharacter(callback2.getFileType())) {
            indentStr = "\t";
        } else {
            int tabSize = settings.getTabSize(callback2.getFileType());
            indentStr = StringUtil.repeatSymbol((char)' ', (int)tabSize);
        }
        LiveTemplateBuilder builder2 = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        int end = -1;
        boolean bl = hasChildren = this.myChildren.size() > 0;
        if (generator instanceof XmlZenCodingGenerator) {
            TemplateToken xmlTemplateToken = this.myTemplateToken;
            parentTemplate = this.invokeXmlTemplate(xmlTemplateToken, callback2, generator, hasChildren);
            predefinedValues = this.buildPredefinedValues(xmlTemplateToken.getAttributes(), (XmlZenCodingGenerator)generator, hasChildren);
        } else {
            parentTemplate = GenerationNode.invokeTemplate(this.myTemplateToken, hasChildren, callback2, generator);
            predefinedValues = null;
        }
        String s = parentTemplate.getString();
        for (ZenCodingFilter filter : filters) {
            s = filter.filterText(s, this.myTemplateToken);
        }
        parentTemplate = parentTemplate.copy();
        parentTemplate.setString(s);
        String txt = hasChildren || this.myContainsSurroundedTextMarker ? null : this.mySurroundedText;
        parentTemplate = GenerationNode.expandTemplate(parentTemplate, predefinedValues, txt, segmentsLimit);
        int offset = builder2.insertTemplate(0, parentTemplate, null);
        int newOffset = GenerationNode.gotoChild(callback2.getProject(), builder2.getText(), offset, 0, builder2.length());
        if (offset < builder2.length() && newOffset != offset) {
            end = offset;
        }
        offset = newOffset;
        if (end == -1 && offset < builder2.length() && this.myChildren.size() == 0) {
            end = offset;
        }
        LiveTemplateBuilder.Marker marker = offset < builder2.length() ? builder2.createMarker(offset) : null;
        int myChildrenSize = this.myChildren.size();
        for (int i = 0; i < myChildrenSize; ++i) {
            GenerationNode child2 = this.myChildren.get(i);
            TemplateImpl childTemplate = child2.generate(callback2, generator, filters, !this.myContainsSurroundedTextMarker, segmentsLimit);
            boolean blockTag = child2.isBlockTag();
            if (!oneLineTemplateExpanding && blockTag && !GenerationNode.isNewLineBefore(builder2.getText(), offset)) {
                builder2.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            int e = builder2.insertTemplate(offset, childTemplate, null);
            int n = offset = marker != null ? marker.getEndOffset() : builder2.length();
            if (!oneLineTemplateExpanding && (blockTag && !GenerationNode.isNewLineAfter(builder2.getText(), offset) || this.myInsertNewLineBetweenNodes)) {
                builder2.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            if (end != -1 || e >= offset) continue;
            end = e;
        }
        if (shouldNotReformatTemplate) {
            builder2.setIsToReformat(false);
        }
        return builder2.buildTemplate();
    }

    private static TemplateImpl invokeTemplate(@NotNull TemplateToken token, boolean hasChildren, CustomTemplateCallback callback2, @Nullable ZenCodingGenerator generator) {
        TemplateImpl template = token.getTemplate();
        if (generator != null) {
            assert (template != null);
            template = generator.generateTemplate(token, hasChildren, callback2.getContext());
            GenerationNode.removeVariablesWhichHasNoSegment(template);
        }
        return template;
    }

    private TemplateImpl invokeXmlTemplate(TemplateToken token, CustomTemplateCallback callback2, @Nullable ZenCodingGenerator generator, boolean hasChildren) {
        ZenCodingGenerator zenCodingGenerator = (ZenCodingGenerator)ObjectUtils.notNull((Object)generator, (Object)XmlZenCodingGeneratorImpl.INSTANCE);
        Map<String, String> attributes = token.getAttributes();
        TemplateImpl template = token.getTemplate();
        assert (template != null);
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)callback2.getProject());
        PsiFile dummyFile = fileFactory.createFileFromText("dummy.html", callback2.getFile().getLanguage(), (CharSequence)token.getTemplateText(), false, true);
        XmlTag tag = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)dummyFile, XmlTag.class);
        if (tag != null) {
            if (EmmetOptions.getInstance().isHrefAutoDetectEnabled() && StringUtil.isNotEmpty((String)this.mySurroundedText)) {
                boolean isEmptyLinkTag;
                boolean bl = isEmptyLinkTag = "a".equalsIgnoreCase(tag.getName()) && GenerationNode.isEmptyValue(tag.getAttributeValue("href"));
                if (!hasChildren && isEmptyLinkTag) {
                    if (HREF_PATTERN.matcher(this.mySurroundedText).matches()) {
                        attributes.put("href", PROTOCOL_PATTERN.matcher(this.mySurroundedText).find() ? this.mySurroundedText.trim() : "http://" + this.mySurroundedText.trim());
                    } else if (EMAIL_PATTERN.matcher(this.mySurroundedText).matches()) {
                        attributes.put("href", "mailto:" + this.mySurroundedText.trim());
                    }
                }
            }
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                if (!Strings.isNullOrEmpty((String)attribute.getValue())) continue;
                template.addVariable(GenerationNode.prepareVariableName(attribute.getKey()), "", "", true);
            }
            XmlTag tag1 = hasChildren ? GenerationNode.expandEmptyTagIfNecessary(tag) : tag;
            this.setAttributeValues(tag1, attributes, callback2, zenCodingGenerator.isHtml(callback2));
            token.setTemplateText(tag1.getContainingFile().getText(), callback2);
        }
        template = zenCodingGenerator.generateTemplate(token, hasChildren, callback2.getContext());
        GenerationNode.removeVariablesWhichHasNoSegment(template);
        return template;
    }

    private static String prepareVariableName(@NotNull String attributeName) {
        char[] toReplace = new char[]{'$', '-', '+', ':'};
        StringBuilder builder2 = new StringBuilder(attributeName.length());
        for (int i = 0; i < attributeName.length(); ++i) {
            char c = attributeName.charAt(i);
            boolean replaced = false;
            for (char aToReplace : toReplace) {
                if (c != aToReplace) continue;
                builder2.append('_');
                replaced = true;
                break;
            }
            if (replaced) continue;
            builder2.append(c);
        }
        return builder2.toString();
    }

    @NotNull
    private static TemplateImpl expandTemplate(@NotNull TemplateImpl template, Map<String, String> predefinedVarValues, String surroundedText, int segmentsLimit) {
        LiveTemplateBuilder builder2 = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        if (predefinedVarValues == null && surroundedText == null) {
            return template;
        }
        int offset = builder2.insertTemplate(0, template, predefinedVarValues);
        if (surroundedText != null) {
            builder2.insertText(offset, surroundedText, true);
            builder2.setIsToReformat(true);
        }
        return builder2.buildTemplate();
    }

    @NotNull
    private static XmlTag expandEmptyTagIfNecessary(@NotNull XmlTag tag) {
        StringBuilder builder2 = new StringBuilder();
        boolean flag = false;
        for (PsiElement child2 : tag.getChildren()) {
            if (child2 instanceof XmlToken && XmlTokenType.XML_EMPTY_ELEMENT_END.equals(((XmlToken)child2).getTokenType())) {
                flag = true;
                break;
            }
            builder2.append(child2.getText());
        }
        if (flag) {
            builder2.append("></").append(tag.getName()).append('>');
            return XmlElementFactory.getInstance((Project)tag.getProject()).createTagFromText((CharSequence)builder2.toString(), (Language)XMLLanguage.INSTANCE);
        }
        return tag;
    }

    private static int gotoChild(Project project, CharSequence text, int offset, int start2, int end) {
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, text, LocalTimeCounter.currentTime(), false);
        PsiElement element = file2.findElementAt(offset);
        if (offset < end && element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_END_TAG_START) {
            return offset;
        }
        int newOffset = -1;
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)start2, (int)end, XmlTag.class);
        if (tag != null) {
            for (PsiElement child2 : tag.getChildren()) {
                if (!(child2 instanceof XmlToken) || ((XmlToken)child2).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
                newOffset = child2.getTextOffset();
            }
        }
        if (newOffset >= 0) {
            return newOffset;
        }
        return offset;
    }

    private static void removeVariablesWhichHasNoSegment(TemplateImpl template) {
        int i;
        HashSet<String> segments = new HashSet<String>();
        for (i = 0; i < template.getSegmentsCount(); ++i) {
            segments.add(template.getSegmentName(i));
        }
        for (i = template.getVariableCount() - 1; i >= 0; --i) {
            String varName = template.getVariableNameAt(i);
            if (!segments.contains(varName)) {
                template.removeVariable(i);
                continue;
            }
            segments.remove(varName);
        }
    }

    @Nullable
    private Map<String, String> buildPredefinedValues(@NotNull Map<String, String> attributes, @Nullable XmlZenCodingGenerator generator, boolean hasChildren) {
        String attributesString;
        if (generator == null) {
            return Collections.emptyMap();
        }
        for (String value : attributes.values()) {
            if (!ZenCodingUtil.containsSurroundedTextMarker(value)) continue;
            this.myContainsSurroundedTextMarker = true;
            break;
        }
        attributesString = (attributesString = generator.buildAttributesString(attributes, hasChildren, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText)).length() > 0 ? ' ' + attributesString : null;
        HashMap<String, String> predefinedValues = null;
        if (attributesString != null) {
            predefinedValues = new HashMap<String, String>();
            predefinedValues.put("ATTRS", attributesString);
        }
        return predefinedValues;
    }

    private void setAttributeValues(@NotNull XmlTag tag, @NotNull Map<String, String> attributes, @NotNull CustomTemplateCallback callback2, boolean isHtml) {
        String defaultAttributeValue = attributes.get("%default");
        if (defaultAttributeValue != null) {
            String attributeName;
            attributes.remove("%default");
            List xmlAttributes = ContainerUtil.filter((Object[])tag.getAttributes(), attribute -> !attributes.containsKey(attribute.getLocalName()));
            XmlAttribute defaultAttribute = GenerationNode.findImpliedAttribute(xmlAttributes);
            if (defaultAttribute == null) {
                defaultAttribute = GenerationNode.findEmptyAttribute(xmlAttributes);
            }
            if (defaultAttribute != null && (attributeName = defaultAttribute.getName()).length() > 1) {
                String oldValue;
                if (GenerationNode.isImpliedAttribute(attributeName)) {
                    defaultAttribute = (XmlAttribute)defaultAttribute.setName(attributeName.substring(1));
                }
                if ((oldValue = defaultAttribute.getValue()) != null && StringUtil.containsChar((String)oldValue, (char)'|')) {
                    defaultAttribute.setValue(StringUtil.replace((String)oldValue, (String)"|", (String)defaultAttributeValue));
                } else {
                    defaultAttribute.setValue(defaultAttributeValue);
                }
            }
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String attributeName = xmlAttribute.getName();
            XmlAttributeValue xmlAttributeValueElement = xmlAttribute.getValueElement();
            if (xmlAttributeValueElement != null && !attributes.containsKey(attributeName) || !ZenCodingUtil.isXML11ValidQName(attributeName)) continue;
            String attributeValue = StringUtil.notNullize((String)attributes.get(attributeName), (String)StringUtil.notNullize((String)xmlAttribute.getValue()));
            if (ZenCodingUtil.containsSurroundedTextMarker(attributeValue)) {
                this.myContainsSurroundedTextMarker = true;
            }
            if (isHtml && GenerationNode.isBooleanAttribute(attributeValue, xmlAttribute, callback2)) {
                if (HtmlUtil.isShortNotationOfBooleanAttributePreferred()) {
                    PsiElement prevSibling;
                    if (xmlAttributeValueElement == null || (prevSibling = xmlAttributeValueElement.getPrevSibling()) == null || !prevSibling.textMatches((CharSequence)"=")) continue;
                    xmlAttribute.deleteChildRange(prevSibling, (PsiElement)xmlAttributeValueElement);
                    continue;
                }
                if (xmlAttributeValueElement == null) {
                    xmlAttribute.delete();
                }
                tag.setAttribute(attributeName, attributeName);
                continue;
            }
            if (xmlAttributeValueElement == null) {
                xmlAttribute.delete();
            }
            tag.setAttribute(attributeName, StringUtil.isEmpty((String)attributeValue) ? "$" + GenerationNode.prepareVariableName(attributeName) + "$" : ZenCodingUtil.getValue(attributeValue, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText));
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String xmlAttributeLocalName = xmlAttribute.getLocalName();
            if (xmlAttribute.getValue() == null || !GenerationNode.isImpliedAttribute(xmlAttributeLocalName)) continue;
            xmlAttribute.delete();
        }
    }

    private static boolean isBooleanAttribute(@Nullable String attributeValue, @NotNull XmlAttribute xmlAttribute, @NotNull CustomTemplateCallback callback2) {
        if ("%boolean".equals(attributeValue)) {
            return true;
        }
        if (StringUtil.isEmpty((String)attributeValue)) {
            XmlAttributeDescriptor descriptor = xmlAttribute.getDescriptor();
            return descriptor != null && HtmlUtil.isBooleanAttribute(descriptor, callback2.getContext());
        }
        return false;
    }

    private static boolean isImpliedAttribute(String xmlAttributeLocalName) {
        return StringUtil.startsWithChar((CharSequence)xmlAttributeLocalName, (char)'!');
    }

    private static boolean isEmptyValue(String attributeValue) {
        return attributeValue != null && (attributeValue.isEmpty() || ATTRIBUTE_VARIABLE_PATTERN.matcher(attributeValue).matches());
    }

    @Nullable
    private static XmlAttribute findImpliedAttribute(@NotNull List<? extends XmlAttribute> attributes) {
        for (XmlAttribute xmlAttribute : attributes) {
            if (xmlAttribute.getValueElement() == null || !GenerationNode.isImpliedAttribute(xmlAttribute.getLocalName())) continue;
            return xmlAttribute;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute findEmptyAttribute(@NotNull List<? extends XmlAttribute> attributes) {
        for (XmlAttribute xmlAttribute : attributes) {
            String attributeValue = xmlAttribute.getValue();
            if (!GenerationNode.isEmptyValue(attributeValue)) continue;
            return xmlAttribute;
        }
        return null;
    }

    private static boolean isNewLineBefore(CharSequence text, int offset) {
        int i;
        for (i = offset - 1; i >= 0 && Character.isWhitespace(text.charAt(i)); --i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return i < 0;
    }

    private static boolean isNewLineAfter(CharSequence text, int offset) {
        int i;
        for (i = offset; i < text.length() && Character.isWhitespace(text.charAt(i)); ++i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return i == text.length();
    }

    public TemplateToken getTemplateToken() {
        return this.myTemplateToken;
    }

    public String getSurroundedText() {
        return this.mySurroundedText;
    }

    public void setSurroundedText(String surroundedText) {
        this.mySurroundedText = surroundedText;
    }

    public GenerationNode getParent() {
        return this.myParent;
    }

    public void setParent(GenerationNode parent) {
        this.myParent = parent;
    }
}

