/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MulOperationNode
extends ZenCodingNode {
    private final ZenCodingNode myLeftOperand;
    private final int myRightOperand;

    public MulOperationNode(ZenCodingNode leftOperand, int rightOperand) {
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
    }

    public ZenCodingNode getLeftOperand() {
        return this.myLeftOperand;
    }

    public int getRightOperand() {
        return this.myRightOperand;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback2, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        ArrayList<GenerationNode> result2 = new ArrayList<GenerationNode>();
        for (int i = 0; i < this.myRightOperand; ++i) {
            result2.addAll(this.myLeftOperand.expand(i, this.myRightOperand, surroundedText, callback2, insertSurroundedTextAtTheEnd, parent));
        }
        return result2;
    }

    @Override
    public int getApproximateOutputLength(@Nullable CustomTemplateCallback callback2) {
        return this.myLeftOperand.getApproximateOutputLength(callback2) * this.myRightOperand;
    }

    public String toString() {
        return "*";
    }
}

