/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnaryMulOperationNode
extends ZenCodingNode {
    private final ZenCodingNode myOperand;

    public UnaryMulOperationNode(ZenCodingNode operand) {
        this.myOperand = operand;
    }

    public ZenCodingNode getOperand() {
        return this.myOperand;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback2, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        if (surroundedText == null) {
            return this.myOperand.expand(numberInIteration, totalIterations, null, callback2, insertSurroundedTextAtTheEnd, parent);
        }
        String[] lines2 = LineTokenizer.tokenize((CharSequence)StringUtil.trim((String)surroundedText), (boolean)false);
        ArrayList<GenerationNode> result2 = new ArrayList<GenerationNode>();
        for (int i = 0; i < lines2.length; ++i) {
            String line = lines2[i].trim();
            result2.addAll(this.myOperand.expand(i, lines2.length, line, callback2, insertSurroundedTextAtTheEnd, parent));
        }
        return result2;
    }

    @Override
    public int getApproximateOutputLength(@Nullable CustomTemplateCallback callback2) {
        return this.myOperand.getApproximateOutputLength(callback2);
    }

    public String toString() {
        return "*";
    }
}

