/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InvokeTemplateAction
extends AnAction {
    private final TemplateImpl myTemplate;
    private final Editor myEditor;
    private final Project myProject;

    public InvokeTemplateAction(TemplateImpl template, Editor editor, Project project, Set<Character> usedMnemonicsSet) {
        super(InvokeTemplateAction.extractMnemonic(template.getKey(), usedMnemonicsSet) + (StringUtil.isEmptyOrSpaces((String)template.getDescription()) ? "" : ". " + template.getDescription()));
        this.myTemplate = template;
        this.myProject = project;
        this.myEditor = editor;
    }

    public static String extractMnemonic(String caption, Set<? super Character> usedMnemonics) {
        if (StringUtil.isEmpty((String)caption)) {
            return "";
        }
        for (int i = 0; i < caption.length(); ++i) {
            char c = caption.charAt(i);
            if (!usedMnemonics.add(Character.valueOf(Character.toUpperCase(c)))) continue;
            return caption.substring(0, i) + '\u001b' + caption.substring(i);
        }
        return caption + " ";
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.perform();
    }

    public void perform() {
        Document document = this.myEditor.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(Collections.singletonList(file2));
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.myEditor.getCaretModel().runForEachCaret(__ -> {
            if (this.myEditor.getSelectionModel().hasSelection() && this.myTemplate.isToReformat()) {
                int offset;
                int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
                int lineEnd = document.getLineEndOffset(document.getLineNumber(offset));
                for (offset = this.myEditor.getSelectionModel().getSelectionStart(); offset < lineEnd && offset < selectionEnd && (document.getCharsSequence().charAt(offset) == ' ' || document.getCharsSequence().charAt(offset) == '\t'); ++offset) {
                }
                if (selectionEnd == document.getLineStartOffset(document.getLineNumber(selectionEnd))) {
                    --selectionEnd;
                }
                if (offset < lineEnd && offset < selectionEnd) {
                    this.myEditor.getSelectionModel().setSelection(offset, selectionEnd);
                }
            }
            String selectionString = this.myEditor.getSelectionModel().getSelectedText();
            TemplateManager.getInstance(this.myProject).startTemplate(this.myEditor, selectionString, this.myTemplate);
        }), "Wrap with template", (Object)("Wrap with template " + this.myTemplate.getKey()));
    }
}

