/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

class LiveTemplateRunLogger {
    private static final String GROUP = "live.templates";

    LiveTemplateRunLogger() {
    }

    static void log(@NotNull TemplateImpl template, @NotNull Language language) {
        String groupName;
        String key = template.getKey();
        if (LiveTemplateRunLogger.isCreatedProgrammatically(key, groupName = template.getGroupName())) {
            return;
        }
        PluginInfo plugin = TemplateSettings.getInstance().findPluginForPredefinedTemplate(template);
        if (plugin == null) {
            key = "user.defined.template";
            groupName = "user.defined.group";
        } else if (!plugin.isSafeToReport()) {
            key = "custom.plugin.template";
            groupName = "custom.plugin.group";
        }
        FeatureUsageData data = new FeatureUsageData().addLanguage(language).addData("group", groupName);
        if (plugin != null) {
            data.addPluginInfo(plugin);
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, key, data);
    }

    private static boolean isCreatedProgrammatically(String key, String groupName) {
        return StringUtil.isEmpty((String)key) || StringUtil.isEmpty((String)groupName);
    }
}

