/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.AbstractBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.DefaultLiveTemplatesProvider;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.CompoundScheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import kotlin.Lazy;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TemplateSettings", storages={@Storage(value="templates.xml")}, additionalExportFile="templates")
public class TemplateSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(TemplateSettings.class);
    @NonNls
    public static final String USER_GROUP_NAME = "user";
    @NonNls
    private static final String TEMPLATE_SET = "templateSet";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    public static final String TEMPLATE = "template";
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';
    public static final char ENTER_CHAR = '\n';
    public static final char DEFAULT_CHAR = 'D';
    public static final char CUSTOM_CHAR = 'C';
    public static final char NONE_CHAR = 'N';
    @NonNls
    private static final String SPACE = "SPACE";
    @NonNls
    private static final String TAB = "TAB";
    @NonNls
    private static final String ENTER = "ENTER";
    @NonNls
    private static final String CUSTOM = "CUSTOM";
    @NonNls
    private static final String NONE = "NONE";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHORTCUT = "shortcut";
    @NonNls
    private static final String VARIABLE = "variable";
    @NonNls
    private static final String EXPRESSION = "expression";
    @NonNls
    private static final String DEFAULT_VALUE = "defaultValue";
    @NonNls
    private static final String ALWAYS_STOP_AT = "alwaysStopAt";
    @NonNls
    static final String CONTEXT = "context";
    @NonNls
    private static final String TO_REFORMAT = "toReformat";
    @NonNls
    private static final String TO_SHORTEN_FQ_NAMES = "toShortenFQNames";
    @NonNls
    private static final String USE_STATIC_IMPORT = "useStaticImport";
    @NonNls
    private static final String DEACTIVATED = "deactivated";
    @NonNls
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String ID = "id";
    static final String TEMPLATES_DIR_PATH = "templates";
    private final MultiMap<String, TemplateImpl> myTemplates = MultiMap.createLinked();
    private final Map<String, Template> myTemplatesById = new LinkedHashMap<String, Template>();
    private final Map<TemplateKey, TemplateImpl> myDefaultTemplates = new LinkedHashMap<TemplateKey, TemplateImpl>();
    private int myMaxKeyLength = 0;
    private final SchemeManager<TemplateGroup> mySchemeManager;
    private State myState = new State();
    private final Map<Pair<String, String>, PluginInfo> myPredefinedTemplates = new HashMap<Pair<String, String>, PluginInfo>();
    private TemplateKey myLastSelectedTemplate;

    public TemplateSettings(@NotNull SchemeManagerFactory schemeManagerFactory) {
        this.mySchemeManager = schemeManagerFactory.create(TEMPLATES_DIR_PATH, new BaseSchemeProcessor<TemplateGroup, TemplateGroup>(){

            @Override
            @Nullable
            public TemplateGroup readScheme(@NotNull Element element, boolean duringLoad) {
                TemplateGroup group;
                TemplateGroup readGroup = TemplateSettings.parseTemplateGroup(element, element.getAttributeValue(TemplateSettings.GROUP), this.getClass().getClassLoader());
                TemplateGroup templateGroup = group = readGroup == null ? null : TemplateSettings.this.mergeParsedGroup(element, false, false, readGroup);
                if (group != null) {
                    group.setModified(false);
                }
                return group;
            }

            @Override
            public void beforeReloaded(@NotNull SchemeManager<TemplateGroup> schemeManager2) {
                for (TemplateGroup group : schemeManager2.getAllSchemes()) {
                    schemeManager2.removeScheme(group);
                }
                TemplateSettings.this.myTemplates.clear();
                TemplateSettings.this.myDefaultTemplates.clear();
            }

            @Override
            public void reloaded(@NotNull SchemeManager<TemplateGroup> schemeManager2, @NotNull Collection<? extends TemplateGroup> groups) {
                TemplateSettings.this.doLoadTemplates(groups);
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull TemplateGroup template) {
                if (template.isModified()) {
                    return SchemeState.POSSIBLY_CHANGED;
                }
                for (TemplateImpl t : template.getElements()) {
                    if (!TemplateSettings.this.differsFromDefault(t)) continue;
                    return SchemeState.POSSIBLY_CHANGED;
                }
                return SchemeState.NON_PERSISTENT;
            }

            @NotNull
            public Element writeScheme(@NotNull TemplateGroup template) {
                Element templateSetElement = new Element(TemplateSettings.TEMPLATE_SET);
                List elements = template.getElements();
                if (!elements.isEmpty()) {
                    boolean isGroupAttributeAdded = false;
                    Lazy<Map<String, TemplateContextType>> idToType2 = TemplateContext.getIdToType();
                    for (TemplateImpl t : elements) {
                        TemplateImpl defaultTemplate = TemplateSettings.this.getDefaultTemplate(t);
                        if (defaultTemplate != null && t.equals(defaultTemplate) && t.contextsEqual(defaultTemplate)) continue;
                        if (!isGroupAttributeAdded) {
                            isGroupAttributeAdded = true;
                            templateSetElement.setAttribute(TemplateSettings.GROUP, template.getName());
                        }
                        templateSetElement.addContent(TemplateSettings.serializeTemplate(t, defaultTemplate, idToType2));
                    }
                }
                template.setModified(false);
                return templateSetElement;
            }

            @Override
            public void onSchemeAdded(@NotNull TemplateGroup scheme2) {
                for (TemplateImpl template : scheme2.getElements()) {
                    TemplateSettings.this.addTemplateImpl(template);
                }
            }

            @Override
            public void onSchemeDeleted(@NotNull TemplateGroup scheme2) {
                for (TemplateImpl template : scheme2.getElements()) {
                    TemplateSettings.this.removeTemplate(template);
                }
            }
        });
        this.doLoadTemplates(this.mySchemeManager.loadSchemes());
    }

    private void doLoadTemplates(@NotNull Collection<? extends TemplateGroup> groups) {
        for (TemplateGroup templateGroup : groups) {
            for (TemplateImpl template : templateGroup.getElements()) {
                this.addTemplateImpl(template);
            }
        }
        this.loadDefaultLiveTemplates();
    }

    public static TemplateSettings getInstance() {
        return (TemplateSettings)ServiceManager.getService(TemplateSettings.class);
    }

    private boolean differsFromDefault(TemplateImpl t) {
        TemplateImpl def = this.getDefaultTemplate(t);
        return def == null || !t.equals(def) || !t.contextsEqual(def);
    }

    @Nullable
    public TemplateImpl getDefaultTemplate(TemplateImpl t) {
        return this.myDefaultTemplates.get(TemplateKey.keyOf(t));
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        this.applyNewDeletedTemplates();
    }

    void applyNewDeletedTemplates() {
        for (TemplateKey templateKey : this.myState.deletedKeys) {
            if (templateKey.groupName == null) {
                for (TemplateImpl template : new ArrayList(this.myTemplates.get((Object)templateKey.key))) {
                    this.removeTemplate(template);
                }
                continue;
            }
            TemplateImpl toDelete = this.getTemplate(templateKey.key, templateKey.groupName);
            if (toDelete == null) continue;
            this.removeTemplate(toDelete);
        }
    }

    @Nullable
    public String getLastSelectedTemplateKey() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.key : null;
    }

    @Nullable
    public String getLastSelectedTemplateGroup() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.groupName : null;
    }

    public void setLastSelectedTemplate(@Nullable String group, @Nullable String key) {
        this.myLastSelectedTemplate = group == null ? null : new TemplateKey(group, key);
    }

    public Collection<? extends TemplateImpl> getTemplatesAsList() {
        return this.myTemplates.values();
    }

    public TemplateImpl[] getTemplates() {
        Collection all = this.myTemplates.values();
        return all.toArray(new TemplateImpl[0]);
    }

    public char getDefaultShortcutChar() {
        return this.myState.defaultShortcut;
    }

    public void setDefaultShortcutChar(char defaultShortcutChar) {
        this.myState.defaultShortcut = defaultShortcutChar;
    }

    @NotNull
    public Collection<TemplateImpl> getTemplates(@NotNull String key) {
        return this.myTemplates.get((Object)key);
    }

    @Nullable
    public TemplateImpl getTemplate(@NonNls String key, String group) {
        Collection templates = this.myTemplates.get((Object)key);
        for (TemplateImpl template : templates) {
            if (!template.getGroupName().equals(group)) continue;
            return template;
        }
        return null;
    }

    public Template getTemplateById(@NonNls String id) {
        return this.myTemplatesById.get(id);
    }

    public int getMaxKeyLength() {
        return this.myMaxKeyLength;
    }

    public void addTemplate(Template template) {
        this.clearPreviouslyRegistered(template);
        this.addTemplateImpl(template);
        TemplateImpl templateImpl = (TemplateImpl)template;
        String groupName = templateImpl.getGroupName();
        TemplateGroup group = this.mySchemeManager.findSchemeByName(groupName);
        if (group == null) {
            group = new TemplateGroup(groupName);
            this.mySchemeManager.addScheme(group);
        }
        group.addElement(templateImpl);
    }

    private void clearPreviouslyRegistered(Template template) {
        TemplateImpl existing = this.getTemplate(template.getKey(), ((TemplateImpl)template).getGroupName());
        if (existing != null) {
            LOG.info("Template with key " + template.getKey() + " and id " + template.getId() + " already registered");
            TemplateGroup group = this.mySchemeManager.findSchemeByName(existing.getGroupName());
            if (group != null) {
                group.removeElement(existing);
                if (group.isEmpty()) {
                    this.mySchemeManager.removeScheme(group);
                }
            }
            this.myTemplates.remove((Object)template.getKey(), (Object)existing);
        }
    }

    private void addTemplateImpl(@NotNull Template template) {
        TemplateImpl templateImpl = (TemplateImpl)template;
        if (this.getTemplate(templateImpl.getKey(), templateImpl.getGroupName()) == null) {
            this.myTemplates.putValue((Object)template.getKey(), (Object)templateImpl);
        }
        this.myMaxKeyLength = Math.max(this.myMaxKeyLength, template.getKey().length());
        this.myState.deletedKeys.remove(TemplateKey.keyOf((TemplateImpl)template));
    }

    private void addTemplateById(Template template) {
        String id;
        if (!this.myTemplatesById.containsKey(template.getId()) && (id = template.getId()) != null) {
            this.myTemplatesById.put(id, template);
        }
    }

    public void removeTemplate(@NotNull Template template) {
        this.myTemplates.remove((Object)template.getKey(), (Object)((TemplateImpl)template));
        TemplateGroup group = this.mySchemeManager.findSchemeByName(((TemplateImpl)template).getGroupName());
        if (group != null) {
            group.removeElement((TemplateImpl)template);
            if (group.isEmpty()) {
                this.mySchemeManager.removeScheme(group);
            }
        }
    }

    @NotNull
    private static TemplateImpl createTemplate(@NotNull String key, String string, @NotNull String group, String description, @Nullable String shortcut, String id) {
        TemplateImpl template = new TemplateImpl(key, string, group, false);
        template.setId(id);
        template.setDescription(description);
        if (TAB.equals(shortcut)) {
            template.setShortcutChar('\t');
        } else if (ENTER.equals(shortcut)) {
            template.setShortcutChar('\n');
        } else if (SPACE.equals(shortcut)) {
            template.setShortcutChar(' ');
        } else if (NONE.equals(shortcut)) {
            template.setShortcutChar('N');
        } else {
            template.setShortcutChar('D');
        }
        return template;
    }

    private void loadDefaultLiveTemplates() {
        try {
            for (DefaultLiveTemplatesProvider provider : DefaultLiveTemplatesProvider.EP_NAME.getExtensionList()) {
                for (String defTemplate : provider.getDefaultLiveTemplateFiles()) {
                    this.readDefTemplate(provider, defTemplate, true);
                }
                try {
                    String[] hidden = provider.getHiddenLiveTemplateFiles();
                    if (hidden == null) continue;
                    for (String s : hidden) {
                        this.readDefTemplate(provider, s, false);
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                }
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void readDefTemplate(@NotNull DefaultLiveTemplatesProvider provider, @NotNull String defTemplate, boolean registerTemplate) throws JDOMException, InvalidDataException, IOException {
        Element element;
        TemplateGroup defGroup;
        InputStream inputStream = DecodeDefaultsUtil.getDefaultsInputStream(provider, defTemplate);
        if (inputStream != null && (defGroup = TemplateSettings.parseTemplateGroup(element = JDOMUtil.load((InputStream)inputStream), TemplateSettings.getDefaultTemplateName(defTemplate), provider.getClass().getClassLoader())) != null) {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(provider.getClass());
            for (TemplateImpl template : defGroup.getElements()) {
                String key = template.getKey();
                String groupName = template.getGroupName();
                if (!StringUtil.isNotEmpty((String)key) || !StringUtil.isNotEmpty((String)groupName)) continue;
                this.myPredefinedTemplates.put((Pair<String, String>)Pair.create((Object)key, (Object)groupName), info);
            }
            TemplateGroup group = this.mergeParsedGroup(element, true, registerTemplate, defGroup);
            if (group != null && group.getReplace() != null) {
                for (TemplateImpl template : this.myTemplates.get((Object)group.getReplace())) {
                    this.removeTemplate(template);
                }
            }
        }
    }

    @Nullable
    public PluginInfo findPluginForPredefinedTemplate(TemplateImpl template) {
        return this.myPredefinedTemplates.get(Pair.create((Object)template.getKey(), (Object)template.getGroupName()));
    }

    private static String getDefaultTemplateName(String defTemplate) {
        return defTemplate.substring(defTemplate.lastIndexOf(47) + 1);
    }

    @Nullable
    private static TemplateGroup parseTemplateGroup(@NotNull Element element, @NonNls String defGroupName, @NotNull ClassLoader classLoader) {
        if (!TEMPLATE_SET.equals(element.getName())) {
            LOG.error("Ignore invalid template scheme: " + JDOMUtil.writeElement((Element)element));
            return null;
        }
        String groupName = element.getAttributeValue(GROUP);
        if (StringUtil.isEmpty((String)groupName)) {
            groupName = defGroupName;
        }
        TemplateGroup result2 = new TemplateGroup(groupName, element.getAttributeValue("REPLACE"));
        for (Element child2 : element.getChildren(TEMPLATE)) {
            try {
                result2.addElement(TemplateSettings.readTemplateFromElement(groupName, child2, classLoader));
            }
            catch (Exception e) {
                LOG.warn("failed to load template " + element.getAttributeValue(NAME), (Throwable)e);
            }
        }
        return result2;
    }

    @Nullable
    private TemplateGroup mergeParsedGroup(@NotNull Element element, boolean isDefault, boolean registerTemplate, TemplateGroup parsedGroup) {
        Object existingScheme;
        Object result2 = new TemplateGroup(parsedGroup.getName(), element.getAttributeValue("REPLACE"));
        LinkedHashMap<String, TemplateImpl> created = new LinkedHashMap<String, TemplateImpl>();
        for (TemplateImpl template : parsedGroup.getElements()) {
            boolean defaultTemplateModified;
            if (isDefault) {
                this.myDefaultTemplates.put(TemplateKey.keyOf(template), template);
            }
            TemplateImpl existing = this.getTemplate(template.getKey(), template.getGroupName());
            boolean bl = defaultTemplateModified = isDefault && (this.myState.deletedKeys.contains(TemplateKey.keyOf(template)) || this.myTemplatesById.containsKey(template.getId()) || existing != null);
            if (!defaultTemplateModified) {
                created.put(template.getKey(), template);
            }
            if (!isDefault || existing == null) continue;
            existing.getTemplateContext().setDefaultContext(template.getTemplateContext());
        }
        if (registerTemplate && (existingScheme = this.mySchemeManager.findSchemeByName(((CompoundScheme)result2).getName())) != null) {
            result2 = existingScheme;
        }
        existingScheme = created.values().iterator();
        while (existingScheme.hasNext()) {
            TemplateImpl template;
            template = (TemplateImpl)existingScheme.next();
            if (registerTemplate) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
            this.addTemplateById(template);
            ((CompoundScheme)result2).addElement(template);
        }
        if (registerTemplate && (existingScheme = this.mySchemeManager.findSchemeByName(((CompoundScheme)result2).getName())) == null && !((CompoundScheme)result2).isEmpty()) {
            this.mySchemeManager.addScheme((TemplateGroup)result2, false);
        }
        return ((CompoundScheme)result2).isEmpty() ? null : result2;
    }

    public static TemplateImpl readTemplateFromElement(String groupName, @NotNull Element element, @NotNull ClassLoader classLoader) {
        String description;
        String name = element.getAttributeValue(NAME);
        String value = element.getAttributeValue(VALUE);
        String resourceBundle = element.getAttributeValue(RESOURCE_BUNDLE);
        String key = element.getAttributeValue(KEY);
        String id = element.getAttributeValue(ID);
        if (resourceBundle != null && key != null) {
            ResourceBundle bundle = AbstractBundle.getResourceBundle((String)resourceBundle, (ClassLoader)classLoader);
            description = bundle.getString(key);
        } else {
            description = element.getAttributeValue(DESCRIPTION);
        }
        String shortcut = element.getAttributeValue(SHORTCUT);
        TemplateImpl template = TemplateSettings.createTemplate(name, value, groupName, description, shortcut, id);
        template.setToReformat(Boolean.parseBoolean(element.getAttributeValue(TO_REFORMAT)));
        template.setToShortenLongNames(Boolean.parseBoolean(element.getAttributeValue(TO_SHORTEN_FQ_NAMES)));
        template.setDeactivated(Boolean.parseBoolean(element.getAttributeValue(DEACTIVATED)));
        String useStaticImport = element.getAttributeValue(USE_STATIC_IMPORT);
        if (useStaticImport != null) {
            template.setValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE, Boolean.parseBoolean(useStaticImport));
        }
        for (Element e : element.getChildren(VARIABLE)) {
            String variableName = e.getAttributeValue(NAME);
            String expression = e.getAttributeValue(EXPRESSION);
            String defaultValue = e.getAttributeValue(DEFAULT_VALUE);
            boolean isAlwaysStopAt = Boolean.parseBoolean(e.getAttributeValue(ALWAYS_STOP_AT));
            template.addVariable(variableName, expression, defaultValue, isAlwaysStopAt);
        }
        Element context = element.getChild(CONTEXT);
        if (context != null) {
            template.getTemplateContext().readTemplateContext(context);
        }
        return template;
    }

    @NotNull
    public static Element serializeTemplate(@NotNull TemplateImpl template, @Nullable TemplateImpl defaultTemplate, @NotNull Lazy<Map<String, TemplateContextType>> idToType2) {
        Element element = new Element(TEMPLATE);
        String id = template.getId();
        if (id != null) {
            element.setAttribute(ID, id);
        }
        element.setAttribute(NAME, template.getKey());
        element.setAttribute(VALUE, template.getString());
        if (template.getShortcutChar() == '\t') {
            element.setAttribute(SHORTCUT, TAB);
        } else if (template.getShortcutChar() == '\n') {
            element.setAttribute(SHORTCUT, ENTER);
        } else if (template.getShortcutChar() == ' ') {
            element.setAttribute(SHORTCUT, SPACE);
        } else if (template.getShortcutChar() == 'N') {
            element.setAttribute(SHORTCUT, NONE);
        }
        if (template.getDescription() != null) {
            element.setAttribute(DESCRIPTION, template.getDescription());
        }
        element.setAttribute(TO_REFORMAT, Boolean.toString(template.isToReformat()));
        element.setAttribute(TO_SHORTEN_FQ_NAMES, Boolean.toString(template.isToShortenLongNames()));
        if (template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE) != Template.getDefaultValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)) {
            element.setAttribute(USE_STATIC_IMPORT, Boolean.toString(template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)));
        }
        if (template.isDeactivated()) {
            element.setAttribute(DEACTIVATED, Boolean.toString(true));
        }
        for (int i = 0; i < template.getVariableCount(); ++i) {
            Element variableElement = new Element(VARIABLE);
            variableElement.setAttribute(NAME, template.getVariableNameAt(i));
            variableElement.setAttribute(EXPRESSION, template.getExpressionStringAt(i));
            variableElement.setAttribute(DEFAULT_VALUE, template.getDefaultValueStringAt(i));
            variableElement.setAttribute(ALWAYS_STOP_AT, Boolean.toString(template.isAlwaysStopAt(i)));
            element.addContent(variableElement);
        }
        Element contextElement = template.getTemplateContext().writeTemplateContext(defaultTemplate == null ? null : defaultTemplate.getTemplateContext(), idToType2);
        if (contextElement != null) {
            element.addContent(contextElement);
        }
        return element;
    }

    public void setTemplates(@NotNull List<TemplateGroup> newGroups) {
        this.myTemplates.clear();
        this.myState.deletedKeys.clear();
        for (TemplateImpl template : this.myDefaultTemplates.values()) {
            this.myState.deletedKeys.add(TemplateKey.keyOf(template));
        }
        this.myMaxKeyLength = 0;
        SmartList schemes = new SmartList();
        for (TemplateGroup group : newGroups) {
            if (group.isEmpty()) continue;
            schemes.add(group);
            for (TemplateImpl template : group.getElements()) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
        }
        this.mySchemeManager.setSchemes((List<TemplateGroup>)schemes);
    }

    public List<TemplateGroup> getTemplateGroups() {
        return this.mySchemeManager.getAllSchemes();
    }

    @NotNull
    public List<TemplateImpl> collectMatchingCandidates(@NotNull String key, @Nullable Character shortcutChar, boolean hasArgument) {
        Collection<TemplateImpl> templates = this.getTemplates(key);
        if (templates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : templates) {
            if (template.isDeactivated() || shortcutChar != null && this.getShortcutChar(template) != shortcutChar.charValue() || hasArgument && !template.hasArgument()) continue;
            candidates.add(template);
        }
        return candidates;
    }

    public char getShortcutChar(TemplateImpl template) {
        char c = template.getShortcutChar();
        return c == 'D' ? this.getDefaultShortcutChar() : c;
    }

    public List<TemplateKey> getDeletedTemplates() {
        return this.myState.deletedKeys;
    }

    public void reset() {
        this.myState.deletedKeys.clear();
        this.loadDefaultLiveTemplates();
    }

    public static class TemplateKey {
        private String groupName;
        private String key;

        public TemplateKey() {
        }

        private TemplateKey(String groupName, String key) {
            this.groupName = groupName;
            this.key = key;
        }

        public static TemplateKey keyOf(TemplateImpl template) {
            return new TemplateKey(template.getGroupName(), template.getKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return Comparing.equal((String)this.groupName, (String)that.groupName) && Comparing.equal((String)this.key, (String)that.key);
        }

        public int hashCode() {
            int result2 = this.groupName != null ? this.groupName.hashCode() : 0;
            result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
            return result2;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.getKey() + "@" + this.getGroupName();
        }
    }

    static final class State {
        @OptionTag(nameAttribute="", valueAttribute="shortcut", converter=ShortcutConverter.class)
        public char defaultShortcut = (char)9;
        public List<TemplateKey> deletedKeys = new SmartList();

        State() {
        }
    }

    static final class ShortcutConverter
    extends Converter<Character> {
        ShortcutConverter() {
        }

        @NotNull
        public Character fromString(@NotNull String shortcut) {
            return Character.valueOf((char)(TemplateSettings.TAB.equals(shortcut) ? 9 : (TemplateSettings.ENTER.equals(shortcut) ? 10 : (TemplateSettings.CUSTOM.equals(shortcut) ? 67 : (TemplateSettings.NONE.equals(shortcut) ? 78 : 32)))));
        }

        @NotNull
        public String toString(@NotNull Character shortcut) {
            return shortcut.charValue() == '\t' ? TemplateSettings.TAB : (shortcut.charValue() == '\n' ? TemplateSettings.ENTER : (shortcut.charValue() == 'C' ? TemplateSettings.CUSTOM : (shortcut.charValue() == 'N' ? TemplateSettings.NONE : TemplateSettings.SPACE)));
        }
    }
}

