/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToCamelCaseMacro
extends MacroBase {
    public ConvertToCamelCaseMacro() {
        super("camelCase", "camelCase(String)");
    }

    private ConvertToCamelCaseMacro(String name, String description) {
        super(name, description);
    }

    @Override
    @Nullable
    protected Result calculateResult(@NotNull Expression[] params, ExpressionContext context, boolean quick) {
        String text = ConvertToCamelCaseMacro.getTextResult(params, context, true);
        return text != null ? this.convertString(text) : null;
    }

    @NotNull
    @VisibleForTesting
    public Result convertString(@NotNull String text) {
        String[] strings = this.splitWords(text);
        if (strings.length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(strings[0].toLowerCase());
            for (int i = 1; i < strings.length; ++i) {
                String string = strings[i];
                if (!Character.isLetterOrDigit(string.charAt(0))) continue;
                buf.append(StringUtil.capitalize((String)string.toLowerCase()));
            }
            return new TextResult(buf.toString());
        }
        return new TextResult("");
    }

    @NotNull
    protected String[] splitWords(String text) {
        return NameUtil.nameToWords((String)text);
    }

    public static class ReplaceUnderscoresToCamelCaseMacro
    extends ConvertToCamelCaseMacro {
        public ReplaceUnderscoresToCamelCaseMacro() {
            super("underscoresToCamelCase", CodeInsightBundle.message((String)"macro.undescoresToCamelCase.string", (Object[])new Object[0]));
        }

        @Override
        @NotNull
        protected String[] splitWords(String text) {
            return text.split("_");
        }
    }
}

