/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GroovyScriptMacro
extends Macro {
    public String getName() {
        return "groovyScript";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.groovy.script", (Object[])new Object[0]);
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params.length == 0) {
            return null;
        }
        Object o = GroovyScriptMacro.runIt(params, context);
        if (o instanceof Collection && !((Collection)o).isEmpty()) {
            return new TextResult(GroovyScriptMacro.toNormalizedString(((Collection)o).iterator().next()));
        }
        if (o instanceof Object[] && ((Object[])o).length > 0) {
            return new TextResult(GroovyScriptMacro.toNormalizedString(((Object[])o)[0]));
        }
        if (o != null) {
            return new TextResult(GroovyScriptMacro.toNormalizedString(o));
        }
        return null;
    }

    private static Object runIt(Expression[] params, ExpressionContext context) {
        try {
            Result result2 = params[0].calculateResult(context);
            if (result2 == null) {
                return null;
            }
            String text = result2.toString();
            GroovyShell shell = new GroovyShell();
            File possibleFile = new File(text);
            Script script = possibleFile.exists() ? shell.parse(possibleFile) : shell.parse(text);
            Binding binding = new Binding();
            for (int i = 1; i < params.length; ++i) {
                Result paramResult = params[i].calculateResult(context);
                Object value = null;
                if (paramResult instanceof ListResult) {
                    value = ContainerUtil.map2List(((ListResult)paramResult).getComponents(), result1 -> result1.toString());
                } else if (paramResult != null) {
                    value = paramResult.toString();
                }
                binding.setVariable("_" + i, value);
            }
            binding.setVariable("_editor", (Object)context.getEditor());
            script.setBinding(binding);
            return script.run();
        }
        catch (Error | Exception e) {
            return StringUtil.convertLineSeparators((String)e.getLocalizedMessage());
        }
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        return this.calculateResult(params, context);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        Object o = GroovyScriptMacro.runIt(params, context);
        List<Object> collection = o instanceof Collection ? (List<Object>)o : (o instanceof Object[] ? Arrays.asList((Object[])o) : ContainerUtil.createMaybeSingletonList((Object)o));
        return (LookupElement[])ContainerUtil.map2Array(collection, LookupElement.class, item -> LookupElementBuilder.create((String)GroovyScriptMacro.toNormalizedString(item)));
    }

    private static String toNormalizedString(Object o) {
        return StringUtil.convertLineSeparators((String)o.toString());
    }
}

