/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstringBeforeMacro
extends MacroBase {
    public SubstringBeforeMacro() {
        super("substringBefore", "substringBefore(String, Delimiter)");
    }

    @Override
    protected Result calculateResult(@NotNull Expression[] params, ExpressionContext context, boolean quick) {
        if (params.length == 2) {
            String string = SubstringBeforeMacro.getTextResult(params[0], context);
            if (string == null) {
                return null;
            }
            String delimiter = SubstringBeforeMacro.getTextResult(params[1], context);
            if (delimiter == null) {
                return null;
            }
            int indexOf = string.indexOf(delimiter);
            return new TextResult(indexOf > 0 ? string.substring(0, indexOf) : "");
        }
        return null;
    }

    @Nullable
    private static String getTextResult(@NotNull Expression param, ExpressionContext context) {
        Result result2 = param.calculateResult(context);
        return result2 != null ? result2.toString() : null;
    }
}

