/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.ui.CheckedTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostfixTemplateCheckedTreeNode
extends CheckedTreeNode {
    @NotNull
    private final PostfixTemplateProvider myTemplateProvider;
    @NotNull
    private PostfixTemplate myTemplate;
    @Nullable
    private PostfixTemplate myInitialTemplate;
    private final boolean myNew;

    @NotNull
    public PostfixTemplate getTemplate() {
        return this.myTemplate;
    }

    @NotNull
    public PostfixTemplateProvider getTemplateProvider() {
        return this.myTemplateProvider;
    }

    PostfixTemplateCheckedTreeNode(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider templateProvider, boolean isNew) {
        super((Object)template.getPresentableName());
        this.myTemplateProvider = templateProvider;
        this.myTemplate = template;
        this.myInitialTemplate = template;
        this.myNew = isNew;
    }

    public void setTemplate(@NotNull PostfixTemplate template) {
        if (this.myInitialTemplate == null) {
            this.myInitialTemplate = this.myTemplate;
        }
        this.myTemplate = template;
    }

    public boolean isChanged() {
        return this.myInitialTemplate != null && !this.myInitialTemplate.equals(this.myTemplate);
    }

    public boolean isNew() {
        return this.myNew;
    }

    public String toString() {
        return this.myTemplate.getPresentableName();
    }
}

