/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplateWithMultipleExpressions;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplateEditorBase<Condition extends PostfixTemplateExpressionCondition>
implements PostfixTemplateEditor {
    @NotNull
    protected final PostfixTemplateProvider myProvider;
    @NotNull
    protected final Editor myTemplateEditor;
    @NotNull
    protected final JBList<Condition> myExpressionTypesList;
    @NotNull
    protected final DefaultListModel<Condition> myExpressionTypesListModel;
    @NotNull
    protected final JPanel myTemplateEditorPanel;
    @NotNull
    protected final JPanel myExpressionTypesPanel;
    @NotNull
    protected final JBCheckBox myApplyToTheTopmostJBCheckBox;
    @NotNull
    protected final JPanel myEditTemplateAndConditionsPanel;
    @NotNull
    protected final JBLabel myExpressionVariableHint;

    public PostfixTemplateEditorBase(@NotNull PostfixTemplateProvider provider, boolean showExpressionTypes) {
        this(provider, PostfixTemplateEditorBase.createSimpleEditor(), showExpressionTypes);
    }

    public PostfixTemplateEditorBase(@NotNull PostfixTemplateProvider provider, @NotNull Editor templateEditor, boolean showExpressionTypes) {
        this.myProvider = provider;
        this.myTemplateEditor = templateEditor;
        this.myApplyToTheTopmostJBCheckBox = new JBCheckBox("Apply to the &topmost expression");
        DialogUtil.registerMnemonic((AbstractButton)this.myApplyToTheTopmostJBCheckBox, (char)'&');
        this.myTemplateEditorPanel = new JPanel(new BorderLayout());
        this.myTemplateEditorPanel.add(this.myTemplateEditor.getComponent());
        this.myExpressionVariableHint = new JBLabel("Use $EXPR$ variable to refer target expression");
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myExpressionVariableHint);
        this.myExpressionVariableHint.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.myExpressionTypesListModel = JBList.createDefaultListModel((Object[])new PostfixTemplateExpressionCondition[0]);
        this.myExpressionTypesList = new JBList(this.myExpressionTypesListModel);
        this.myExpressionTypesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<PostfixTemplateExpressionCondition>(){

            protected void customizeCellRenderer(@NotNull JList<? extends PostfixTemplateExpressionCondition> list2, PostfixTemplateExpressionCondition value, int index, boolean selected, boolean hasFocus) {
                this.append(value.getPresentableName());
            }
        });
        this.myExpressionTypesPanel = new JPanel(new BorderLayout());
        FormBuilder builder2 = FormBuilder.createFormBuilder();
        if (showExpressionTypes) {
            this.myExpressionTypesPanel.add(ToolbarDecorator.createDecorator(this.myExpressionTypesList).setAddAction(button2 -> this.showAddExpressionTypePopup((AnActionButton)button2)).setRemoveAction(button2 -> ListUtil.removeSelectedItems(this.myExpressionTypesList)).disableUpDownActions().createPanel());
            this.myExpressionTypesPanel.setMinimumSize(new Dimension(-1, 100));
            builder2.addLabeledComponent("Applicable expression types:", (JComponent)this.myExpressionTypesPanel, true);
        }
        builder2.addComponent((JComponent)this.myApplyToTheTopmostJBCheckBox);
        builder2.addComponent((JComponent)this.myTemplateEditorPanel);
        builder2.addComponent((JComponent)this.myExpressionVariableHint);
        this.myEditTemplateAndConditionsPanel = builder2.getPanel();
    }

    @NotNull
    protected static Editor createEditor(@NotNull Project project, @NotNull Document document) {
        return TemplateEditorUtil.createEditor(false, document, project);
    }

    @NotNull
    private static Editor createSimpleEditor() {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        return PostfixTemplateEditorBase.createEditor(defaultProject, EditorFactory.getInstance().createDocument((CharSequence)""));
    }

    protected final void showAddExpressionTypePopup(@NotNull AnActionButton button2) {
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillConditions(group);
        DataContext context = DataManager.getInstance().getDataContext((Component)button2.getContextComponent());
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup2.show((RelativePoint)ObjectUtils.assertNotNull((Object)button2.getPreferredPopupPoint()));
    }

    protected abstract void fillConditions(@NotNull DefaultActionGroup var1);

    public void setTemplate(@Nullable PostfixTemplate rawTemplate) {
        if (!(rawTemplate instanceof EditablePostfixTemplateWithMultipleExpressions)) {
            return;
        }
        EditablePostfixTemplateWithMultipleExpressions template = (EditablePostfixTemplateWithMultipleExpressions)rawTemplate;
        this.myExpressionTypesListModel.clear();
        for (PostfixTemplateExpressionCondition condition : template.getExpressionConditions()) {
            this.myExpressionTypesListModel.addElement(condition);
        }
        this.myApplyToTheTopmostJBCheckBox.setSelected(template.isUseTopmostExpression());
        ApplicationManager.getApplication().runWriteAction(() -> this.myTemplateEditor.getDocument().setText((CharSequence)template.getLiveTemplate().getString()));
    }

    @Override
    public String getHelpId() {
        return "reference.custom.postfix.templates";
    }

    public void dispose() {
        TemplateEditorUtil.disposeTemplateEditor(this.myTemplateEditor);
    }

    protected static class AddConditionAction
    extends DumbAwareAction {
        @NotNull
        private final Condition myCondition;
        final /* synthetic */ PostfixTemplateEditorBase this$0;

        public AddConditionAction(Condition condition) {
            this.this$0 = this$0;
            super(condition.getPresentableName());
            this.myCondition = condition;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.this$0.myExpressionTypesListModel.addElement(this.myCondition);
        }
    }
}

