/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.intention.impl.config.BeforeAfterActionMetaData;
import com.intellij.codeInsight.intention.impl.config.BeforeAfterMetaData;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInsight.template.postfix.settings.EditablePostfixTemplateMetaData;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateWrapperMetaData;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostfixTemplateMetaData
extends BeforeAfterActionMetaData {
    public static final String KEY = "$key";
    public static final PostfixTemplateMetaData EMPTY_METADATA = new PostfixTemplateMetaData();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData");
    private static final String DESCRIPTION_FOLDER = "postfixTemplates";
    private URL urlDir = null;
    private PostfixTemplate myTemplate;

    @NotNull
    public static BeforeAfterMetaData createMetaData(@Nullable PostfixTemplate template) {
        if (template == null) {
            return EMPTY_METADATA;
        }
        if (template instanceof PostfixTemplateWrapper) {
            return new PostfixTemplateWrapperMetaData((PostfixTemplateWrapper)template);
        }
        if (template instanceof EditablePostfixTemplate && !template.isBuiltin()) {
            return new EditablePostfixTemplateMetaData((EditablePostfixTemplate)template);
        }
        return new PostfixTemplateMetaData(template);
    }

    public PostfixTemplateMetaData(@NotNull PostfixTemplate template) {
        super(template.getClass().getClassLoader(), template.getClass().getSimpleName());
        this.myTemplate = template;
    }

    PostfixTemplateMetaData() {
        super(EMPTY_DESCRIPTION, EMPTY_EXAMPLE, EMPTY_EXAMPLE);
    }

    @Override
    @NotNull
    public TextDescriptor[] getExampleUsagesBefore() {
        return this.decorateTextDescriptor(this.getRawExampleUsagesBefore());
    }

    @NotNull
    TextDescriptor[] getRawExampleUsagesBefore() {
        return super.getExampleUsagesBefore();
    }

    @NotNull
    private TextDescriptor[] decorateTextDescriptor(TextDescriptor[] before) {
        String key = this.myTemplate.getKey();
        return PostfixTemplateMetaData.decorateTextDescriptorWithKey(before, key);
    }

    @NotNull
    static TextDescriptor[] decorateTextDescriptorWithKey(TextDescriptor[] before, final @NotNull String key) {
        ArrayList list2 = ContainerUtil.newArrayListWithCapacity((int)before.length);
        for (final TextDescriptor descriptor : before) {
            list2.add(new TextDescriptor(){

                @Override
                public String getText() throws IOException {
                    return StringUtil.replace((String)descriptor.getText(), (String)PostfixTemplateMetaData.KEY, (String)key);
                }

                @Override
                public String getFileName() {
                    return descriptor.getFileName();
                }
            });
        }
        return list2.toArray(new TextDescriptor[0]);
    }

    @Override
    @NotNull
    public TextDescriptor[] getExampleUsagesAfter() {
        return this.decorateTextDescriptor(this.getRawExampleUsagesAfter());
    }

    @NotNull
    TextDescriptor[] getRawExampleUsagesAfter() {
        return super.getExampleUsagesAfter();
    }

    @Override
    @NotNull
    protected URL getDirURL() {
        if (this.urlDir != null) {
            return this.urlDir;
        }
        URL pageURL = this.myLoader.getResource("postfixTemplates/" + this.myDescriptionDirectoryName + "/" + "description.html");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path:postfixTemplates/" + this.myDescriptionDirectoryName);
            LOG.debug("URL:" + pageURL);
        }
        if (pageURL != null) {
            try {
                String url = pageURL.toExternalForm();
                this.urlDir = UrlClassLoader.internProtocol((URL)new URL(url.substring(0, url.lastIndexOf(47))));
                return this.urlDir;
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }
}

