/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.settings.PostfixEditTemplateDialog;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateCheckedTreeNode;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.templates.editable.DefaultPostfixTemplateEditor;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplatesCheckboxTree
extends CheckboxTree
implements Disposable {
    private static final Factory<Set<PostfixTemplateCheckedTreeNode>> myNodesComparator = () -> new TreeSet((o1, o2) -> {
        PostfixTemplate template1 = o1.getTemplate();
        PostfixTemplate template2 = o2.getTemplate();
        int compare = Comparing.compare((Comparable)((Object)template1.getPresentableName()), (Comparable)((Object)template2.getPresentableName()));
        return compare != 0 ? compare : Comparing.compare((Comparable)((Object)template1.getId()), (Comparable)((Object)template2.getId()));
    });
    @NotNull
    private final CheckedTreeNode myRoot;
    @NotNull
    private final DefaultTreeModel myModel;
    @NotNull
    private final Map<PostfixTemplateProvider, String> myProviderToLanguage;
    private final boolean canAddTemplate;

    public PostfixTemplatesCheckboxTree(@NotNull Map<PostfixTemplateProvider, String> providerToLanguage) {
        super(PostfixTemplatesCheckboxTree.getRenderer(), new CheckedTreeNode(null));
        this.myProviderToLanguage = providerToLanguage;
        this.canAddTemplate = ContainerUtil.find(providerToLanguage.keySet(), p -> StringUtil.isNotEmpty((String)p.getPresentableName())) != null;
        this.myModel = (DefaultTreeModel)this.getModel();
        this.myRoot = (CheckedTreeNode)this.myModel.getRoot();
        TreeSelectionListener selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent event) {
                PostfixTemplatesCheckboxTree.this.selectionChanged();
            }
        };
        this.getSelectionModel().addTreeSelectionListener(selectionListener);
        Disposer.register((Disposable)this, () -> this.getSelectionModel().removeTreeSelectionListener(selectionListener));
        DoubleClickListener doubleClickListener = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                TreePath location = PostfixTemplatesCheckboxTree.this.getClosestPathForLocation(event.getX(), event.getY());
                return location != null && PostfixTemplatesCheckboxTree.this.doubleClick(location.getLastPathComponent());
            }
        };
        doubleClickListener.installOn((Component)((Object)this));
        Disposer.register((Disposable)this, () -> doubleClickListener.uninstall((Component)((Object)this)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    protected void onDoubleClick(CheckedTreeNode node) {
        this.doubleClick(node);
    }

    private boolean doubleClick(@Nullable Object node) {
        if (node instanceof PostfixTemplateCheckedTreeNode && PostfixTemplatesCheckboxTree.isEditable(((PostfixTemplateCheckedTreeNode)((Object)node)).getTemplate())) {
            this.editTemplate((PostfixTemplateCheckedTreeNode)((Object)node));
            return true;
        }
        return false;
    }

    public void dispose() {
        UIUtil.dispose((Component)((Object)this));
    }

    @NotNull
    private static CheckboxTree.CheckboxTreeCellRenderer getRenderer() {
        return new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                String example;
                SimpleTextAttributes attributes;
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value;
                Color background = UIUtil.getTreeBackground((boolean)selected, (boolean)true);
                PostfixTemplateCheckedTreeNode templateNode = (PostfixTemplateCheckedTreeNode)((Object)ObjectUtils.tryCast((Object)node, PostfixTemplateCheckedTreeNode.class));
                if (templateNode != null) {
                    JBColor fgColor = templateNode.isChanged() || templateNode.isNew() ? JBColor.BLUE : null;
                    attributes = new SimpleTextAttributes(0, (Color)fgColor);
                } else {
                    attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                }
                this.getTextRenderer().append(StringUtil.notNullize((String)value.toString()), new SimpleTextAttributes(background, attributes.getFgColor(), (Color)JBColor.RED, attributes.getStyle()));
                if (templateNode != null && StringUtil.isNotEmpty((String)(example = templateNode.getTemplate().getExample()))) {
                    this.getTextRenderer().append("  " + example, new SimpleTextAttributes(128, (Color)JBColor.GRAY), false);
                }
            }
        };
    }

    protected void selectionChanged() {
    }

    public void initTree(@NotNull MultiMap<PostfixTemplateProvider, PostfixTemplate> providerToTemplates) {
        this.myRoot.removeAllChildren();
        HashMap languageToNodes = new HashMap();
        for (Map.Entry entry : providerToTemplates.entrySet()) {
            PostfixTemplateProvider provider = (PostfixTemplateProvider)entry.getKey();
            String languageId = this.myProviderToLanguage.get(provider);
            Set nodes = (Set)ContainerUtil.getOrCreate(languageToNodes, (Object)languageId, myNodesComparator);
            for (PostfixTemplate template : (Collection)entry.getValue()) {
                nodes.add(new PostfixTemplateCheckedTreeNode(template, provider, false));
            }
        }
        for (Map.Entry entry : languageToNodes.entrySet()) {
            DefaultMutableTreeNode languageNode = this.findOrCreateLanguageNode((String)entry.getKey());
            for (PostfixTemplateCheckedTreeNode node : (Set)entry.getValue()) {
                languageNode.add((MutableTreeNode)((Object)new PostfixTemplateCheckedTreeNode(node.getTemplate(), node.getTemplateProvider(), false)));
            }
        }
        this.myModel.nodeStructureChanged((TreeNode)this.myRoot);
        TreeUtil.expandAll((JTree)((Object)this));
    }

    @Nullable
    public PostfixTemplate getSelectedTemplate() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        return PostfixTemplatesCheckboxTree.getTemplateFromPath(path);
    }

    @Nullable
    private static PostfixTemplate getTemplateFromPath(@Nullable TreePath path) {
        if (path == null || !(path.getLastPathComponent() instanceof PostfixTemplateCheckedTreeNode)) {
            return null;
        }
        return ((PostfixTemplateCheckedTreeNode)((Object)path.getLastPathComponent())).getTemplate();
    }

    @NotNull
    public MultiMap<PostfixTemplateProvider, PostfixTemplate> getEditableTemplates() {
        MultiMap result2 = MultiMap.createSet();
        this.visitTemplateNodes((Consumer<? super PostfixTemplateCheckedTreeNode>)((Consumer)node -> {
            PostfixTemplate template = node.getTemplate();
            PostfixTemplateProvider provider = node.getTemplateProvider();
            if (PostfixTemplatesCheckboxTree.isEditable(template) && (!template.isBuiltin() || template instanceof PostfixChangedBuiltinTemplate)) {
                result2.putValue((Object)provider, (Object)template);
            }
        }));
        return result2;
    }

    @NotNull
    public Map<String, Set<String>> getDisabledTemplatesState() {
        HashMap result2 = ContainerUtil.newHashMap();
        this.visitTemplateNodes((Consumer<? super PostfixTemplateCheckedTreeNode>)((Consumer)template -> {
            if (!template.isChecked()) {
                Set templatesForProvider = (Set)ContainerUtil.getOrCreate((Map)result2, (Object)template.getTemplateProvider().getId(), PostfixTemplatesSettings.SET_FACTORY);
                templatesForProvider.add(template.getTemplate().getId());
            }
        }));
        return result2;
    }

    public void setDisabledTemplatesState(@NotNull Map<String, Set<String>> providerToDisabledTemplates) {
        TreeState treeState = TreeState.createOn((JTree)((Object)this), (DefaultMutableTreeNode)this.myRoot);
        this.visitTemplateNodes((Consumer<? super PostfixTemplateCheckedTreeNode>)((Consumer)template -> {
            Set disabledTemplates = (Set)providerToDisabledTemplates.get(template.getTemplateProvider().getId());
            String key = template.getTemplate().getId();
            if (disabledTemplates != null && disabledTemplates.contains(key)) {
                template.setChecked(false);
                return;
            }
            template.setChecked(true);
        }));
        this.myModel.nodeStructureChanged((TreeNode)this.myRoot);
        treeState.applyTo((JTree)((Object)this));
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void selectTemplate(@NotNull PostfixTemplate postfixTemplate, @NotNull PostfixTemplateProvider provider) {
        this.visitTemplateNodes((Consumer<? super PostfixTemplateCheckedTreeNode>)((Consumer)template -> {
            if (provider.getId().equals(template.getTemplateProvider().getId()) && postfixTemplate.getKey().equals(template.getTemplate().getKey())) {
                TreeUtil.selectInTree((DefaultMutableTreeNode)((Object)template), (boolean)true, (JTree)((Object)this), (boolean)true);
            }
        }));
    }

    private void visitTemplateNodes(@NotNull Consumer<? super PostfixTemplateCheckedTreeNode> consumer) {
        Enumeration languages = this.myRoot.children();
        while (languages.hasMoreElements()) {
            CheckedTreeNode langNode = (CheckedTreeNode)languages.nextElement();
            Enumeration templates = langNode.children();
            while (templates.hasMoreElements()) {
                Object template = templates.nextElement();
                if (!(template instanceof PostfixTemplateCheckedTreeNode)) continue;
                consumer.consume((Object)((PostfixTemplateCheckedTreeNode)((Object)template)));
            }
        }
    }

    public boolean canAddTemplate() {
        return this.canAddTemplate;
    }

    public void addTemplate(@NotNull AnActionButton button2) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (final Map.Entry<PostfixTemplateProvider, String> entry : this.myProviderToLanguage.entrySet()) {
            final PostfixTemplateProvider provider = entry.getKey();
            final String providerName = provider.getPresentableName();
            if (StringUtil.isEmpty((String)providerName)) continue;
            group.add((AnAction)new DumbAwareAction(providerName){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    PostfixEditTemplateDialog dialog2;
                    PostfixTemplateEditor editor = provider.createEditor(null);
                    if (editor != null && (dialog2 = new PostfixEditTemplateDialog((Component)((Object)PostfixTemplatesCheckboxTree.this), editor, providerName, null)).showAndGet()) {
                        String templateKey = dialog2.getTemplateName();
                        String templateId = PostfixTemplatesUtils.generateTemplateId(templateKey, provider);
                        PostfixTemplate createdTemplate = editor.createTemplate(templateId, templateKey);
                        PostfixTemplateCheckedTreeNode createdNode = new PostfixTemplateCheckedTreeNode(createdTemplate, provider, true);
                        DefaultMutableTreeNode languageNode = PostfixTemplatesCheckboxTree.this.findOrCreateLanguageNode((String)entry.getValue());
                        languageNode.add((MutableTreeNode)((Object)createdNode));
                        PostfixTemplatesCheckboxTree.this.myModel.nodeStructureChanged(languageNode);
                        TreeUtil.selectNode((JTree)((Object)PostfixTemplatesCheckboxTree.this), (TreeNode)((Object)createdNode));
                    }
                }
            });
        }
        DataContext context = DataManager.getInstance().getDataContext((Component)button2.getContextComponent());
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup2.show((RelativePoint)ObjectUtils.assertNotNull((Object)button2.getPreferredPopupPoint()));
    }

    public boolean canEditSelectedTemplate() {
        TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
        return (selectionPaths == null || selectionPaths.length <= 1) && PostfixTemplatesCheckboxTree.isEditable(this.getSelectedTemplate());
    }

    public void editSelectedTemplate() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof PostfixTemplateCheckedTreeNode) {
            this.editTemplate((PostfixTemplateCheckedTreeNode)((Object)lastPathComponent));
        }
    }

    private void editTemplate(@NotNull PostfixTemplateCheckedTreeNode lastPathComponent) {
        PostfixTemplate template = lastPathComponent.getTemplate();
        PostfixTemplateProvider provider = lastPathComponent.getTemplateProvider();
        if (PostfixTemplatesCheckboxTree.isEditable(template)) {
            String providerName;
            PostfixEditTemplateDialog dialog2;
            PostfixTemplate templateToEdit = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getDelegate() : template;
            PostfixTemplateEditor editor = provider.createEditor(templateToEdit);
            if (editor == null) {
                editor = new DefaultPostfixTemplateEditor(provider, templateToEdit);
            }
            if ((dialog2 = new PostfixEditTemplateDialog((Component)((Object)this), editor, providerName = StringUtil.notNullize((String)provider.getPresentableName()), templateToEdit)).showAndGet()) {
                PostfixTemplate newTemplate = editor.createTemplate(template.getId(), dialog2.getTemplateName());
                if (newTemplate.equals(template)) {
                    return;
                }
                if (template.isBuiltin()) {
                    PostfixTemplate builtin = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate() : templateToEdit;
                    lastPathComponent.setTemplate(new PostfixChangedBuiltinTemplate(newTemplate, builtin));
                } else {
                    lastPathComponent.setTemplate(newTemplate);
                }
                this.myModel.nodeStructureChanged((TreeNode)((Object)lastPathComponent));
                this.selectionChanged();
            }
        }
    }

    public boolean canDuplicateSelectedTemplate() {
        TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
        if (selectionPaths != null && selectionPaths.length > 1) {
            return false;
        }
        PostfixTemplate selectedTemplate = this.getSelectedTemplate();
        if (!PostfixTemplatesCheckboxTree.isEditable(selectedTemplate)) {
            return false;
        }
        PostfixTemplateProvider provider = selectedTemplate.getProvider();
        if (provider == null) {
            return false;
        }
        PostfixTemplateEditor editor = provider.createEditor(selectedTemplate);
        if (editor != null) {
            Disposer.dispose((Disposable)editor);
            return true;
        }
        return false;
    }

    public void duplicateSelectedTemplate() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof PostfixTemplateCheckedTreeNode) {
            PostfixTemplate template = ((PostfixTemplateCheckedTreeNode)((Object)lastPathComponent)).getTemplate();
            PostfixTemplateProvider provider = ((PostfixTemplateCheckedTreeNode)((Object)lastPathComponent)).getTemplateProvider();
            String languageId = this.myProviderToLanguage.get(provider);
            if (PostfixTemplatesCheckboxTree.isEditable(template) && languageId != null) {
                PostfixTemplate templateToEdit = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getDelegate() : template;
                PostfixTemplateEditor editor = provider.createEditor(templateToEdit);
                if (editor == null) {
                    return;
                }
                String providerName = StringUtil.notNullize((String)provider.getPresentableName());
                PostfixEditTemplateDialog dialog2 = new PostfixEditTemplateDialog((Component)((Object)this), editor, providerName, templateToEdit);
                if (dialog2.showAndGet()) {
                    String templateKey = dialog2.getTemplateName();
                    PostfixTemplate newTemplate = editor.createTemplate(PostfixTemplatesUtils.generateTemplateId(templateKey, provider), templateKey);
                    PostfixTemplateCheckedTreeNode createdNode = new PostfixTemplateCheckedTreeNode(newTemplate, provider, true);
                    DefaultMutableTreeNode languageNode = this.findOrCreateLanguageNode(languageId);
                    languageNode.insert((MutableTreeNode)((Object)createdNode), languageNode.getIndex((TreeNode)((Object)((PostfixTemplateCheckedTreeNode)((Object)lastPathComponent)))) + 1);
                    this.myModel.nodeStructureChanged(languageNode);
                    TreeUtil.selectNode((JTree)((Object)this), (TreeNode)((Object)createdNode));
                }
            }
        }
    }

    public boolean canRemoveSelectedTemplates() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            PostfixTemplate template = PostfixTemplatesCheckboxTree.getTemplateFromPath(path);
            if (!PostfixTemplatesCheckboxTree.isEditable(template) || template.isBuiltin() && !(template instanceof PostfixChangedBuiltinTemplate)) continue;
            return true;
        }
        return false;
    }

    public void removeSelectedTemplates() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            PostfixTemplateCheckedTreeNode lastPathComponent = (PostfixTemplateCheckedTreeNode)((Object)ObjectUtils.tryCast((Object)path.getLastPathComponent(), PostfixTemplateCheckedTreeNode.class));
            if (lastPathComponent == null) continue;
            PostfixTemplate template = lastPathComponent.getTemplate();
            if (template instanceof PostfixChangedBuiltinTemplate) {
                lastPathComponent.setTemplate(((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate());
                this.myModel.nodeStructureChanged((TreeNode)((Object)lastPathComponent));
                continue;
            }
            if (!PostfixTemplatesCheckboxTree.isEditable(template) || template.isBuiltin()) continue;
            TreeUtil.removeLastPathComponent((JTree)((Object)this), (TreePath)path);
        }
    }

    private static boolean isEditable(@Nullable PostfixTemplate template) {
        return template != null && template.isEditable() && template.getKey().startsWith(".");
    }

    @NotNull
    private DefaultMutableTreeNode findOrCreateLanguageNode(String languageId) {
        DefaultMutableTreeNode find = TreeUtil.findNode((DefaultMutableTreeNode)this.myRoot, n -> n instanceof LangTreeNode && languageId.equals(((LangTreeNode)((Object)((Object)n))).getLanguageId()));
        if (find != null) {
            return find;
        }
        Language language = Language.findLanguageByID((String)languageId);
        String languageName = language != null ? language.getDisplayName() : languageId;
        LangTreeNode languageNode = new LangTreeNode(languageName, languageId);
        this.myRoot.add((MutableTreeNode)((Object)languageNode));
        return languageNode;
    }

    private static class LangTreeNode
    extends CheckedTreeNode {
        @NotNull
        private final String myLanguageId;

        LangTreeNode(@NotNull String languageName, @NotNull String languageId) {
            super((Object)languageName);
            this.myLanguageId = languageId;
        }

        @NotNull
        public String getLanguageId() {
            return this.myLanguageId;
        }
    }
}

