/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplatesSettings", storages={@Storage(value="postfixTemplates.xml")})
public class PostfixTemplatesSettings
implements PersistentStateComponent<Element> {
    public static final Factory<Set<String>> SET_FACTORY = () -> ContainerUtil.newHashSet();
    private Map<String, Set<String>> myProviderToDisabledTemplates = ContainerUtil.newHashMap();
    @Deprecated
    private Map<String, Set<String>> myLangToDisabledTemplates = ContainerUtil.newHashMap();
    private boolean postfixTemplatesEnabled = true;
    private boolean templatesCompletionEnabled = true;
    private int myShortcut = 9;

    public boolean isTemplateEnabled(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        Set<String> result2 = this.myProviderToDisabledTemplates.get(provider.getId());
        return result2 == null || !result2.contains(template.getId());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        this.disableTemplate(template, provider.getId());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull String providerId) {
        Set state = (Set)ContainerUtil.getOrCreate(this.myProviderToDisabledTemplates, (Object)providerId, SET_FACTORY);
        state.add(template.getId());
    }

    public boolean isPostfixTemplatesEnabled() {
        return this.postfixTemplatesEnabled;
    }

    public void setPostfixTemplatesEnabled(boolean postfixTemplatesEnabled) {
        this.postfixTemplatesEnabled = postfixTemplatesEnabled;
    }

    public boolean isTemplatesCompletionEnabled() {
        return this.templatesCompletionEnabled;
    }

    public void setTemplatesCompletionEnabled(boolean templatesCompletionEnabled) {
        this.templatesCompletionEnabled = templatesCompletionEnabled;
    }

    @Deprecated
    @MapAnnotation(entryTagName="disabled-postfix-templates", keyAttributeName="lang", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getLangDisabledTemplates() {
        return this.myLangToDisabledTemplates;
    }

    @Deprecated
    public void setLangDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        this.myLangToDisabledTemplates = templatesState;
    }

    @MapAnnotation(entryTagName="disabled-templates", keyAttributeName="provider", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getProviderToDisabledTemplates() {
        return this.myProviderToDisabledTemplates;
    }

    public void setProviderToDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        this.myProviderToDisabledTemplates = templatesState;
    }

    public int getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(int shortcut) {
        this.myShortcut = shortcut;
    }

    @NotNull
    public static PostfixTemplatesSettings getInstance() {
        return (PostfixTemplatesSettings)ServiceManager.getService(PostfixTemplatesSettings.class);
    }

    @Nullable
    public Element getState() {
        return XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void loadState(@NotNull Element settings) {
        XmlSerializer.deserializeInto((Object)this, (Element)settings);
        if (!this.myLangToDisabledTemplates.isEmpty()) {
            MultiMap<String, Language> importedLanguages = PostfixTemplatesSettings.getLanguagesToImport();
            for (Map.Entry<String, Set<String>> entry : this.myLangToDisabledTemplates.entrySet()) {
                for (Language language : importedLanguages.get((Object)entry.getKey())) {
                    for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
                        for (PostfixTemplate template : provider.getTemplates()) {
                            if (!entry.getValue().contains(template.getKey())) continue;
                            this.disableTemplate(template, provider);
                        }
                    }
                }
            }
            for (String language : importedLanguages.keySet()) {
                this.myLangToDisabledTemplates.remove(language);
            }
        }
    }

    @NotNull
    private static MultiMap<String, Language> getLanguagesToImport() {
        LanguageExtensionPoint[] extensions;
        MultiMap importedLanguages = MultiMap.create();
        for (LanguageExtensionPoint extension : extensions = (LanguageExtensionPoint[])new ExtensionPointName("com.intellij.codeInsight.template.postfixTemplateProvider").getExtensions()) {
            Language language = Language.findLanguageByID((String)extension.getKey());
            if (language == null) continue;
            importedLanguages.putValue((Object)language.getDisplayName(), (Object)language);
        }
        return importedLanguages;
    }
}

