/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixLiveTemplate
extends CustomLiveTemplateBase {
    public static final String POSTFIX_TEMPLATE_ID = "POSTFIX_TEMPLATE_ID";
    private static final String USAGE_GROUP = "completion.postfix";
    private static final Logger LOG = Logger.getInstance(PostfixLiveTemplate.class);
    private static final String THIRD_PARTY_PLUGIN_POSTFIX_TEMPLATE_ID = "third.party.plugin.postfix.template";

    @NotNull
    public Set<String> getAllTemplateKeys(PsiFile file2, int offset) {
        HashSet keys = Sets.newHashSet();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            ProgressManager.checkCanceled();
            keys.addAll(PostfixLiveTemplate.getKeys(provider));
        }
        return keys;
    }

    @Nullable
    private static String computeTemplateKeyWithoutContextChecking(@NotNull PostfixTemplateProvider provider, @NotNull CharSequence documentContent, int currentOffset) {
        int startOffset;
        if (documentContent.length() < startOffset) {
            return null;
        }
        for (startOffset = currentOffset; startOffset > 0; --startOffset) {
            ProgressManager.checkCanceled();
            char currentChar = documentContent.charAt(startOffset - 1);
            if (Character.isJavaIdentifierPart(currentChar)) continue;
            if (!provider.isTerminalSymbol(currentChar)) {
                return null;
            }
            --startOffset;
            break;
        }
        return String.valueOf(documentContent.subSequence(startOffset, currentOffset));
    }

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback2) {
        Editor editor = callback2.getEditor();
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback2))) {
            String key = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider, charsSequence, offset);
            if (key == null || !PostfixLiveTemplate.isApplicableTemplate(provider, key, callback2.getFile(), editor)) continue;
            return key;
        }
        return null;
    }

    @Override
    @Nullable
    public String computeTemplateKeyWithoutContextChecking(@NotNull CustomTemplateCallback callback2) {
        Editor editor = callback2.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback2))) {
            ProgressManager.checkCanceled();
            String key = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider, editor.getDocument().getCharsSequence(), currentOffset);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public boolean supportsMultiCaret() {
        return false;
    }

    @Override
    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor = callback2.getEditor();
        PsiFile file2 = callback2.getContext().getContainingFile();
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback2))) {
            PostfixTemplate postfixTemplate = PostfixLiveTemplate.findApplicableTemplate(provider, key, editor, file2);
            if (postfixTemplate == null) continue;
            PostfixLiveTemplate.expandTemplate(key, callback2, editor, provider, postfixTemplate);
            return;
        }
        if (editor.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key + "; offset = " + callback2.getOffset(), new Attachment[]{AttachmentFactory.createAttachment(callback2.getFile().getVirtualFile())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandTemplate(@NotNull String key, @NotNull CustomTemplateCallback callback2, @NotNull Editor editor, @NotNull PostfixTemplateProvider provider, @NotNull PostfixTemplate postfixTemplate) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.postfix");
        PsiFile file2 = callback2.getContext().getContainingFile();
        if (PostfixLiveTemplate.isApplicableTemplate(provider, key, file2, editor, postfixTemplate)) {
            int offset = PostfixLiveTemplate.deleteTemplateKey(file2, editor, key);
            try {
                provider.preExpand(file2, editor);
                PsiElement context = CustomTemplateCallback.getContext(file2, PostfixLiveTemplate.positiveOffset(offset));
                PostfixLiveTemplate.expandTemplate(postfixTemplate, editor, context);
            }
            finally {
                provider.afterExpand(file2, editor);
            }
        } else if (editor.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key + "; offset = " + callback2.getOffset(), new Attachment[]{AttachmentFactory.createAttachment(callback2.getFile().getVirtualFile())});
        }
    }

    @Override
    public boolean isApplicable(@NotNull CustomTemplateCallback callback2, int offset, boolean wrapping) {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        if (wrapping || !settings.isPostfixTemplatesEnabled()) {
            return false;
        }
        PsiFile contextFile = callback2.getFile();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)contextFile, (int)offset);
        String fileText = contextFile.getText();
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            if (!StringUtil.isNotEmpty((String)PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider, fileText, offset + 1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsWrapping() {
        return false;
    }

    @Override
    public void wrap(@NotNull String selection, @NotNull CustomTemplateCallback callback2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getTitle() {
        return "Postfix";
    }

    @Override
    public char getShortcut() {
        return (char)PostfixTemplatesSettings.getInstance().getShortcut();
    }

    @Override
    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback2, int offset) {
        return true;
    }

    @Override
    @NotNull
    public Collection<? extends CustomLiveTemplateLookupElement> getLookupElements(@NotNull PsiFile file2, @NotNull Editor editor, int offset) {
        HashSet result2 = ContainerUtil.newHashSet();
        CustomTemplateCallback callback2 = new CustomTemplateCallback(editor, file2);
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback2))) {
            ProgressManager.checkCanceled();
            String key = this.computeTemplateKeyWithoutContextChecking(callback2);
            if (key == null || editor.getCaretModel().getCaretCount() != 1) continue;
            Condition<PostfixTemplate> isApplicationTemplateFunction = PostfixLiveTemplate.createIsApplicationTemplateFunction(provider, key, file2, editor);
            for (PostfixTemplate postfixTemplate : PostfixTemplatesUtils.getAvailableTemplates(provider)) {
                ProgressManager.checkCanceled();
                if (!isApplicationTemplateFunction.value((Object)postfixTemplate)) continue;
                result2.add(new PostfixTemplateLookupElement(this, postfixTemplate, postfixTemplate.getKey(), provider, false));
            }
        }
        return result2;
    }

    private static void expandTemplate(@NotNull PostfixTemplate template, @NotNull Editor editor, @NotNull PsiElement context) {
        PostfixTemplateProvider provider;
        PluginInfo pluginInfo;
        if (template.isBuiltin() && (pluginInfo = PluginInfoDetectorKt.getPluginInfo((provider = template.getProvider()) != null ? provider.getClass() : template.getClass())).getType().isSafeToReport()) {
            String templateId = provider != null ? provider.getId() + "/" + template.getId() : template.getId();
            String id = pluginInfo.getType().isDevelopedByJetBrains() ? templateId : THIRD_PARTY_PLUGIN_POSTFIX_TEMPLATE_ID;
            FeatureUsageData data = new FeatureUsageData().addPluginInfo(pluginInfo);
            FUCounterUsageLogger.getInstance().logEvent(context.getProject(), USAGE_GROUP, id, data);
        }
        if (template.startInWriteAction()) {
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(context.getProject(), () -> template.expand(context, editor), "Expand postfix template", (Object)POSTFIX_TEMPLATE_ID));
        } else {
            template.expand(context, editor);
        }
    }

    private static int deleteTemplateKey(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull String key) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int currentOffset = editor.getCaretModel().getOffset();
        int newOffset = currentOffset - key.length();
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            Document document = editor.getDocument();
            document.deleteString(newOffset, currentOffset);
            editor.getCaretModel().moveToOffset(newOffset);
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        }));
        return newOffset;
    }

    private static Condition<PostfixTemplate> createIsApplicationTemplateFunction(@NotNull PostfixTemplateProvider provider, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2.getFileType().isBinary()) {
            return Conditions.alwaysFalse();
        }
        int currentOffset = editor.getCaretModel().getOffset();
        int newOffset = currentOffset - key.length();
        CharSequence fileContent = editor.getDocument().getCharsSequence();
        StringBuilder fileContentWithoutKey = new StringBuilder();
        fileContentWithoutKey.append(fileContent.subSequence(0, newOffset));
        fileContentWithoutKey.append(fileContent.subSequence(currentOffset, fileContent.length()));
        PsiFile copyFile = PostfixLiveTemplate.copyFile(file2, fileContentWithoutKey);
        Document copyDocument = copyFile.getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        copyDocument = (copyFile = provider.preCheck(copyFile, editor, newOffset)).getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        PsiElement context = CustomTemplateCallback.getContext(copyFile, PostfixLiveTemplate.positiveOffset(newOffset));
        Document finalCopyDocument = copyDocument;
        return template -> template != null && template.isEnabled(provider) && template.isApplicable(context, finalCopyDocument, newOffset);
    }

    @NotNull
    public static PsiFile copyFile(@NotNull PsiFile file2, @NotNull StringBuilder fileContentWithoutKey) {
        VirtualFile vFile;
        PsiFile copy;
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)file2.getProject());
        Language language = LanguageUtil.getLanguageForPsi((Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
        PsiFile psiFile = copy = language != null ? psiFileFactory.createFileFromText(file2.getName(), language, (CharSequence)fileContentWithoutKey, false, true) : psiFileFactory.createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)fileContentWithoutKey);
        if (copy instanceof PsiFileImpl) {
            ((PsiFileImpl)copy).setOriginalFile(TemplateLanguageUtil.getBaseFile((PsiFile)file2));
        }
        if ((vFile = copy.getVirtualFile()) != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        return copy;
    }

    public static boolean isApplicableTemplate(@NotNull PostfixTemplateProvider provider, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor) {
        return PostfixLiveTemplate.findApplicableTemplate(provider, key, editor, file2) != null;
    }

    private static boolean isApplicableTemplate(@NotNull PostfixTemplateProvider provider, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor, @Nullable PostfixTemplate template) {
        return PostfixLiveTemplate.createIsApplicationTemplateFunction(provider, key, file2, editor).value((Object)template);
    }

    @NotNull
    private static Set<String> getKeys(@NotNull PostfixTemplateProvider provider) {
        HashSet result2 = ContainerUtil.newHashSet();
        for (PostfixTemplate template : PostfixTemplatesUtils.getAvailableTemplates(provider)) {
            result2.add(template.getKey());
        }
        return result2;
    }

    @Nullable
    private static PostfixTemplate findApplicableTemplate(@NotNull PostfixTemplateProvider provider, @Nullable String key, @NotNull Editor editor, @NotNull PsiFile file2) {
        for (PostfixTemplate template : PostfixTemplatesUtils.getAvailableTemplates(provider)) {
            if (!template.getKey().equals(key) || !PostfixLiveTemplate.isApplicableTemplate(provider, key, file2, editor, template)) continue;
            return template;
        }
        return null;
    }

    private static Language getLanguage(@NotNull CustomTemplateCallback callback2) {
        return PsiUtilCore.getLanguageAtOffset((PsiFile)callback2.getFile(), (int)callback2.getOffset());
    }

    private static int positiveOffset(int offset) {
        return offset > 0 ? offset - 1 : offset;
    }
}

