/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplate {
    @NotNull
    private final String myId;
    @NotNull
    private final String myPresentableName;
    @NotNull
    private final String myKey;
    @NotNull
    private final NotNullLazyValue<String> myLazyDescription = NotNullLazyValue.createValue(() -> this.calcDescription());
    @NotNull
    private final String myExample;
    @Nullable
    private final PostfixTemplateProvider myProvider;

    @Deprecated
    protected PostfixTemplate(@NotNull String name, @NotNull String example) {
        this(null, name, "." + name, example, null);
    }

    protected PostfixTemplate(@Nullable String id, @NotNull String name, @NotNull String example, @Nullable PostfixTemplateProvider provider) {
        this(id, name, "." + name, example, provider);
    }

    @Deprecated
    protected PostfixTemplate(@NotNull String name, @NotNull String key, @NotNull String example) {
        this(null, name, key, example, null);
    }

    protected PostfixTemplate(@Nullable String id, @NotNull String name, @NotNull String key, @NotNull String example, @Nullable PostfixTemplateProvider provider) {
        this.myId = id != null ? id : this.getClass().getName() + "#" + key;
        this.myPresentableName = name;
        this.myKey = key;
        this.myExample = example;
        this.myProvider = provider;
    }

    @NotNull
    protected String calcDescription() {
        String defaultDescription = "Under construction";
        try {
            return PostfixTemplateMetaData.createMetaData(this).getDescription().getText();
        }
        catch (IOException iOException) {
            return defaultDescription;
        }
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public final String getKey() {
        return this.myKey;
    }

    @NotNull
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NotNull
    public String getDescription() {
        return (String)this.myLazyDescription.getValue();
    }

    @NotNull
    public String getExample() {
        return this.myExample;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isEnabled(PostfixTemplateProvider provider) {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings.isPostfixTemplatesEnabled() && settings.isTemplateEnabled(this, provider);
    }

    public abstract boolean isApplicable(@NotNull PsiElement var1, @NotNull Document var2, int var3);

    public abstract void expand(@NotNull PsiElement var1, @NotNull Editor var2);

    @Nullable
    public PostfixTemplateProvider getProvider() {
        return this.myProvider;
    }

    public boolean isBuiltin() {
        return true;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostfixTemplate)) {
            return false;
        }
        PostfixTemplate template = (PostfixTemplate)o;
        return Objects.equals(this.myId, template.myId) && Objects.equals(this.myPresentableName, template.myPresentableName) && Objects.equals(this.myKey, template.myKey) && Objects.equals(this.getDescription(), template.getDescription()) && Objects.equals(this.myExample, template.myExample) && Objects.equals(this.myProvider, template.myProvider);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myPresentableName, this.myKey, this.getDescription(), this.myExample, this.myProvider);
    }
}

