/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateStorage;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplateWithMultipleExpressions;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplatesUtils {
    public static final String CONDITION_TAG = "condition";
    public static final String CONDITIONS_TAG = "conditions";
    public static final String TOPMOST_ATTR = "topmost";

    private PostfixTemplatesUtils() {
    }

    @NotNull
    public static Set<PostfixTemplate> getAvailableTemplates(@NotNull PostfixTemplateProvider provider) {
        HashSet result2 = ContainerUtil.newHashSet(provider.getTemplates());
        for (PostfixTemplate template : PostfixTemplateStorage.getInstance().getTemplates(provider)) {
            if (template instanceof PostfixChangedBuiltinTemplate) {
                result2.remove(((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate());
            }
            result2.add(template);
        }
        return result2;
    }

    @Nullable
    public static TextRange surround(@NotNull Surrounder surrounder, @NotNull Editor editor, @NotNull PsiElement expr) {
        Project project = expr.getProject();
        PsiElement[] elements = new PsiElement[]{expr};
        if (surrounder.isApplicable(elements)) {
            return surrounder.surroundElements(project, editor, elements);
        }
        PostfixTemplatesUtils.showErrorHint(project, editor);
        return null;
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Can't expand postfix template", (String)"Can't expand postfix template", (String)"");
    }

    @NotNull
    public static String generateTemplateId(@NotNull String templateKey, @NotNull PostfixTemplateProvider provider) {
        HashSet<String> usedIds = new HashSet<String>();
        for (PostfixTemplate builtinTemplate : provider.getTemplates()) {
            usedIds.add(builtinTemplate.getId());
        }
        for (PostfixTemplate template : PostfixTemplateStorage.getInstance().getTemplates(provider)) {
            usedIds.add(template.getId());
        }
        return UniqueNameGenerator.generateUniqueName((String)(templateKey + "@userDefined"), usedIds);
    }

    public static void writeExternalTemplate(@NotNull PostfixTemplate template, @NotNull Element parentElement) {
        if (template instanceof EditablePostfixTemplateWithMultipleExpressions) {
            parentElement.setAttribute(TOPMOST_ATTR, String.valueOf(((EditablePostfixTemplateWithMultipleExpressions)template).isUseTopmostExpression()));
            Element conditionsTag = new Element(CONDITIONS_TAG);
            Set conditions = ((EditablePostfixTemplateWithMultipleExpressions)template).getExpressionConditions();
            for (PostfixTemplateExpressionCondition condition : conditions) {
                Element element = new Element(CONDITION_TAG);
                condition.serializeTo(element);
                conditionsTag.addContent(element);
            }
            parentElement.addContent(conditionsTag);
        }
        Element templateTag = TemplateSettings.serializeTemplate(((EditablePostfixTemplate)template).getLiveTemplate(), null, (Lazy<Map<String, TemplateContextType>>)LazyKt.lazyOf(Collections.emptyMap()));
        parentElement.addContent(templateTag);
    }

    @NotNull
    public static <T extends PostfixTemplateExpressionCondition> Set<T> readExternalConditions(@NotNull Element template, @NotNull Function<? super Element, ? extends T> conditionFactory) {
        Element conditionsElement = template.getChild(CONDITIONS_TAG);
        if (conditionsElement != null) {
            LinkedHashSet conditions = new LinkedHashSet();
            for (Element conditionElement : conditionsElement.getChildren(CONDITION_TAG)) {
                PostfixTemplateExpressionCondition fun = (PostfixTemplateExpressionCondition)conditionFactory.fun((Object)conditionElement);
                if (fun == null) continue;
                ContainerUtil.addIfNotNull(conditions, (Object)fun);
            }
            return conditions;
        }
        return Collections.emptySet();
    }

    @Nullable
    public static TemplateImpl readExternalLiveTemplate(@NotNull Element template, @NotNull PostfixTemplateProvider provider) {
        Element templateChild = template.getChild("template");
        if (templateChild == null) {
            return null;
        }
        return TemplateSettings.readTemplateFromElement("", templateChild, provider.getClass().getClassLoader());
    }

    public static boolean readExternalTopmostAttribute(@NotNull Element template) {
        return Boolean.parseBoolean(template.getAttributeValue(TOPMOST_ATTR));
    }
}

