/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates.editable;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class EditablePostfixTemplateWithMultipleExpressions<ConditionType extends PostfixTemplateExpressionCondition>
extends EditablePostfixTemplate {
    @NotNull
    protected final Set<ConditionType> myExpressionConditions;
    protected final boolean myUseTopmostExpression;

    protected EditablePostfixTemplateWithMultipleExpressions(@NotNull String templateId, @NotNull String templateName, @NotNull TemplateImpl liveTemplate, @NotNull String example, @NotNull Set<ConditionType> expressionConditions, boolean useTopmostExpression, @NotNull PostfixTemplateProvider provider) {
        super(templateId, templateName, liveTemplate, example, provider);
        this.myExpressionConditions = expressionConditions;
        this.myUseTopmostExpression = useTopmostExpression;
    }

    protected EditablePostfixTemplateWithMultipleExpressions(@NotNull String templateId, @NotNull String templateName, @NotNull String templateKey, @NotNull TemplateImpl liveTemplate, @NotNull String example, @NotNull Set<ConditionType> expressionConditions, boolean useTopmostExpression, @NotNull PostfixTemplateProvider provider) {
        super(templateId, templateName, templateKey, liveTemplate, example, provider);
        this.myExpressionConditions = expressionConditions;
        this.myUseTopmostExpression = useTopmostExpression;
    }

    @NotNull
    protected static TemplateImpl createTemplate(@NotNull String templateText) {
        TemplateImpl template = new TemplateImpl("fakeKey", templateText, "");
        template.setToReformat(true);
        template.parseSegments();
        return template;
    }

    @Override
    @NotNull
    protected PsiElement getElementToRemove(@NotNull PsiElement element) {
        if (this.myUseTopmostExpression) {
            return this.getTopmostExpression(element);
        }
        return element;
    }

    @NotNull
    protected abstract PsiElement getTopmostExpression(@NotNull PsiElement var1);

    @NotNull
    public Set<ConditionType> getExpressionConditions() {
        return this.myExpressionConditions;
    }

    public boolean isUseTopmostExpression() {
        return this.myUseTopmostExpression;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EditablePostfixTemplateWithMultipleExpressions that = (EditablePostfixTemplateWithMultipleExpressions)o;
        return this.myUseTopmostExpression == that.myUseTopmostExpression && Objects.equals(this.myExpressionConditions, that.myExpressionConditions);
    }

    @NotNull
    protected Condition<PsiElement> getExpressionCompositeCondition() {
        return e -> {
            for (PostfixTemplateExpressionCondition condition : this.myExpressionConditions) {
                if (!condition.value(e)) continue;
                return true;
            }
            return this.myExpressionConditions.isEmpty();
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myExpressionConditions, this.myUseTopmostExpression);
    }
}

