/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.RangeSplitter;
import com.intellij.codeInsight.unwrap.UnwrapHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ScopeHighlighter {
    public static final NotNullFunction<PsiElement, TextRange> NATURAL_RANGER = dom -> dom.getTextRange();
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final List<RangeHighlighter> myActiveHighliters = new ArrayList<RangeHighlighter>();
    @NotNull
    private final NotNullFunction<? super PsiElement, ? extends TextRange> myRanger;

    public ScopeHighlighter(@NotNull Editor editor) {
        this(editor, NATURAL_RANGER);
    }

    public ScopeHighlighter(@NotNull Editor editor, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger) {
        this.myEditor = editor;
        this.myRanger = ranger;
    }

    public void highlight(@NotNull PsiElement wholeAffected, @NotNull List<PsiElement> toExtract) {
        Pair<TextRange, List<TextRange>> ranges = this.collectTextRanges(wholeAffected, toExtract);
        this.highlight(ranges);
    }

    public void highlight(@NotNull Pair<TextRange, List<TextRange>> ranges) {
        this.dropHighlight();
        TextRange wholeRange = (TextRange)ranges.first;
        List rangesToExtract = (List)ranges.second;
        List<TextRange> rangesToRemove = RangeSplitter.split(wholeRange, rangesToExtract);
        for (TextRange r : rangesToRemove) {
            this.addHighlighter(r, 6001, ScopeHighlighter.getTestAttributesForRemoval());
        }
        for (TextRange r : rangesToExtract) {
            this.addHighlighter(r, 6001, UnwrapHandler.getTestAttributesForExtract());
        }
    }

    private Pair<TextRange, List<TextRange>> collectTextRanges(PsiElement wholeElement, List<PsiElement> elementsToExtract) {
        TextRange affectedRange = this.getRange(wholeElement);
        ArrayList<TextRange> rangesToExtract = new ArrayList<TextRange>();
        for (PsiElement e : elementsToExtract) {
            rangesToExtract.add(this.getRange(e));
        }
        return Pair.create((Object)affectedRange, rangesToExtract);
    }

    private TextRange getRange(PsiElement e) {
        return (TextRange)this.myRanger.fun((Object)e);
    }

    private void addHighlighter(TextRange r, int level, TextAttributes attr) {
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(r.getStartOffset(), r.getEndOffset(), level, attr, HighlighterTargetArea.EXACT_RANGE);
        this.myActiveHighliters.add(highlighter);
    }

    public void dropHighlight() {
        for (RangeHighlighter h : this.myActiveHighliters) {
            h.dispose();
        }
        this.myActiveHighliters.clear();
    }

    private static TextAttributes getTestAttributesForRemoval() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        return manager.getGlobalScheme().getAttributes(EditorColors.DELETED_TEXT_ATTRIBUTES);
    }
}

