/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.unwrap.LanguageUnwrappers;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class UnwrapHandler
implements CodeInsightActionHandler {
    public static final int HIGHLIGHTER_LEVEL = 6001;

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        List<MyUnwrapAction> options = UnwrapHandler.collectOptions(project, editor, file2);
        this.selectOption(options, editor, file2);
    }

    @NotNull
    private static List<MyUnwrapAction> collectOptions(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        ArrayList<MyUnwrapAction> result2 = new ArrayList<MyUnwrapAction>();
        UnwrapDescriptor descriptor = UnwrapHandler.getUnwrapDescription(file2);
        for (Pair<PsiElement, Unwrapper> desc : descriptor.collectUnwrappers(project, editor, file2)) {
            PsiElement element = (PsiElement)desc.getFirst();
            Unwrapper unwrapper = (Unwrapper)desc.getSecond();
            if (element == null || unwrapper == null) {
                throw new IllegalStateException(descriptor + " returned " + desc);
            }
            result2.add(UnwrapHandler.createUnwrapAction(unwrapper, element, editor, project));
        }
        return result2;
    }

    private static UnwrapDescriptor getUnwrapDescription(@NotNull PsiFile file2) {
        return (UnwrapDescriptor)LanguageUnwrappers.INSTANCE.forLanguage(file2.getLanguage());
    }

    private static MyUnwrapAction createUnwrapAction(@NotNull Unwrapper u, @NotNull PsiElement el, @NotNull Editor ed, @NotNull Project p) {
        return new MyUnwrapAction(p, ed, u, el);
    }

    protected void selectOption(List<MyUnwrapAction> options, Editor editor, PsiFile file2) {
        if (options.isEmpty()) {
            return;
        }
        if (!UnwrapHandler.getUnwrapDescription(file2).showOptionsDialog() || ApplicationManager.getApplication().isUnitTestMode()) {
            options.get(0).perform();
            return;
        }
        UnwrapHandler.showPopup(options, editor);
    }

    private static void showPopup(List<? extends AnAction> options, Editor editor) {
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        List model = ContainerUtil.map(options, a -> new MyItem(((MyUnwrapAction)((Object)a)).getName(), options.indexOf(a)));
        Function<MyItem, MyUnwrapAction> optionByName = item -> (MyUnwrapAction)((Object)((Object)options.get(item.index)));
        JBPopupFactory.getInstance().createPopupChooserBuilder(model).setTitle(CodeInsightBundle.message((String)"unwrap.popup.title", (Object[])new Object[0])).setMovable(false).setNamerForFiltering(item -> item.name).setSelectionMode(0).setResizable(false).setRequestFocus(true).setItemChosenCallback(selectedValue -> ((MyUnwrapAction)((Object)((Object)optionByName.apply((MyItem)selectedValue)))).perform()).setItemSelectedCallback(item -> {
            if (item != null) {
                MyUnwrapAction a = (MyUnwrapAction)((Object)((Object)optionByName.apply((MyItem)item)));
                NotNullList toExtract = new NotNullList();
                PsiElement wholeRange = a.collectAffectedElements((List<PsiElement>)toExtract);
                highlighter.highlight(wholeRange, (List<PsiElement>)toExtract);
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                highlighter.dropHighlight();
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    public static TextAttributes getTestAttributesForExtract() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        return manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    protected static class MyUnwrapAction
    extends AnAction {
        private static final Key<Integer> CARET_POS_KEY = new Key("UNWRAP_HANDLER_CARET_POSITION");
        private final Project myProject;
        private final Editor myEditor;
        private final Unwrapper myUnwrapper;
        @NotNull
        private final PsiElement myElement;

        MyUnwrapAction(@NotNull Project project, @NotNull Editor editor, @NotNull Unwrapper unwrapper, @NotNull PsiElement element) {
            super(unwrapper.getDescription(element));
            this.myProject = project;
            this.myEditor = editor;
            this.myUnwrapper = unwrapper;
            this.myElement = element;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.perform();
        }

        public void perform() {
            PsiFile file2 = this.myElement.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    UnwrapDescriptor d = UnwrapHandler.getUnwrapDescription(file2);
                    if (d.shouldTryToRestoreCaretPosition()) {
                        this.saveCaretPosition(file2);
                    }
                    int scrollOffset = this.myEditor.getScrollingModel().getVerticalScrollOffset();
                    List<PsiElement> extractedElements = this.myUnwrapper.unwrap(this.myEditor, this.myElement);
                    if (d.shouldTryToRestoreCaretPosition()) {
                        this.restoreCaretPosition(file2);
                    }
                    this.myEditor.getScrollingModel().scrollVertically(scrollOffset);
                    this.highlightExtractedElements(extractedElements);
                }
                catch (IncorrectOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }), null, (Object)this.myEditor.getDocument());
        }

        private void saveCaretPosition(PsiFile file2) {
            int offset = this.myEditor.getCaretModel().getOffset();
            PsiElement el = file2.findElementAt(offset);
            if (el == null) {
                return;
            }
            int innerOffset = offset - el.getTextOffset();
            el.putCopyableUserData(CARET_POS_KEY, (Object)innerOffset);
        }

        private void restoreCaretPosition(PsiFile file2) {
            ((TreeElement)file2.getNode()).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement element) {
                    PsiElement el = element.getPsi();
                    Integer offset = (Integer)el.getCopyableUserData(CARET_POS_KEY);
                    if (offset != null) {
                        myEditor.getCaretModel().moveToOffset(el.getTextOffset() + offset);
                        el.putCopyableUserData(CARET_POS_KEY, null);
                        return;
                    }
                    super.visitNode(element);
                }
            });
        }

        private void highlightExtractedElements(List<PsiElement> extractedElements) {
            for (PsiElement each : extractedElements) {
                TextRange textRange = each.getTextRange();
                HighlightManager.getInstance((Project)this.myProject).addRangeHighlight(this.myEditor, textRange.getStartOffset(), textRange.getEndOffset(), UnwrapHandler.getTestAttributesForExtract(), false, true, null);
            }
        }

        public String getName() {
            return this.myUnwrapper.getDescription(this.myElement);
        }

        PsiElement collectAffectedElements(@NotNull List<PsiElement> toExtract) {
            return this.myUnwrapper.collectAffectedElements(this.myElement, toExtract);
        }
    }

    private static class MyItem {
        final String name;
        final int index;

        MyItem(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }
    }
}

