/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotatorInspectionVisitor
extends PsiElementVisitor {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotatorInspectionVisitor.class);
    private final ProblemsHolder myHolder;
    private final ExternalAnnotator myAnnotator;
    private final boolean myIsOnTheFly;

    public ExternalAnnotatorInspectionVisitor(ProblemsHolder holder, ExternalAnnotator annotator, boolean isOnTheFly) {
        this.myHolder = holder;
        this.myAnnotator = annotator;
        this.myIsOnTheFly = isOnTheFly;
    }

    public void visitFile(PsiFile file2) {
        ProblemDescriptor[] descriptors = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator(file2, this.myHolder.getManager(), this.myIsOnTheFly, this.myAnnotator);
        this.addDescriptors(descriptors);
    }

    @NotNull
    public static <Init, Result> ProblemDescriptor[] checkFileWithExternalAnnotator(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull ExternalAnnotator<Init, Result> annotator) {
        if (isOnTheFly) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Object info = ReadAction.compute(() -> annotator.collectInformation(file2));
        if (info != null) {
            Object annotationResult = annotator.doAnnotate(info);
            if (annotationResult == null) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            return (ProblemDescriptor[])ReadAction.compute(() -> {
                AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2), true);
                annotator.apply(file2, annotationResult, (AnnotationHolder)annotationHolder);
                return ProblemDescriptorUtil.convertToProblemDescriptors((List<Annotation>)((Object)annotationHolder), file2);
            });
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private void addDescriptors(@NotNull ProblemDescriptor[] descriptors) {
        for (ProblemDescriptor descriptor : descriptors) {
            LOG.assertTrue(descriptor != null, (Object)((Object)((Object)this)).getClass().getName());
            this.myHolder.registerProblem(descriptor);
        }
    }

    public static class LocalQuickFixBackedByIntentionAction
    implements LocalQuickFix,
    Iconable {
        private final IntentionAction myAction;

        public LocalQuickFixBackedByIntentionAction(@NotNull IntentionAction action) {
            this.myAction = action;
        }

        @NotNull
        public String getName() {
            return this.myAction.getText();
        }

        @NotNull
        public String getFamilyName() {
            return this.myAction.getFamilyName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            this.myAction.invoke(project, null, LocalQuickFixBackedByIntentionAction.getPsiFile(descriptor));
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
            return this.myAction.getElementToMakeWritable(file2);
        }

        @Nullable
        private static PsiFile getPsiFile(@NotNull ProblemDescriptor descriptor) {
            PsiElement startElement = descriptor.getStartElement();
            if (startElement != null) {
                return startElement.getContainingFile();
            }
            PsiElement endElement = descriptor.getEndElement();
            if (endElement != null) {
                return endElement.getContainingFile();
            }
            return null;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            if (this.myAction instanceof Iconable) {
                return ((Iconable)this.myAction).getIcon(flags);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalQuickFixBackedByIntentionAction action = (LocalQuickFixBackedByIntentionAction)o;
            return this.myAction.equals(action.myAction);
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }
    }
}

