/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEngine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionEngine");
    private static final Set<Class<? extends LocalInspectionTool>> RECURSIVE_VISITOR_TOOL_CLASSES = ContainerUtil.newConcurrentSet();

    @NotNull
    public static PsiElementVisitor createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2, @NotNull List<? extends PsiElement> elements, @NotNull Set<String> elementDialectIds, @Nullable(value="null means all accepted") Set<String> dialectIdsSpecifiedForTool) {
        PsiElementVisitor visitor = tool.buildVisitor(holder, isOnTheFly, session2);
        if (visitor == null) {
            LOG.error("Tool " + tool + " (" + tool.getClass() + ") must not return null from the buildVisitor() method");
        } else if (visitor instanceof PsiRecursiveVisitor && RECURSIVE_VISITOR_TOOL_CLASSES.add(tool.getClass())) {
            LOG.error("The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive: " + tool);
        }
        tool.inspectionStarted(session2, isOnTheFly);
        InspectionEngine.acceptElements(elements, visitor, elementDialectIds, dialectIdsSpecifiedForTool);
        return visitor;
    }

    public static void acceptElements(@NotNull List<? extends PsiElement> elements, @NotNull PsiElementVisitor elementVisitor, @NotNull Set<String> elementDialectIds, @Nullable(value="null means all accepted") Set<String> dialectIdsSpecifiedForTool) {
        if (dialectIdsSpecifiedForTool != null && !InspectionEngine.intersect(elementDialectIds, dialectIdsSpecifiedForTool)) {
            return;
        }
        int elementsSize = elements.size();
        for (int i = 0; i < elementsSize; ++i) {
            PsiElement element = elements.get(i);
            element.accept(elementVisitor);
            ProgressManager.checkCanceled();
        }
    }

    private static boolean intersect(@NotNull Set<String> ids1, @NotNull Set<String> ids2) {
        if (ids1.size() > ids2.size()) {
            Set<String> tmp = ids1;
            ids1 = ids2;
            ids2 = tmp;
        }
        for (String id : ids1) {
            if (!ids2.contains(id)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<ProblemDescriptor> inspect(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, @NotNull ProgressIndicator indicator) {
        Map<String, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(toolWrappers, file2, iManager, false, indicator);
        ArrayList<ProblemDescriptor> result2 = new ArrayList<ProblemDescriptor>();
        for (List<ProblemDescriptor> group : problemDescriptors.values()) {
            result2.addAll(group);
        }
        return result2;
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator) {
        if (toolWrappers.isEmpty()) {
            return Collections.emptyMap();
        }
        TextRange range2 = file2.getTextRange();
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(file2, range2, range2, (Condition<? super PsiFile>)Conditions.alwaysTrue(), (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List elements = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat((List[])new List[]{d.inside, d.outside, d.parents})));
        return InspectionEngine.inspectElements(toolWrappers, file2, iManager, isOnTheFly, indicator, elements, InspectionEngine.calcElementDialectIds(elements));
    }

    @NotNull
    static Map<String, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements, @NotNull Set<String> elementDialectIds) {
        TextRange range2 = file2.getTextRange();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(file2, range2.getStartOffset(), range2.getEndOffset());
        Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedDialectIds = InspectionEngine.getToolsToSpecifiedLanguages(toolWrappers);
        ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>> entries2 = new ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>>(toolToSpecifiedDialectIds.entrySet());
        ConcurrentHashMap<String, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<String, List<ProblemDescriptor>>();
        Processor processor2 = entry -> {
            ProblemsHolder holder = new ProblemsHolder(iManager, file2, isOnTheFly);
            LocalInspectionTool tool = (LocalInspectionTool)((LocalInspectionToolWrapper)((Object)((Object)entry.getKey()))).getTool();
            Set dialectIdsSpecifiedForTool = (Set)entry.getValue();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session2, elements, elementDialectIds, dialectIdsSpecifiedForTool);
            tool.inspectionFinished(session2, holder);
            if (holder.hasResults()) {
                resultDescriptors.put(tool.getShortName(), ContainerUtil.filter((Collection)holder.getResults(), descriptor -> {
                    PsiElement element = descriptor.getPsiElement();
                    return element == null || !SuppressionUtil.inspectionResultSuppressed(element, tool);
                }));
            }
            return true;
        };
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(entries2, indicator, processor2);
        return resultDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file2, @NotNull InspectionToolWrapper toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        final InspectionManager inspectionManager = InspectionManager.getInstance((Project)file2.getProject());
        toolWrapper.initialize(inspectionContext);
        RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
        refManager.inspectionReadActionStarted();
        try {
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                List<ProblemDescriptor> list2 = InspectionEngine.inspect(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file2, inspectionManager, (ProgressIndicator)new EmptyProgressIndicator());
                return list2;
            }
            if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
                final ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                if (globalTool instanceof GlobalSimpleInspectionTool) {
                    GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                    ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file2, false);
                    ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                        public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                            return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                        }

                        public void ignoreElement(@NotNull RefEntity refEntity) {
                            throw new UnsupportedOperationException();
                        }

                        public void resolveProblem(@NotNull CommonProblemDescriptor descriptor) {
                            throw new UnsupportedOperationException();
                        }

                        public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                            if (!(refEntity instanceof RefElement)) {
                                return;
                            }
                            PsiElement element = ((RefElement)refEntity).getPsiElement();
                            InspectionEngine.convertToProblemDescriptors(element, commonProblemDescriptors, descriptors);
                        }

                        public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
                            throw new RuntimeException();
                        }
                    };
                    simpleTool.checkFile(file2, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                    ArrayList<ProblemDescriptor> arrayList = descriptors;
                    return arrayList;
                }
                RefElement fileRef = refManager.getReference((PsiElement)file2);
                final AnalysisScope scope = new AnalysisScope(file2);
                assert (fileRef != null);
                fileRef.accept(new RefVisitor(){

                    public void visitElement(@NotNull RefEntity elem) {
                        CommonProblemDescriptor[] elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext);
                        if (elemDescriptors != null) {
                            InspectionEngine.convertToProblemDescriptors((PsiElement)file2, elemDescriptors, descriptors);
                        }
                        for (RefEntity child2 : elem.getChildren()) {
                            child2.accept((RefVisitor)this);
                        }
                    }
                });
                ArrayList<ProblemDescriptor> arrayList = descriptors;
                return arrayList;
            }
        }
        finally {
            refManager.inspectionReadActionFinished();
            toolWrapper.cleanup(file2.getProject());
            inspectionContext.cleanup();
        }
        return Collections.emptyList();
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element, @NotNull CommonProblemDescriptor[] commonProblemDescriptors, @NotNull List<? super ProblemDescriptor> descriptors) {
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                descriptors.add((ProblemDescriptor)((ProblemDescriptor)common));
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element, element, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            descriptors.add(base);
        }
    }

    @NotNull
    public static Map<LocalInspectionToolWrapper, Set<String>> getToolsToSpecifiedLanguages(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers) {
        THashMap toolToLanguages = new THashMap();
        for (LocalInspectionToolWrapper localInspectionToolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            Set<String> specifiedLangIds = InspectionEngine.getDialectIdsSpecifiedForTool(localInspectionToolWrapper);
            toolToLanguages.put(localInspectionToolWrapper, specifiedLangIds);
        }
        return toolToLanguages;
    }

    @Nullable(value="null means not specified")
    public static Set<String> getDialectIdsSpecifiedForTool(@NotNull LocalInspectionToolWrapper wrapper2) {
        THashSet result2;
        String langId = wrapper2.getLanguage();
        if (langId == null) {
            return null;
        }
        Language language = Language.findLanguageByID((String)langId);
        if (language == null) {
            result2 = Collections.singleton(langId);
        } else if (language instanceof MetaLanguage) {
            Collection matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            result2 = new THashSet();
            for (Language matchingLanguage : matchingLanguages) {
                result2.addAll(InspectionEngine.getLanguageWithDialects(wrapper2, matchingLanguage));
            }
        } else {
            result2 = InspectionEngine.getLanguageWithDialects(wrapper2, language);
        }
        return result2;
    }

    @NotNull
    private static Set<String> getLanguageWithDialects(@NotNull LocalInspectionToolWrapper wrapper2, Language language) {
        List dialects = language.getDialects();
        boolean applyToDialects = wrapper2.applyToDialects();
        SmartHashSet result2 = applyToDialects && !dialects.isEmpty() ? new THashSet(1 + dialects.size()) : new SmartHashSet();
        result2.add(language.getID());
        if (applyToDialects) {
            for (Language dialect : dialects) {
                result2.add(dialect.getID());
            }
        }
        return result2;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(inside, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        InspectionEngine.addDialects(outside, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        return dialectIds;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> elements) {
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(elements, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        return dialectIds;
    }

    private static void addDialects(@NotNull List<? extends PsiElement> elements, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        for (PsiElement psiElement : elements) {
            Language language = psiElement.getLanguage();
            outDialectIds.add(language.getID());
            if (!outProcessedLanguages.add((Language)language)) continue;
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }
}

