/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.ModuleProblemDescriptorImpl;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionManagerBase
extends InspectionManager {
    private final Project myProject;
    @NonNls
    protected String myCurrentProfileName;

    public InspectionManagerBase(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public CommonProblemDescriptor createProblemDescriptor(@NotNull String descriptionTemplate, QuickFix ... fixes) {
        return new CommonProblemDescriptorImpl(fixes, descriptionTemplate);
    }

    @NotNull
    public ModuleProblemDescriptor createProblemDescriptor(@Nls @NotNull String descriptionTemplate, Module module, QuickFix ... fixes) {
        return new ModuleProblemDescriptorImpl(fixes, descriptionTemplate, module);
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix fix, @NotNull ProblemHighlightType highlightType, boolean onTheFly) {
        LocalQuickFix[] localQuickFixArray;
        if (fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        } else {
            localQuickFixArray = null;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        return this.createProblemDescriptor(psiElement, descriptionTemplate, onTheFly, quickFixes, highlightType);
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, boolean onTheFly, LocalQuickFix[] fixes, @NotNull ProblemHighlightType highlightType) {
        return this.createProblemDescriptor(psiElement, descriptionTemplate, fixes, highlightType, onTheFly, false);
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix[] fixes, @NotNull ProblemHighlightType highlightType, boolean onTheFly, boolean isAfterEndOfLine) {
        return new ProblemDescriptorBase(psiElement, psiElement, descriptionTemplate, fixes, highlightType, isAfterEndOfLine, null, highlightType != ProblemHighlightType.INFORMATION, onTheFly);
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, boolean onTheFly, LocalQuickFix ... fixes) {
        return new ProblemDescriptorBase(startElement, endElement, descriptionTemplate, fixes, highlightType, false, null, highlightType != ProblemHighlightType.INFORMATION, onTheFly);
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, TextRange rangeInElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, boolean onTheFly, LocalQuickFix ... fixes) {
        return new ProblemDescriptorBase(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, rangeInElement, highlightType != ProblemHighlightType.INFORMATION, onTheFly);
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, boolean showTooltip, @NotNull ProblemHighlightType highlightType, boolean onTheFly, LocalQuickFix ... fixes) {
        return new ProblemDescriptorBase(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, showTooltip, onTheFly);
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix fix, @NotNull ProblemHighlightType highlightType) {
        LocalQuickFix[] localQuickFixArray;
        if (fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        } else {
            localQuickFixArray = null;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        return this.createProblemDescriptor(psiElement, descriptionTemplate, false, quickFixes, highlightType);
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix[] fixes, @NotNull ProblemHighlightType highlightType) {
        return this.createProblemDescriptor(psiElement, descriptionTemplate, fixes, highlightType, false, false);
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, LocalQuickFix[] fixes, @NotNull ProblemHighlightType highlightType, boolean isAfterEndOfLine) {
        return this.createProblemDescriptor(psiElement, descriptionTemplate, fixes, highlightType, true, isAfterEndOfLine);
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        return this.createProblemDescriptor(startElement, endElement, descriptionTemplate, highlightType, true, fixes);
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, TextRange rangeInElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        return this.createProblemDescriptor(psiElement, rangeInElement, descriptionTemplate, highlightType, true, fixes);
    }

    public String getCurrentProfile() {
        if (this.myCurrentProfileName == null) {
            this.myCurrentProfileName = ProjectInspectionProfileManager.getInstance(this.getProject()).getProjectProfile();
            if (this.myCurrentProfileName == null) {
                this.myCurrentProfileName = InspectionProfileManager.getInstance().getCurrentProfile().getName();
            }
        }
        return this.myCurrentProfileName;
    }
}

