/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.DataManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LossyEncodingInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.LossyEncodingInspection");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"lossy.encoding", (Object[])new Object[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "LossyEncoding";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            return null;
        }
        if (!file2.isPhysical()) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return null;
        }
        CharSequence text = viewProvider.getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile, text);
        if (charset instanceof Native2AsciiCharset) {
            return null;
        }
        SmartList descriptors = new SmartList();
        boolean ok = LossyEncodingInspection.checkFileLoadedInWrongEncoding(file2, manager, isOnTheFly, virtualFile, charset, (List<? super ProblemDescriptor>)descriptors);
        if (ok) {
            LossyEncodingInspection.checkIfCharactersWillBeLostAfterSave(file2, manager, isOnTheFly, text, charset, (List<ProblemDescriptor>)descriptors);
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static boolean checkFileLoadedInWrongEncoding(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull List<? super ProblemDescriptor> descriptors) {
        if (FileDocumentManager.getInstance().isFileModified(virtualFile) || !EncodingUtil.canReload(virtualFile)) {
            return true;
        }
        if (!LossyEncodingInspection.isGoodCharset(virtualFile, charset)) {
            LocalQuickFix[] fixes = LossyEncodingInspection.getFixes(file2, virtualFile, charset);
            descriptors.add((ProblemDescriptor)manager.createProblemDescriptor((PsiElement)file2, "File was loaded in the wrong encoding: '" + charset + "'", true, ProblemHighlightType.GENERIC_ERROR, isOnTheFly, fixes));
            return false;
        }
        return true;
    }

    @NotNull
    private static LocalQuickFix[] getFixes(final @NotNull PsiFile file2, final @NotNull VirtualFile virtualFile, @NotNull Charset wrongCharset) {
        HashSet suspects = ContainerUtil.newHashSet((Object[])new Charset[]{CharsetToolkit.getDefaultSystemCharset(), CharsetToolkit.getPlatformCharset()});
        suspects.remove(wrongCharset);
        List goodCharsets = ContainerUtil.filter((Collection)suspects, c -> LossyEncodingInspection.isGoodCharset(virtualFile, c));
        ArrayList<Object> fixes = new ArrayList<Object>();
        if (!goodCharsets.isEmpty()) {
            final Charset goodCharset = (Charset)goodCharsets.get(0);
            fixes.add(new LocalQuickFix(){

                @Nls
                @NotNull
                public String getFamilyName() {
                    return "Reload in '" + goodCharset.displayName() + "'";
                }

                public boolean startInWriteAction() {
                    return false;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                    if (document == null) {
                        return;
                    }
                    ChangeFileEncodingAction.changeTo(project, document, null, virtualFile, goodCharset, EncodingUtil.Magic8.ABSOLUTELY, EncodingUtil.Magic8.ABSOLUTELY);
                }
            });
            fixes.add(new LocalQuickFix(){

                @Nls
                @NotNull
                public String getFamilyName() {
                    return "Set project encoding to '" + goodCharset.displayName() + "'";
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    EncodingProjectManager.getInstance((Project)project).setDefaultCharsetName(goodCharset.name());
                }
            });
        }
        fixes.add((Object)new ReloadInAnotherEncodingFix(file2));
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static boolean isGoodCharset(@NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        boolean equals;
        byte[] bytesToSave;
        byte[] loadedBytes;
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            return true;
        }
        try {
            loadedBytes = virtualFile.contentsToByteArray();
            bytesToSave = new String(loadedBytes, charset).getBytes(charset);
        }
        catch (Exception e) {
            return true;
        }
        if (loadedBytes.length == 0 && bytesToSave.length == 0) {
            return true;
        }
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        if (!(equals = Arrays.equals(bytesToSave, loadedBytes)) && LOG.isDebugEnabled()) {
            try {
                String tempDir = FileUtil.getTempDirectory();
                FileUtil.writeToFile((File)new File(tempDir, "lossy-bytes-to-save"), (byte[])bytesToSave);
                FileUtil.writeToFile((File)new File(tempDir, "lossy-loaded-bytes"), (byte[])loadedBytes);
                LOG.debug("lossy bytes dumped into " + tempDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return equals;
    }

    private static void checkIfCharactersWillBeLostAfterSave(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull CharSequence text, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        TextRange errRange;
        CharBuffer buffer = CharBuffer.wrap(text);
        int textLength = text.length();
        CharBuffer back = CharBuffer.allocate(textLength);
        Ref outRef = Ref.create();
        int pos = 0;
        for (int errorCount = 0; pos < text.length() && errorCount < 200 && (errRange = LossyEncodingInspection.nextUnmappable(buffer, pos, (Ref<ByteBuffer>)outRef, back, charset)) != null; ++errorCount) {
            ProblemDescriptor lastDescriptor = (ProblemDescriptor)ContainerUtil.getLastItem(descriptors);
            if (lastDescriptor != null && lastDescriptor.getTextRangeInElement().getEndOffset() == errRange.getStartOffset()) {
                errRange = lastDescriptor.getTextRangeInElement().union(errRange);
                descriptors.remove(descriptors.size() - 1);
            }
            String message = InspectionsBundle.message((String)"unsupported.character.for.the.charset", (Object[])new Object[]{charset});
            ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)file2, errRange, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{new ChangeEncodingFix(file2)});
            descriptors.add(descriptor);
            pos = errRange.getEndOffset();
        }
    }

    private static TextRange nextUnmappable(@NotNull CharBuffer in, int position, @NotNull Ref<ByteBuffer> outRef, @NotNull CharBuffer back, @NotNull Charset charset) {
        CoderResult cr;
        CharsetEncoder encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        int textLength = in.limit() - position;
        ByteBuffer out = (ByteBuffer)outRef.get();
        if (out == null) {
            out = ByteBuffer.allocate((int)(encoder.averageBytesPerChar() * (float)textLength));
            outRef.set((Object)out);
        }
        out.rewind();
        out.limit(out.capacity());
        in.rewind();
        in.position(position);
        while (true) {
            CoderResult coderResult = cr = in.hasRemaining() ? encoder.encode(in, out, true) : CoderResult.UNDERFLOW;
            if (cr.isUnderflow()) {
                cr = encoder.flush(out);
            }
            if (!cr.isOverflow()) break;
            int n = 3 * out.capacity() / 2 + 1;
            ByteBuffer tmp = ByteBuffer.allocate(n);
            out.flip();
            tmp.put(out);
            out = tmp;
            outRef.set((Object)out);
        }
        if (cr.isError()) {
            return TextRange.from((int)in.position(), (int)cr.length());
        }
        int outLength = out.position();
        CharsetDecoder decoder = charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        out.rewind();
        out.limit(outLength);
        back.rewind();
        CoderResult dr = decoder.decode(out, back, true);
        if (dr.isError()) {
            return TextRange.from((int)back.position(), (int)dr.length());
        }
        if (back.position() != textLength) {
            return TextRange.from((int)Math.min(textLength, back.position()), (int)1);
        }
        in.rewind();
        in.position(position);
        back.rewind();
        int len = StringUtil.commonPrefixLength((CharSequence)in, (CharSequence)back);
        if (len == textLength) {
            return null;
        }
        return TextRange.from((int)len, (int)1);
    }

    private static class ChangeEncodingFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        ChangeEncodingFix(@NotNull PsiFile file2) {
            super((PsiElement)file2);
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @NotNull
        public String getFamilyName() {
            return "Change file encoding";
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            VirtualFile virtualFile;
            DataContext dataContext = ChangeEncodingFix.createDataContext(editor, editor == null ? null : editor.getComponent(), virtualFile = file2.getVirtualFile(), project);
            ListPopup popup2 = new ChangeFileEncodingAction().createPopup(dataContext);
            if (popup2 != null) {
                popup2.showInBestPositionFor(dataContext);
            }
        }

        @NotNull
        static DataContext createDataContext(Editor editor, Component component, VirtualFile selectedFile, Project project) {
            DataContext parent = DataManager.getInstance().getDataContext(component);
            DataContext context = SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor == null ? null : editor.getComponent(), parent);
            DataContext projectContext = SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), project, context);
            return SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE.getName(), selectedFile, projectContext);
        }
    }

    private static class ReloadInAnotherEncodingFix
    extends ChangeEncodingFix {
        ReloadInAnotherEncodingFix(@NotNull PsiFile file2) {
            super(file2);
        }

        @Override
        @NotNull
        public String getText() {
            return "Reload in another encoding";
        }

        @Override
        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (FileDocumentManager.getInstance().isFileModified(file2.getVirtualFile())) {
                return;
            }
            super.invoke(project, file2, editor, startElement, endElement);
        }
    }
}

