/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NonAsciiCharactersInspectionForm;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.io.IOUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAsciiCharactersInspection
extends LocalInspectionTool {
    public boolean CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME = true;
    public boolean CHECK_FOR_NOT_ASCII_STRING_LITERAL;
    public boolean CHECK_FOR_NOT_ASCII_COMMENT;
    public boolean CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME = true;
    public boolean CHECK_FOR_FILES_CONTAINING_BOM;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"non.ascii.characters", (Object[])new Object[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "NonAsciiCharacters";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (!NonAsciiCharactersInspection.isFileWorthIt(session2.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement parent;
                if ((NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME || NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME) && (parent = element.getParent()) instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)parent).getNameIdentifier() == element) {
                    String text = element.getText();
                    if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME) {
                        NonAsciiCharactersInspection.checkAscii(element, text, holder, "an identifier");
                    }
                    if (NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME) {
                        NonAsciiCharactersInspection.checkSameLanguage(element, text, holder);
                    }
                }
                if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_COMMENT && element instanceof PsiComment) {
                    NonAsciiCharactersInspection.checkAsciiRange(element, element.getText(), holder, "a comment");
                }
                if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_STRING_LITERAL && element instanceof PsiLiteralValue) {
                    NonAsciiCharactersInspection.checkAsciiRange(element, element.getText(), holder, "a string literal");
                }
            }

            public void visitFile(PsiFile file2) {
                super.visitFile(file2);
                if (NonAsciiCharactersInspection.this.CHECK_FOR_FILES_CONTAINING_BOM) {
                    byte[] bom;
                    VirtualFile virtualFile = file2.getVirtualFile();
                    byte[] byArray = bom = virtualFile == null ? null : virtualFile.getBOM();
                    if (bom != null) {
                        String hex = IntStream.range(0, bom.length).map(i -> bom[i]).mapToObj(b -> Integer.toString(b & 0xFF, 16).toUpperCase()).collect(Collectors.joining());
                        Charset charsetFromBOM = CharsetToolkit.guessFromBOM((byte[])bom);
                        holder.registerProblem((PsiElement)file2, "File contains BOM: '" + hex + "'" + (charsetFromBOM == null ? "" : " (charset '" + charsetFromBOM.displayName() + "' signature)"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static boolean isFileWorthIt(PsiFile file2) {
        if (InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        CharSequence text = file2.getViewProvider().getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile, text);
        return !(charset instanceof Native2AsciiCharset);
    }

    private static void checkSameLanguage(PsiElement element, String text, ProblemsHolder holder) {
        Set scripts = text.codePoints().mapToObj(Character.UnicodeScript::of).filter(script -> !script.equals((Object)Character.UnicodeScript.COMMON)).collect(Collectors.toSet());
        if (scripts.size() > 1) {
            ArrayList list2 = new ArrayList(scripts);
            Collections.sort(list2);
            holder.registerProblem(element, "Identifier contains symbols from different languages: " + list2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkAscii(PsiElement element, String text, ProblemsHolder holder, String where) {
        if (!IOUtil.isAscii((String)text)) {
            holder.registerProblem(element, "Non-ASCII characters in " + where, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkAsciiRange(PsiElement element, String text, ProblemsHolder holder, String where) {
        int errorCount = 0;
        int start2 = -1;
        for (int i = 0; i <= text.length(); ++i) {
            char c;
            char c2 = c = i >= text.length() ? (char)'\u0000' : text.charAt(i);
            if (i == text.length() || c < '\u0080') {
                if (start2 == -1) continue;
                TextRange range2 = new TextRange(start2, i);
                String message = "Non-ASCII characters in " + where;
                holder.registerProblem(element, range2, message, new LocalQuickFix[0]);
                start2 = -1;
                if (errorCount++ <= 200) continue;
                break;
            }
            if (start2 != -1) continue;
            start2 = i;
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new NonAsciiCharactersInspectionForm((NonAsciiCharactersInspection)this).myPanel;
    }
}

