/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptorUtil {
    public static final int NONE = 0;
    static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_TREE_END = 4;
    public static final Couple<String> XML_CODE_MARKER = Couple.of((Object)"<xml-code>", (Object)"</xml-code>");

    @NotNull
    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement psiElement) {
        TextRange range2 = descriptor instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor).getTextRange() : null;
        return ProblemDescriptorUtil.extractHighlightedText(range2, psiElement);
    }

    @NotNull
    public static String extractHighlightedText(@Nullable TextRange range2, @Nullable PsiElement psiElement) {
        TextRange elementRange;
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (range2 != null && (elementRange = psiElement.getTextRange()) != null && (range2 = range2.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && range2.getEndOffset() <= elementRange.getLength()) {
            ref = range2.substring(ref);
        }
        ref = ref.replace('\n', ' ').trim();
        ref = StringUtil.first((String)ref, (int)100, (boolean)true);
        return ref.trim().replaceAll("\\s+", " ");
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element, boolean appendLineNumber) {
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, appendLineNumber ? 1 : 0);
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element, @FlagConstant int flags) {
        int endIndex;
        int lineNumber;
        String message = descriptor.getDescriptionTemplate();
        if (message == null) {
            return "";
        }
        if ((flags & 1) != 0 && descriptor instanceof ProblemDescriptor && !message.contains("#ref") && message.contains("#loc") && (lineNumber = ((ProblemDescriptor)descriptor).getLineNumber()) >= 0) {
            message = StringUtil.replace((String)message, (String)"#loc", (String)("(" + InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0]) + " " + (lineNumber + 1) + ")"));
        }
        message = ProblemDescriptorUtil.unescapeTags(message);
        message = StringUtil.replace((String)message, (String)"#loc ", (String)"");
        message = StringUtil.replace((String)message, (String)" #loc", (String)"");
        if ((message = StringUtil.replace((String)message, (String)"#loc", (String)"")).contains("#ref")) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor, element);
            message = StringUtil.replace((String)message, (String)"#ref", (String)ref);
        }
        int n = endIndex = (flags & 4) != 0 ? message.indexOf("#treeend") : -1;
        if (endIndex > 0) {
            message = message.substring(0, endIndex);
        }
        message = StringUtil.replace((String)message, (String)"#end", (String)"");
        message = StringUtil.replace((String)message, (String)"#treeend", (String)"");
        return message.trim();
    }

    public static String unescapeTags(String message) {
        message = StringUtil.replace((String)message, (String)"<code>", (String)"'");
        message = (message = StringUtil.replace((String)message, (String)"</code>", (String)"'")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message) : StringUtil.unescapeXmlEntities((String)message);
        return message;
    }

    private static String unescapeXmlCode(String message) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : StringUtil.split((String)message, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.first))) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings.addAll(StringUtil.split((String)string, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.second), (boolean)false));
                continue;
            }
            strings.add(string);
        }
        StringBuilder builder2 = new StringBuilder();
        for (String string : strings) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder2.append(string.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder2.append(StringUtil.unescapeXmlEntities((String)string));
        }
        return builder2.toString();
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, PsiElement element) {
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, false);
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        return ProblemDescriptorUtil.getHighlightInfoType(problemDescriptor.getHighlightType(), severity, severityRegistrar);
    }

    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_DEPRECATED: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            }
            case LIKE_MARKED_FOR_REMOVAL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            }
            case LIKE_UNKNOWN_SYMBOL: {
                if (severity == HighlightSeverity.ERROR) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_UNUSED_SYMBOL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            }
            case INFO: {
                return HighlightInfoType.INFO;
            }
            case WEAK_WARNING: {
                return HighlightInfoType.WEAK_WARNING;
            }
            case WARNING: {
                return HighlightInfoType.WARNING;
            }
            case ERROR: {
                return HighlightInfoType.WRONG_REF;
            }
            case GENERIC_ERROR: {
                return HighlightInfoType.ERROR;
            }
            case INFORMATION: {
                return HighlightInfoType.INFORMATION;
            }
        }
        throw new RuntimeException("Cannot map " + highlightType);
    }

    @NotNull
    public static ProblemDescriptor[] convertToProblemDescriptors(@NotNull List<Annotation> annotations, @NotNull PsiFile file2) {
        if (annotations.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList problems = ContainerUtil.newArrayListWithCapacity((int)annotations.size());
        IdentityHashMap quickFixMappingCache = ContainerUtil.newIdentityHashMap();
        for (Annotation annotation : annotations) {
            PsiElement startElement;
            PsiElement endElement;
            if (annotation.getSeverity() == HighlightSeverity.INFORMATION || annotation.getStartOffset() == annotation.getEndOffset() && !annotation.isAfterEndOfLine()) continue;
            if (annotation.getStartOffset() == annotation.getEndOffset() && annotation.isAfterEndOfLine()) {
                startElement = endElement = file2.findElementAt(annotation.getEndOffset() - 1);
            } else {
                startElement = file2.findElementAt(annotation.getStartOffset());
                endElement = file2.findElementAt(annotation.getEndOffset() - 1);
            }
            if (startElement == null || endElement == null) continue;
            LocalQuickFix[] quickFixes = ProblemDescriptorUtil.toLocalQuickFixes(annotation.getQuickFixes(), quickFixMappingCache);
            ProblemHighlightType highlightType = HighlightInfo.convertSeverityToProblemHighlight(annotation.getSeverity());
            ProblemDescriptorBase descriptor = new ProblemDescriptorBase(startElement, endElement, annotation.getMessage(), quickFixes, highlightType, annotation.isAfterEndOfLine(), null, true, false);
            problems.add(descriptor);
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    private static LocalQuickFix[] toLocalQuickFixes(@Nullable List<Annotation.QuickFixInfo> fixInfos, @NotNull IdentityHashMap<IntentionAction, LocalQuickFix> quickFixMappingCache) {
        if (fixInfos == null || fixInfos.isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] result2 = new LocalQuickFix[fixInfos.size()];
        int i = 0;
        for (Annotation.QuickFixInfo fixInfo : fixInfos) {
            LocalQuickFix fix;
            IntentionAction intentionAction = fixInfo.quickFix;
            if (intentionAction instanceof LocalQuickFix) {
                fix = (LocalQuickFix)intentionAction;
            } else {
                LocalQuickFix lqf = quickFixMappingCache.get(intentionAction);
                if (lqf == null) {
                    lqf = new ExternalAnnotatorInspectionVisitor.LocalQuickFixBackedByIntentionAction(intentionAction);
                    quickFixMappingCache.put(intentionAction, lqf);
                }
                fix = lqf;
            }
            result2[i++] = fix;
        }
        return result2;
    }

    static @interface FlagConstant {
    }
}

