/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtilCore;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressionUtil
extends SuppressionUtilCore {
    @NonNls
    public static final String COMMON_SUPPRESS_REGEXP = "\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*";
    @NonNls
    public static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("//\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*.*");
    @NonNls
    public static final String ALL = "ALL";

    private SuppressionUtil() {
    }

    public static boolean isInspectionToolIdMentioned(@NotNull String inspectionsList, @NotNull String inspectionToolID) {
        Iterable ids = StringUtil.tokenize((String)inspectionsList, (String)"[, ]");
        for (String id : ids) {
            String trim = id.trim();
            if (!trim.equals(inspectionToolID) && !trim.equalsIgnoreCase(ALL)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass) {
        return SuppressionUtil.getStatementToolSuppressedIn(place, toolId, statementClass, SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @Nullable
    public static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass, @NotNull Pattern suppressInLineCommentPattern) {
        String text;
        Matcher matcher;
        PsiElement prev2;
        PsiElement statement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{statementClass});
        if (statement != null && (prev2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement)) instanceof PsiComment && (matcher = suppressInLineCommentPattern.matcher(text = prev2.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned(matcher.group(1), toolId)) {
            return prev2;
        }
        return null;
    }

    public static boolean isSuppressedInStatement(@NotNull PsiElement place, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass) {
        return ReadAction.compute(() -> SuppressionUtil.getStatementToolSuppressedIn(place, toolId, statementClass)) != null;
    }

    @NotNull
    public static PsiComment createComment(@NotNull Project project, @NotNull String commentText, @NotNull Language language) {
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
        return parserFacade.createLineOrBlockCommentFromText(language, commentText);
    }

    @Nullable
    private static Couple<String> getBlockPrefixSuffixPair(@NotNull PsiElement comment) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(comment.getLanguage());
        if (commenter != null) {
            String prefix = commenter.getBlockCommentPrefix();
            String suffix = commenter.getBlockCommentSuffix();
            if (prefix != null || suffix != null) {
                return Couple.of((Object)StringUtil.notNullize((String)prefix), (Object)StringUtil.notNullize((String)suffix));
            }
        }
        return null;
    }

    @Nullable
    public static String getLineCommentPrefix(@NotNull PsiElement comment) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(comment.getLanguage());
        return commenter == null ? null : commenter.getLineCommentPrefix();
    }

    public static boolean isSuppressionComment(@NotNull PsiElement comment) {
        String prefix = SuppressionUtil.getLineCommentPrefix(comment);
        String commentText = comment.getText();
        if (prefix != null) {
            return SuppressionUtil.startsWithSuppressionTag(commentText, prefix);
        }
        Couple<String> prefixSuffixPair = SuppressionUtil.getBlockPrefixSuffixPair(comment);
        return prefixSuffixPair != null && SuppressionUtil.startsWithSuppressionTag(commentText, (String)prefixSuffixPair.first) && commentText.endsWith((String)prefixSuffixPair.second);
    }

    private static boolean startsWithSuppressionTag(String commentText, String prefix) {
        if (!commentText.startsWith(prefix)) {
            return false;
        }
        int index = CharArrayUtil.shiftForward((CharSequence)commentText, (int)prefix.length(), (String)" ");
        return index < commentText.length() && commentText.startsWith("noinspection", index);
    }

    public static void replaceSuppressionComment(@NotNull PsiElement comment, @NotNull String id, boolean replaceOtherSuppressionIds, @NotNull Language commentLanguage) {
        String oldSuppressionCommentText = comment.getText();
        String lineCommentPrefix = SuppressionUtil.getLineCommentPrefix(comment);
        Couple<String> blockPrefixSuffix = null;
        if (lineCommentPrefix == null) {
            blockPrefixSuffix = SuppressionUtil.getBlockPrefixSuffixPair(comment);
        }
        assert (blockPrefixSuffix != null && oldSuppressionCommentText.startsWith((String)blockPrefixSuffix.first) && oldSuppressionCommentText.endsWith((String)blockPrefixSuffix.second) || lineCommentPrefix != null && oldSuppressionCommentText.startsWith(lineCommentPrefix)) : "Unexpected suppression comment " + oldSuppressionCommentText;
        String newText = replaceOtherSuppressionIds ? "noinspection " + id : (lineCommentPrefix == null ? oldSuppressionCommentText.substring(((String)blockPrefixSuffix.first).length(), oldSuppressionCommentText.length() - ((String)blockPrefixSuffix.second).length()) + "," + id : oldSuppressionCommentText.substring(lineCommentPrefix.length()) + "," + id);
        comment.replace((PsiElement)SuppressionUtil.createComment(comment.getProject(), newText, commentLanguage));
    }

    public static void createSuppression(@NotNull Project project, @NotNull PsiElement container, @NotNull String id, @NotNull Language commentLanguage) {
        String text = "noinspection " + id;
        PsiComment comment = SuppressionUtil.createComment(project, text, commentLanguage);
        container.getParent().addBefore((PsiElement)comment, container);
    }

    public static boolean isSuppressed(@NotNull PsiElement psiElement, @NotNull String id) {
        for (InspectionExtensionsFactory factory : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            if (factory.isToCheckMember(psiElement, id)) continue;
            return true;
        }
        return false;
    }

    public static boolean inspectionResultSuppressed(@NotNull PsiElement place, @NotNull LocalInspectionTool tool) {
        return SuppressionUtil.inspectionResultSuppressed(place, (InspectionProfileEntry)tool);
    }

    public static boolean inspectionResultSuppressed(@NotNull PsiElement place, @NotNull InspectionProfileEntry tool) {
        return tool.isSuppressedFor(place);
    }
}

