/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPerformFixesTask
extends PerformFixesModalTask {
    private boolean myApplicableFixFound = false;
    protected final Class myQuickfixClass;

    public AbstractPerformFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @Nullable Class quickfixClass) {
        super(project, descriptors);
        this.myQuickfixClass = quickfixClass;
    }

    protected abstract void collectFix(QuickFix var1, ProblemDescriptor var2, Project var3);

    @Override
    protected final void applyFix(Project project, CommonProblemDescriptor descriptor) {
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > 0) {
            for (QuickFix fix : fixes) {
                if (fix == null || this.myQuickfixClass != null && !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)descriptor;
                PsiElement element = problemDescriptor.getPsiElement();
                if (element == null || !element.isValid()) break;
                this.collectFix(fix, problemDescriptor, project);
                this.myApplicableFixFound = true;
                break;
            }
        }
    }

    public final boolean isApplicableFixFound() {
        return this.myApplicableFixFound;
    }
}

