/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CleanupIntention
implements IntentionAction,
LowPriorityAction {
    protected CleanupIntention() {
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"cleanup.in.scope", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            return;
        }
        InspectionManager managerEx = InspectionManager.getInstance((Project)project);
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)managerEx.createNewGlobalContext();
        AnalysisScope scope = this.getScope(project, InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file2));
        if (scope != null) {
            globalContext.codeCleanup(scope, InspectionProjectProfileManager.getInstance(project).getCurrentProfile(), this.getText(), null, false);
        }
    }

    @Nullable
    protected abstract AnalysisScope getScope(Project var1, PsiFile var2);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

