/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.actions.InspectionElement;
import com.intellij.codeInspection.actions.InspectionListCellRenderer;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GotoInspectionModel
extends SimpleChooseByNameModel {
    private final Map<String, InspectionToolWrapper> myToolNames = new HashMap<String, InspectionToolWrapper>();
    private final String[] myNames;
    private final InspectionListCellRenderer myListCellRenderer = new InspectionListCellRenderer();

    public GotoInspectionModel(@NotNull Project project) {
        super(project, IdeBundle.message((String)"prompt.goto.inspection.enter.name", (Object[])new Object[0]), "goto.inspection.help.id");
        InspectionProfileImpl rootProfile = InspectionProfileManager.getInstance().getCurrentProfile();
        for (ScopeToolState state : rootProfile.getAllTools()) {
            InspectionToolWrapper tool = LocalInspectionToolWrapper.findTool2RunInBatch(project, null, rootProfile, state.getTool());
            if (tool == null) continue;
            this.myToolNames.put(GotoInspectionModel.getSearchString(tool), tool);
        }
        this.myNames = ArrayUtil.toStringArray(this.myToolNames.keySet());
    }

    private static String getSearchString(InspectionToolWrapper tool) {
        return tool.getDisplayName() + " " + StringUtil.join((String[])tool.getGroupPath(), (String)" ") + " " + tool.getShortName();
    }

    public ListCellRenderer getListCellRenderer() {
        return this.myListCellRenderer;
    }

    @Override
    public String[] getNames() {
        return this.myNames;
    }

    @Override
    public Object[] getElementsByName(String name, String pattern) {
        InspectionToolWrapper tool = this.myToolNames.get(name);
        if (tool == null) {
            return InspectionElement.EMPTY_ARRAY;
        }
        return new InspectionElement[]{new InspectionElement(tool, PsiManager.getInstance((Project)this.getProject()))};
    }

    public String getElementName(Object element) {
        if (element instanceof InspectionElement) {
            return GotoInspectionModel.getSearchString(((InspectionElement)((Object)element)).getToolWrapper());
        }
        return null;
    }
}

