/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisActionUtils;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SilentCodeCleanupAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !DumbService.isDumb((Project)project) && this.getInspectionScope(e.getDataContext(), project) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        AnalysisScope analysisScope = this.getInspectionScope(e.getDataContext(), project);
        if (analysisScope == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassist.inspect.batch");
        this.runInspections(project, analysisScope);
    }

    @Nullable
    protected Runnable getPostRunnable() {
        return null;
    }

    protected void runInspections(@NotNull Project project, @NotNull AnalysisScope scope) {
        InspectionProfile profile2 = this.getProfileForSilentCleanup(project);
        if (profile2 == null) {
            return;
        }
        InspectionManager managerEx = InspectionManager.getInstance((Project)project);
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)managerEx.createNewGlobalContext();
        globalContext.codeCleanup(scope, profile2, this.getTemplatePresentation().getText(), this.getPostRunnable(), false);
    }

    @Nullable
    protected InspectionProfile getProfileForSilentCleanup(@NotNull Project project) {
        return InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
    }

    @Nullable
    protected AnalysisScope getInspectionScope(@NotNull DataContext dataContext, @NotNull Project project) {
        return AnalysisActionUtils.getInspectionScope(dataContext, project, false);
    }
}

