/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileLoadUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileProcessor;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InspectionProfileManager", storages={@Storage(value="editor.xml")}, additionalExportFile="inspection")
public class ApplicationInspectionProfileManager
extends BaseInspectionProfileManager
implements InspectionProfileManager,
PersistentStateComponent<Element> {
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledInspectionProfile");
    private final InspectionToolRegistrar myRegistrar;
    private final SchemeManager<InspectionProfileImpl> mySchemeManager;
    private final AtomicBoolean myProfilesAreInitialized = new AtomicBoolean(false);
    private volatile boolean LOAD_PROFILES = !ApplicationManager.getApplication().isUnitTestMode();

    public static ApplicationInspectionProfileManager getInstanceImpl() {
        return (ApplicationInspectionProfileManager)ServiceManager.getService(InspectionProfileManager.class);
    }

    public ApplicationInspectionProfileManager(@NotNull InspectionToolRegistrar registrar, @NotNull SchemeManagerFactory schemeManagerFactory, @NotNull MessageBus messageBus) {
        super(messageBus);
        this.myRegistrar = registrar;
        ApplicationInspectionProfileManager.registerProvidedSeverities();
        this.mySchemeManager = schemeManagerFactory.create("inspection", new InspectionProfileProcessor(){

            @Override
            @NotNull
            public String getSchemeKey(@NotNull Function<String, String> attributeProvider2, @NotNull String fileNameWithoutExtension) {
                return fileNameWithoutExtension;
            }

            @Override
            @NotNull
            public InspectionProfileImpl createScheme(@NotNull SchemeDataHolder<? super InspectionProfileImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider2, boolean isBundled) {
                return new InspectionProfileImpl(name, ApplicationInspectionProfileManager.this.myRegistrar, ApplicationInspectionProfileManager.this, dataHolder);
            }

            @Override
            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme2) {
                ApplicationInspectionProfileManager.this.fireProfileChanged(scheme2);
            }
        });
    }

    @Override
    @NotNull
    protected SchemeManager<InspectionProfileImpl> getSchemeManager() {
        return this.mySchemeManager;
    }

    public static void registerProvidedSeverities() {
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (final HighlightInfoType t : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = t.getSeverity(null);
                SeverityRegistrar.registerStandard(t, highlightSeverity);
                TextAttributesKey attributesKey = t.getAttributesKey();
                IconLoader.LazyIcon icon = t instanceof HighlightInfoType.Iconable ? new IconLoader.LazyIcon(){

                    protected Icon compute() {
                        return ((HighlightInfoType.Iconable)((Object)t)).getIcon();
                    }
                } : null;
                HighlightDisplayLevel.registerSeverity((HighlightSeverity)highlightSeverity, (TextAttributesKey)attributesKey, (Icon)icon);
            }
        }
    }

    @Override
    @NotNull
    public Collection<InspectionProfileImpl> getProfiles() {
        this.initProfiles();
        return Collections.unmodifiableList(this.mySchemeManager.getAllSchemes());
    }

    public void forceInitProfiles(boolean flag) {
        this.LOAD_PROFILES = flag;
        this.myProfilesAreInitialized.set(false);
    }

    public void initProfiles() {
        if (!this.myProfilesAreInitialized.compareAndSet(false, true) || !this.LOAD_PROFILES) {
            return;
        }
        this.loadBundledSchemes();
        this.mySchemeManager.loadSchemes();
        if (this.mySchemeManager.isEmpty()) {
            this.mySchemeManager.addScheme(new InspectionProfileImpl("Default", (Supplier<List<InspectionToolWrapper>>)InspectionToolRegistrar.getInstance(), this));
        }
    }

    private void loadBundledSchemes() {
        if (!ApplicationInspectionProfileManager.isUnitTestOrHeadlessMode()) {
            for (BundledSchemeEP ep : (BundledSchemeEP[])BUNDLED_EP_NAME.getExtensions()) {
                this.mySchemeManager.loadBundledScheme(ep.getPath() + ".xml", (Object)ep);
            }
        }
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public InspectionProfileImpl loadProfile(@NotNull String path) throws IOException, JDOMException {
        Path file2 = Paths.get(path, new String[0]);
        if (Files.isRegularFile(file2, new LinkOption[0])) {
            try {
                return InspectionProfileLoadUtil.load(file2, this.myRegistrar, this);
            }
            catch (IOException | JDOMException e) {
                throw e;
            }
            catch (Exception ignored) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, file2}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0])), ModalityState.NON_MODAL);
            }
        }
        return this.getProfile(path, false);
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.getSeverityRegistrar().writeExternal(state);
        return state;
    }

    public void loadState(@NotNull Element state) {
        this.getSeverityRegistrar().readExternal(state);
    }

    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    @Override
    public void setRootProfile(@Nullable String profileName) {
        this.mySchemeManager.setCurrentSchemeName(profileName);
    }

    @Override
    public InspectionProfileImpl getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        InspectionProfileImpl found = this.mySchemeManager.findSchemeByName(name);
        if (found != null) {
            return found;
        }
        if (returnRootProfileIfNamedIsAbsent) {
            return this.getCurrentProfile();
        }
        return null;
    }

    @Override
    @NotNull
    public InspectionProfileImpl getCurrentProfile() {
        this.initProfiles();
        InspectionProfileImpl current = this.mySchemeManager.getActiveScheme();
        if (current != null) {
            return current;
        }
        InspectionProfileImpl result2 = this.mySchemeManager.findSchemeByName("Default");
        if (result2 == null) {
            InspectionProfileImpl profile2 = new InspectionProfileImpl("Default");
            this.addProfile(profile2);
            return profile2;
        }
        return result2;
    }

    @NotNull
    public String getRootProfileName() {
        return (String)ObjectUtils.chooseNotNull((Object)this.mySchemeManager.getCurrentSchemeName(), (Object)"Default");
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile2) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ProjectInspectionProfileManager.getInstance(project).fireProfileChanged(profile2);
        }
    }
}

