/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ArrayFactory;
import com.intellij.util.TripleFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchModeDescriptorsUtil {
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT = (tool, element, context) -> {
        PsiNamedElement problemElement = BatchModeDescriptorsUtil.getContainerElement(element, tool, context);
        RefElement refElement = context.getRefManager().getReference((PsiElement)problemElement);
        if (refElement == null && problemElement != null) {
            refElement = GlobalInspectionContextUtil.retrieveRefElement(element, context);
        }
        return refElement;
    };

    static void addProblemDescriptors(@NotNull List<? extends ProblemDescriptor> descriptors, boolean filterSuppressed, @NotNull GlobalInspectionContext context, @Nullable LocalInspectionTool tool, @NotNull TripleFunction<? super LocalInspectionTool, ? super PsiElement, ? super GlobalInspectionContext, ? extends RefElement> getProblemElementFunction, @NotNull InspectionToolPresentation dpi) {
        RefElement refElement;
        if (descriptors.isEmpty()) {
            return;
        }
        HashMap<RefElement, List> problems = new HashMap<RefElement, List>();
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        for (ProblemDescriptor problemDescriptor : descriptors) {
            String alternativeId;
            String id;
            PsiElement element = problemDescriptor.getPsiElement();
            if (element == null || filterSuppressed && (refManager.isDeclarationsFound() && (context.isSuppressed(element, id = tool.getID()) || (alternativeId = tool.getAlternativeID()) != null && !alternativeId.equals(id) && context.isSuppressed(element, alternativeId)) || SuppressionUtil.inspectionResultSuppressed(element, tool))) continue;
            refElement = (RefElement)getProblemElementFunction.fun((Object)tool, (Object)element, (Object)context);
            List elementProblems = problems.computeIfAbsent(refElement, __ -> new ArrayList());
            elementProblems.add(problemDescriptor);
        }
        for (Map.Entry entry : problems.entrySet()) {
            List problemDescriptors = (List)entry.getValue();
            refElement = (RefElement)entry.getKey();
            CommonProblemDescriptor[] descriptions = problemDescriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
            dpi.addProblemElement((RefEntity)refElement, filterSuppressed, descriptions);
        }
    }

    public static void addProblemDescriptors(@NotNull List<? extends ProblemDescriptor> descriptors, @NotNull InspectionToolPresentation dpi, boolean filterSuppressed, @NotNull GlobalInspectionContext inspectionContext, @NotNull LocalInspectionTool tool) {
        BatchModeDescriptorsUtil.addProblemDescriptors(descriptors, filterSuppressed, inspectionContext, tool, CONVERT, dpi);
    }

    public static PsiNamedElement getContainerElement(@Nullable PsiElement element, @NotNull LocalInspectionTool tool, @NotNull GlobalInspectionContext context) {
        if (element == null) {
            return null;
        }
        PsiNamedElement containerFromTool = tool.getProblemElement(element);
        if (containerFromTool != null && !(containerFromTool instanceof PsiFile)) {
            return containerFromTool;
        }
        PsiNamedElement container = context.getRefManager().getContainerElement(element);
        return container != null ? container : containerFromTool;
    }

    @NotNull
    public static CommonProblemDescriptor[] flattenDescriptors(@NotNull List<CommonProblemDescriptor[]> descriptors) {
        return (CommonProblemDescriptor[])descriptors.stream().flatMap(ds -> Arrays.stream(ds)).toArray(arg_0 -> ((ArrayFactory)CommonProblemDescriptor.ARRAY_FACTORY).create(arg_0));
    }
}

