/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisableInspectionToolAction
extends IntentionAndQuickFixAction
implements Iconable {
    private final String myToolId;
    public static final String NAME = InspectionsBundle.message((String)"disable.inspection.action.name", (Object[])new Object[0]);

    public DisableInspectionToolAction(LocalInspectionTool tool) {
        this.myToolId = tool.getShortName();
    }

    public DisableInspectionToolAction(HighlightDisplayKey key) {
        this.myToolId = key.toString();
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public String getFamilyName() {
        return NAME;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project);
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        InspectionToolWrapper toolWrapper = inspectionProfile.getInspectionTool(this.myToolId, project);
        return toolWrapper == null || toolWrapper.getDefaultLevel() != HighlightDisplayLevel.NON_SWITCHABLE_ERROR;
    }

    public void applyFix(@NotNull Project project, PsiFile file2, @Nullable Editor editor) {
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(project, (Consumer<InspectionProfileModifiableModel>)((Consumer)it -> it.disableTool(this.myToolId, (PsiElement)file2)));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }
}

