/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.StdJobDescriptors;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextBase
extends UserDataHolderBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.GlobalInspectionContextImpl");
    private static final TObjectHashingStrategy<Tools> TOOLS_HASHING_STRATEGY = new TObjectHashingStrategy<Tools>(){

        public int computeHashCode(Tools object) {
            return object.getShortName().hashCode();
        }

        public boolean equals(Tools o1, Tools o2) {
            return o1.getShortName().equals(o2.getShortName());
        }
    };
    private RefManager myRefManager;
    private AnalysisScope myCurrentScope;
    @NotNull
    private final Project myProject;
    private final List<JobDescriptor> myJobDescriptors = new ArrayList<JobDescriptor>();
    private final StdJobDescriptors myStdJobDescriptors = new StdJobDescriptors();
    protected ProgressIndicator myProgressIndicator = new EmptyProgressIndicator();
    private InspectionProfileImpl myExternalProfile;
    protected final Map<Key, GlobalInspectionContextExtension> myExtensions = new HashMap<Key, GlobalInspectionContextExtension>();
    final Map<String, Tools> myTools = new THashMap();
    @NonNls
    public static final String PROBLEMS_TAG_NAME = "problems";
    @NonNls
    public static final String LOCAL_TOOL_ATTRIBUTE = "is_local_tool";

    public GlobalInspectionContextBase(@NotNull Project project) {
        this.myProject = project;
        for (InspectionExtensionsFactory factory : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            GlobalInspectionContextExtension extension = factory.createGlobalInspectionContextExtension();
            this.myExtensions.put(extension.getID(), extension);
        }
    }

    public AnalysisScope getCurrentScope() {
        return this.myCurrentScope;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        return (T)this.myExtensions.get(key);
    }

    public InspectionProfileImpl getCurrentProfile() {
        if (this.myExternalProfile != null) {
            return this.myExternalProfile;
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)this.myProject)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance(this.myProject);
        InspectionProfileImpl profile2 = profileManager.getProfile(currentProfile, false);
        if (profile2 == null) {
            profile2 = InspectionProfileManager.getInstance().getProfile(currentProfile);
            if (profile2 != null) {
                return profile2;
            }
            String[] availableProfileNames = profileManager.getAvailableProfileNames();
            if (availableProfileNames.length == 0) {
                throw new IllegalStateException("There should be at least one inspection profile");
            }
            profile2 = profileManager.getProfile(availableProfileNames[0], true);
        }
        return profile2;
    }

    public boolean shouldCheck(@NotNull RefEntity entity, @NotNull GlobalInspectionTool tool) {
        return !(entity instanceof RefElementImpl) || this.isToCheckMember((RefElementImpl)entity, (InspectionProfileEntry)tool);
    }

    public boolean isSuppressed(@NotNull PsiElement element, @NotNull String id) {
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        if (refManager.isDeclarationsFound()) {
            RefElement refElement = refManager.getReference(element);
            return refElement instanceof RefElementImpl && ((RefElementImpl)refElement).isSuppressed(id);
        }
        return SuppressionUtil.isSuppressed(element, id);
    }

    void cleanupTools() {
        this.myProgressIndicator.cancel();
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                toolWrapper.cleanup(this.myProject);
            }
        }
        this.myTools.clear();
        EntryPointsManager entryPointsManager = EntryPointsManager.getInstance((Project)this.getProject());
        if (entryPointsManager != null) {
            entryPointsManager.cleanup();
        }
        if (this.myRefManager != null) {
            ((RefManagerImpl)this.myRefManager).cleanup();
            this.myRefManager = null;
            if (this.myCurrentScope != null) {
                this.myCurrentScope.invalidate();
                this.myCurrentScope = null;
            }
        }
        this.myJobDescriptors.clear();
    }

    public void setCurrentScope(@NotNull AnalysisScope currentScope) {
        this.myCurrentScope = currentScope;
    }

    public void doInspections(@NotNull AnalysisScope scope) {
        if (!GlobalInspectionContextUtil.canRunInspections(this.myProject, true)) {
            return;
        }
        this.cleanup();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myCurrentScope = scope;
            this.launchInspections(scope);
        }, this.myProject.getDisposed());
    }

    @NotNull
    public RefManager getRefManager() {
        if (this.myRefManager == null) {
            this.myRefManager = (RefManager)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> new RefManagerImpl(this.myProject, this.myCurrentScope, this));
        }
        return this.myRefManager;
    }

    public boolean isToCheckMember(@NotNull RefElement owner, @NotNull InspectionProfileEntry tool) {
        return this.isToCheckFile(((RefElementImpl)owner).getContainingFile(), tool) && !((RefElementImpl)owner).isSuppressed(tool.getShortName(), tool.getAlternativeID());
    }

    public boolean isToCheckFile(PsiFile file2, @NotNull InspectionProfileEntry tool) {
        Tools tools = this.myTools.get(tool.getShortName());
        if (tools != null && file2 != null) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope namedScope = state.getScope(file2.getProject());
                if (namedScope != null && !namedScope.getValue().contains(file2, this.getCurrentProfile().getProfileManager().getScopesManager())) continue;
                return state.isEnabled() && state.getTool().getTool() == tool;
            }
        }
        return false;
    }

    protected void launchInspections(final @NotNull AnalysisScope scope) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        LOG.info("Code inspection started");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getProject(), InspectionsBundle.message((String)"inspection.progress.title", (Object[])new Object[0]), true, this.createOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                GlobalInspectionContextBase.this.performInspectionsWithProgress(scope, false, false);
            }

            public void onSuccess() {
                GlobalInspectionContextBase.this.notifyInspectionsFinished(scope);
            }

            public void onCancel() {
                GlobalInspectionContextBase.this.cleanup();
            }
        });
    }

    @NotNull
    protected PerformInBackgroundOption createOption() {
        return () -> true;
    }

    protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInspectionsWithProgress(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (this.myProgressIndicator == null) {
            throw new IllegalStateException("Inspections must be run under progress");
        }
        this.myProgressIndicator.setIndeterminate(false);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        try {
            psiManager.startBatchFilesProcessingMode();
            refManager.inspectionReadActionStarted();
            this.getStdJobDescriptors().BUILD_GRAPH.setTotalAmount(scope.getFileCount());
            this.getStdJobDescriptors().LOCAL_ANALYSIS.setTotalAmount(scope.getFileCount());
            this.getStdJobDescriptors().FIND_EXTERNAL_USAGES.setTotalAmount(0);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> this.runTools(scope, runGlobalToolsOnly, isOfflineInspections), (ProgressIndicator)ProgressWrapper.wrap(this.myProgressIndicator));
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            refManager.inspectionReadActionFinished();
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
    }

    public void initializeTools(@NotNull List<? super Tools> outGlobalTools, @NotNull List<? super Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools) {
        List<Tools> usedTools = this.getUsedTools();
        for (Tools currentTools : usedTools) {
            JobDescriptor[] jobDescriptors;
            String shortName = currentTools.getShortName();
            this.myTools.put(shortName, currentTools);
            InspectionToolWrapper toolWrapper = currentTools.getTool();
            GlobalInspectionContextBase.classifyTool(outGlobalTools, outLocalTools, outGlobalSimpleTools, currentTools, toolWrapper);
            for (ScopeToolState state : currentTools.getTools()) {
                state.getTool().initialize((GlobalInspectionContext)this);
            }
            for (JobDescriptor jobDescriptor : jobDescriptors = toolWrapper.getJobDescriptors((GlobalInspectionContext)this)) {
                this.appendJobDescriptor(jobDescriptor);
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            try {
                extension.performPreRunActivities(outGlobalTools, outLocalTools, (GlobalInspectionContext)this);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    @NotNull
    public List<Tools> getUsedTools() {
        InspectionProfileImpl profile2 = this.getCurrentProfile();
        List<Tools> tools = profile2.getAllEnabledInspectionTools(this.myProject);
        LinkedHashSet dependentTools = new LinkedHashSet();
        for (Tools tool : tools) {
            profile2.collectDependentInspections(tool.getTool(), dependentTools, this.getProject());
        }
        if (dependentTools.isEmpty()) {
            return tools;
        }
        THashSet set2 = new THashSet(tools, TOOLS_HASHING_STRATEGY);
        set2.addAll(ContainerUtil.map(dependentTools, toolWrapper -> new ToolsImpl((InspectionToolWrapper)toolWrapper, toolWrapper.getDefaultLevel(), true, true)));
        return new ArrayList<Tools>((Collection<Tools>)set2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void classifyTool(@NotNull List<? super Tools> outGlobalTools, @NotNull List<? super Tools> outLocalTools, @NotNull List<? super Tools> outGlobalSimpleTools, @NotNull Tools currentTools, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            outLocalTools.add((Tools)currentTools);
            return;
        } else {
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) throw new RuntimeException("unknown tool " + toolWrapper);
            if (toolWrapper.getTool() instanceof GlobalSimpleInspectionTool) {
                outGlobalSimpleTools.add((Tools)currentTools);
                return;
            } else {
                if (!(toolWrapper.getTool() instanceof GlobalInspectionTool)) throw new RuntimeException("unknown global tool " + toolWrapper);
                outGlobalTools.add((Tools)currentTools);
            }
        }
    }

    @NotNull
    public Map<String, Tools> getTools() {
        return this.myTools;
    }

    private void appendJobDescriptor(@NotNull JobDescriptor job2) {
        if (!this.myJobDescriptors.contains(job2)) {
            this.myJobDescriptors.add(job2);
            job2.setDoneAmount(0);
        }
    }

    public void codeCleanup(@NotNull AnalysisScope scope, @NotNull InspectionProfile profile2, @Nullable String commandName, @Nullable Runnable postRunnable, boolean modal, @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
    }

    public void codeCleanup(@NotNull AnalysisScope scope, @NotNull InspectionProfile profile2, @Nullable String commandName, @Nullable Runnable postRunnable, boolean modal) {
        this.codeCleanup(scope, profile2, commandName, postRunnable, modal, d -> true);
    }

    public static void modalCodeCleanup(@NotNull Project project, @NotNull AnalysisScope scope, @Nullable Runnable runnable2) {
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance((Project)project).createNewGlobalContext();
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        globalContext.codeCleanup(scope, profile2, null, runnable2, true, descriptor -> true);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, PsiElement ... scope) {
        GlobalInspectionContextBase.cleanupElements(project, runnable2, (? super ProblemDescriptor descriptor) -> true, scope);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, Predicate<? super ProblemDescriptor> shouldApplyFix, PsiElement ... scope) {
        ArrayList<SmartPsiElementPointer> elements = new ArrayList<SmartPsiElementPointer>();
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
        for (PsiElement element : scope) {
            elements.add(manager.createSmartPsiElementPointer(element));
        }
        GlobalInspectionContextBase.cleanupElements(project, runnable2, elements, shouldApplyFix);
    }

    public static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, List<? extends SmartPsiElementPointer<PsiElement>> elements) {
        GlobalInspectionContextBase.cleanupElements(project, runnable2, elements, (? super ProblemDescriptor descriptor) -> true);
    }

    private static void cleanupElements(@NotNull Project project, @Nullable Runnable runnable2, List<? extends SmartPsiElementPointer<PsiElement>> elements, @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        Runnable cleanupRunnable = () -> {
            ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
            for (SmartPsiElementPointer element : elements) {
                PsiElement psiElement = element.getElement();
                if (psiElement == null || !psiElement.isPhysical()) continue;
                psiElements.add(psiElement);
            }
            if (psiElements.isEmpty()) {
                return;
            }
            GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance((Project)project).createNewGlobalContext();
            InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
            AnalysisScope analysisScope = new AnalysisScope((SearchScope)new LocalSearchScope(psiElements.toArray(PsiElement.EMPTY_ARRAY)), project);
            globalContext.codeCleanup(analysisScope, profile2, null, runnable2, true, shouldApplyFix);
        };
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !application.isUnitTestMode()) {
            application.invokeLater(cleanupRunnable);
        } else {
            cleanupRunnable.run();
        }
    }

    public void close(boolean noSuspiciousCodeFound) {
        this.cleanup();
    }

    public void cleanup() {
        this.cleanupTools();
    }

    public void incrementJobDoneAmount(@NotNull JobDescriptor job2, @NotNull String message) {
        if (this.myProgressIndicator == null) {
            return;
        }
        ProgressManager.checkCanceled();
        int old = job2.getDoneAmount();
        job2.setDoneAmount(old + 1);
        float totalProgress = this.getTotalProgress();
        this.myProgressIndicator.setFraction((double)totalProgress);
        this.myProgressIndicator.setText(job2.getDisplayName() + " " + message);
    }

    private float getTotalProgress() {
        int totalDone = 0;
        int totalTotal = 0;
        for (JobDescriptor jobDescriptor : this.myJobDescriptors) {
            totalDone += jobDescriptor.getDoneAmount();
            totalTotal += jobDescriptor.getTotalAmount();
        }
        return totalTotal == 0 ? 1.0f : 1.0f * (float)totalDone / (float)totalTotal;
    }

    public void setExternalProfile(InspectionProfileImpl profile2) {
        this.myExternalProfile = profile2;
    }

    @NotNull
    public StdJobDescriptors getStdJobDescriptors() {
        return this.myStdJobDescriptors;
    }
}

