/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public class GlobalInspectionContextUtil {
    public static RefElement retrieveRefElement(@NotNull PsiElement element, @NotNull GlobalInspectionContext globalContext) {
        PsiLanguageInjectionHost context;
        PsiFile elementFile = element.getContainingFile();
        RefElement refElement = globalContext.getRefManager().getReference((PsiElement)elementFile);
        if (refElement == null && (context = InjectedLanguageManager.getInstance((Project)elementFile.getProject()).getInjectionHost((PsiElement)elementFile)) != null) {
            refElement = globalContext.getRefManager().getReference((PsiElement)context.getContainingFile());
        }
        return refElement;
    }

    public static boolean canRunInspections(@NotNull Project project, boolean online) {
        for (InspectionExtensionsFactory factory : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            if (factory.isProjectConfiguredToRunInspections(project, online)) continue;
            return false;
        }
        return true;
    }
}

