/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionManagerEx
extends InspectionManagerBase {
    private final NotNullLazyValue<ContentManager> myContentManager;
    private final Set<GlobalInspectionContextImpl> myRunningContexts = new HashSet<GlobalInspectionContextImpl>();

    public InspectionManagerEx(final Project project) {
        super(project);
        this.myContentManager = ApplicationManager.getApplication().isHeadlessEnvironment() ? new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
                return ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)new TabbedPaneContentUI(), true, project);
            }
        } : new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
                final ContentManager contentManager = toolWindow.getContentManager();
                toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowInspection);
                new ContentManagerWatcher(toolWindow, contentManager);
                contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){
                    private static final String PREFIX = "of ";

                    public void contentAdded(@NotNull ContentManagerEvent event) {
                        this.handleContentSizeChanged();
                    }

                    public void contentRemoved(@NotNull ContentManagerEvent event) {
                        this.handleContentSizeChanged();
                    }

                    private void handleContentSizeChanged() {
                        int count = contentManager.getContentCount();
                        if (count == 1) {
                            Content content = contentManager.getContent(0);
                            String displayName = content.getDisplayName();
                            if (!content.getDisplayName().startsWith(PREFIX)) {
                                content.setDisplayName(PREFIX + displayName);
                            }
                        } else if (count > 1) {
                            for (Content content : contentManager.getContents()) {
                                if (!content.getDisplayName().startsWith(PREFIX)) continue;
                                content.setDisplayName(content.getDisplayName().substring(PREFIX.length()));
                            }
                        }
                    }
                });
                return contentManager;
            }
        };
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable HintAction hintAction, boolean onTheFly, LocalQuickFix ... fixes) {
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, onTheFly);
    }

    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext(boolean reuse) {
        return this.createNewGlobalContext();
    }

    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext() {
        GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
        this.myRunningContexts.add(inspectionContext);
        return inspectionContext;
    }

    public void setProfile(@NotNull String name) {
        this.myCurrentProfileName = name;
    }

    void closeRunningContext(@NotNull GlobalInspectionContextImpl globalInspectionContext) {
        this.myRunningContexts.remove((Object)globalInspectionContext);
    }

    @NotNull
    public Set<GlobalInspectionContextImpl> getRunningContexts() {
        return this.myRunningContexts;
    }

    @NotNull
    public NotNullLazyValue<ContentManager> getContentManager() {
        return this.myContentManager;
    }
}

