/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionElementsMergerBase;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.NewInspectionProfile;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileImpl
extends NewInspectionProfile {
    @NonNls
    static final String INSPECTION_TOOL_TAG = "inspection_tool";
    @NonNls
    static final String CLASS_TAG = "class";
    protected static final Logger LOG = Logger.getInstance(InspectionProfileImpl.class);
    @NonNls
    private static final String VALID_VERSION = "1.0";
    @NonNls
    private static final String VERSION_TAG = "version";
    @NonNls
    private static final String USED_LEVELS = "used_levels";
    public static boolean INIT_INSPECTIONS;
    @NotNull
    protected final Supplier<List<InspectionToolWrapper>> myToolSupplier;
    protected final Map<String, Element> myUninitializedSettings = new TreeMap<String, Element>();
    protected Map<String, ToolsImpl> myTools = new THashMap();
    protected volatile Set<String> myChangedToolNames;
    @Attribute(value="is_locked")
    protected boolean myLockedProfile;
    protected final InspectionProfileImpl myBaseProfile;
    private volatile String myToolShortName;
    private String[] myScopesOrder;
    private String myDescription;
    private SchemeDataHolder<? super InspectionProfileImpl> myDataHolder;

    public InspectionProfileImpl(@NotNull String profileName, @NotNull Supplier<List<InspectionToolWrapper>> toolSupplier, @NotNull BaseInspectionProfileManager profileManager) {
        this(profileName, toolSupplier, profileManager, InspectionProfileKt.getBASE_PROFILE(), null);
    }

    public InspectionProfileImpl(@NotNull String profileName) {
        this(profileName, InspectionToolRegistrar.getInstance(), (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), null, null);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull Supplier<List<InspectionToolWrapper>> toolSupplier, @Nullable InspectionProfileImpl baseProfile) {
        this(profileName, toolSupplier, (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), baseProfile, null);
    }

    protected InspectionProfileImpl(@NotNull String profileName, @NotNull Supplier<List<InspectionToolWrapper>> toolSupplier, @NotNull BaseInspectionProfileManager profileManager, @Nullable InspectionProfileImpl baseProfile, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        super(profileName, profileManager);
        this.myToolSupplier = toolSupplier;
        this.myBaseProfile = baseProfile;
        this.myDataHolder = dataHolder;
        if (dataHolder != null) {
            this.schemeState = SchemeState.UNCHANGED;
        }
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull Supplier<List<InspectionToolWrapper>> toolSupplier, @NotNull BaseInspectionProfileManager profileManager, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        this(profileName, toolSupplier, profileManager, InspectionProfileKt.getBASE_PROFILE(), dataHolder);
    }

    private static boolean toolSettingsAreEqual(@NotNull String toolName, @NotNull InspectionProfileImpl profile1, @NotNull InspectionProfileImpl profile2) {
        Tools toolList1 = profile1.myTools.get(toolName);
        Tools toolList2 = profile2.myTools.get(toolName);
        return Comparing.equal((Object)toolList1, (Object)toolList2);
    }

    @NotNull
    protected static InspectionToolWrapper copyToolSettings(@NotNull InspectionToolWrapper toolWrapper) {
        InspectionToolWrapper inspectionTool = toolWrapper.createCopy();
        if (toolWrapper.isInitialized()) {
            Element config2 = new Element("config");
            ScopeToolState.tryWriteSettings((InspectionProfileEntry)toolWrapper.getTool(), (Element)config2);
            ScopeToolState.tryReadSettings((InspectionProfileEntry)inspectionTool.getTool(), (Element)config2);
        }
        return inspectionTool;
    }

    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        HighlightDisplayLevel level;
        Project project = element == null ? null : element.getProject();
        ToolsImpl tools = this.getToolsOrNull(inspectionToolKey.toString(), project);
        HighlightDisplayLevel highlightDisplayLevel = level = tools != null ? tools.getLevel(element) : HighlightDisplayLevel.WARNING;
        if (!this.getProfileManager().getSeverityRegistrar().isSeverityValid(level.getSeverity().getName())) {
            level = HighlightDisplayLevel.WARNING;
            this.setErrorLevel(inspectionToolKey, level, project);
        }
        return level;
    }

    @Override
    public void readExternal(@NotNull Element element) {
        String version2;
        this.mySerializer.readExternal((Object)this, element);
        Element highlightElement = element.getChild(USED_LEVELS);
        if (highlightElement != null) {
            this.getProfileManager().getSeverityRegistrar().readExternal(highlightElement);
        }
        if (!VALID_VERSION.equals(version2 = element.getAttributeValue(VERSION_TAG))) {
            InspectionToolWrapper[] tools = this.getInspectionTools(null);
            for (Element toolElement : element.getChildren(INSPECTION_TOOL_TAG)) {
                String toolClassName = toolElement.getAttributeValue(CLASS_TAG);
                String shortName = InspectionProfileImpl.convertToShortName(toolClassName, tools);
                if (shortName == null) continue;
                toolElement.setAttribute(CLASS_TAG, shortName);
                this.myUninitializedSettings.put(shortName, JDOMUtil.internElement((Element)toolElement));
            }
        } else {
            List children2 = element.getChildren(INSPECTION_TOOL_TAG);
            for (Element toolElement : children2) {
                this.myUninitializedSettings.put(toolElement.getAttributeValue(CLASS_TAG), JDOMUtil.internElement((Element)toolElement));
            }
        }
    }

    @Nullable
    private static String convertToShortName(@Nullable String displayName, InspectionToolWrapper[] tools) {
        if (displayName == null) {
            return null;
        }
        for (InspectionToolWrapper tool : tools) {
            if (!displayName.equals(tool.getDisplayName())) continue;
            return tool.getShortName();
        }
        return null;
    }

    @NotNull
    public Set<HighlightSeverity> getUsedSeverities() {
        LOG.assertTrue(this.wasInitialized());
        THashSet result2 = new THashSet();
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                result2.add(state.getLevel().getSeverity());
            }
        }
        return result2;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        if (this.myDataHolder != null) {
            return this.myDataHolder.read();
        }
        Element element = new Element("profile");
        this.writeExternal(element);
        if (this.isProjectLevel()) {
            element.setAttribute(VERSION_TAG, VALID_VERSION);
        }
        if (this.isProjectLevel() && ProjectKt.isDirectoryBased(((ProjectInspectionProfileManager)this.getProfileManager()).getProject())) {
            return new Element("component").setAttribute("name", "InspectionProjectProfileManager").addContent(element);
        }
        this.schemeState = SchemeState.UNCHANGED;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element) {
        InspectionProfileImpl.writeVersion(element);
        this.mySerializer.writeExternal((Object)this, element);
        Object object = this.myLock;
        synchronized (object) {
            if (!this.wasInitialized()) {
                for (Element el : this.myUninitializedSettings.values()) {
                    element.addContent(el.clone());
                }
                return;
            }
        }
        Set<String> changedToolNames = this.getChangedToolNames();
        if (changedToolNames == null) {
            return;
        }
        ArrayList<String> allToolNames = new ArrayList<String>(this.myTools.keySet());
        allToolNames.addAll(this.myUninitializedSettings.keySet());
        allToolNames.sort(null);
        for (String toolName : allToolNames) {
            Element toolElement = this.myUninitializedSettings.get(toolName);
            if (toolElement != null) {
                element.addContent(toolElement.clone());
                continue;
            }
            if (!this.myLockedProfile && !changedToolNames.contains(toolName)) {
                this.markSettingsMerged(toolName, element);
                continue;
            }
            ToolsImpl toolList = this.myTools.get(toolName);
            LOG.assertTrue(toolList != null);
            Element inspectionElement = new Element(INSPECTION_TOOL_TAG);
            inspectionElement.setAttribute(CLASS_TAG, toolName);
            try {
                toolList.writeExternal(inspectionElement);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (this.areSettingsMerged(toolName, inspectionElement)) continue;
            element.addContent(inspectionElement);
        }
        this.getPathMacroManager().collapsePaths(element);
    }

    protected static void writeVersion(@NotNull Element element) {
        element.setAttribute(VERSION_TAG, VALID_VERSION);
    }

    private void markSettingsMerged(@NotNull String toolName, @NotNull Element element) {
        InspectionElementsMergerBase merger;
        String mergedName = InspectionElementsMergerBase.getMergedMarkerName(toolName);
        if (!this.myUninitializedSettings.containsKey(mergedName) && (merger = InspectionProfileImpl.getMerger(toolName)) != null && merger.markSettingsMerged(this.myUninitializedSettings)) {
            element.addContent(new Element(INSPECTION_TOOL_TAG).setAttribute(CLASS_TAG, mergedName));
        }
    }

    private boolean areSettingsMerged(@NotNull String toolName, @NotNull Element inspectionElement) {
        InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(toolName);
        return merger != null && merger.areSettingsMerged(this.myUninitializedSettings, inspectionElement);
    }

    public void collectDependentInspections(@NotNull InspectionToolWrapper toolWrapper, @NotNull Set<? super InspectionToolWrapper<?, ?>> dependentEntries, Project project) {
        String mainToolId = toolWrapper.getMainToolId();
        if (mainToolId != null) {
            InspectionToolWrapper dependentEntryWrapper = this.getInspectionTool(mainToolId, project);
            if (dependentEntryWrapper == null) {
                LOG.error("Can't find main tool: '" + mainToolId + "' which was specified in " + toolWrapper);
                return;
            }
            if (!dependentEntries.add(dependentEntryWrapper)) {
                this.collectDependentInspections(dependentEntryWrapper, dependentEntries, project);
            }
        }
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, @Nullable PsiElement element) {
        ToolsImpl toolList = this.getToolsOrNull(shortName, element == null ? null : element.getProject());
        return toolList == null ? null : toolList.getInspectionTool(element);
    }

    @Nullable
    public InspectionProfileEntry getUnwrappedTool(@NotNull String shortName, @NotNull PsiElement element) {
        InspectionToolWrapper tool = this.getInspectionTool(shortName, element);
        return tool == null ? null : tool.getTool();
    }

    public <T extends InspectionProfileEntry> T getUnwrappedTool(@NotNull Key<T> shortNameKey, @NotNull PsiElement element) {
        return (T)this.getUnwrappedTool(shortNameKey.toString(), element);
    }

    public void modifyProfile(@NotNull Consumer<? super InspectionProfileModifiableModel> modelConsumer) {
        InspectionProfileModifiableModelKt.edit(this, (Function1<? super InspectionProfileModifiableModel, Unit>)((Function1)it -> {
            modelConsumer.consume(it);
            return null;
        }));
    }

    public <T extends InspectionProfileEntry> void modifyToolSettings(@NotNull Key<T> shortNameKey, @NotNull PsiElement psiElement, @NotNull Consumer<T> toolConsumer) {
        this.modifyProfile((Consumer<? super InspectionProfileModifiableModel>)((Consumer)model -> {
            InspectionProfileEntry tool = model.getUnwrappedTool(shortNameKey.toString(), psiElement);
            toolConsumer.consume((Object)tool);
        }));
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, Project project) {
        ToolsImpl tools = this.getToolsOrNull(shortName, project);
        return tools == null ? null : tools.getTool();
    }

    public InspectionToolWrapper getToolById(@NotNull String id, @NotNull PsiElement element) {
        this.initInspectionTools(element.getProject());
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element);
            if (!id.equals(tool.getID())) continue;
            return tool;
        }
        return null;
    }

    @NotNull
    public List<InspectionToolWrapper> findToolsById(@NotNull String id, @NotNull PsiElement element) {
        this.initInspectionTools(element.getProject());
        ArrayList<InspectionToolWrapper> result2 = null;
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element);
            if (!id.equals(tool.getID())) continue;
            if (result2 == null) {
                result2 = new ArrayList<InspectionToolWrapper>();
            }
            result2.add(tool);
        }
        return ContainerUtil.notNullize(result2);
    }

    @Nullable
    public String getSingleTool() {
        return this.myToolShortName;
    }

    public void setSingleTool(@NotNull String toolShortName) {
        this.myToolShortName = toolShortName;
    }

    @NotNull
    public String getDisplayName() {
        return this.getName();
    }

    public void scopesChanged() {
        if (!this.wasInitialized()) {
            return;
        }
        for (ToolsImpl tools : this.myTools.values()) {
            tools.scopesChanged();
        }
        this.getProfileManager().fireProfileChanged(this);
    }

    @Transient
    public boolean isProfileLocked() {
        return this.myLockedProfile;
    }

    public void lockProfile(boolean isLocked) {
        this.myLockedProfile = isLocked;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    public InspectionToolWrapper[] getInspectionTools(@Nullable PsiElement element) {
        this.initInspectionTools(element == null ? null : element.getProject());
        ArrayList<InspectionToolWrapper> result2 = new ArrayList<InspectionToolWrapper>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getInspectionTool(element));
        }
        return result2.toArray(InspectionToolWrapper.EMPTY_ARRAY);
    }

    @NotNull
    public List<Tools> getAllEnabledInspectionTools(Project project) {
        this.initInspectionTools(project);
        ArrayList<Tools> result2 = new ArrayList<Tools>();
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            result2.add(toolList);
        }
        return result2;
    }

    public void disableToolByDefault(@NotNull Collection<String> toolShortNames, @Nullable Project project) {
        for (String toolId : toolShortNames) {
            this.getTools(toolId, project).setDefaultEnabled(false);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    public ScopeToolState getToolDefaultState(@NotNull String toolShortName, @Nullable Project project) {
        return this.getTools(toolShortName, project).getDefaultState();
    }

    public void enableToolsByDefault(@NotNull List<String> toolShortNames, Project project) {
        for (String shortName : toolShortNames) {
            this.getTools(shortName, project).setDefaultEnabled(true);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    protected List<InspectionToolWrapper> createTools(@Nullable Project project) {
        return this.myToolSupplier.get();
    }

    @Override
    protected void initialize(@Nullable Project project) {
        List<InspectionToolWrapper> tools;
        SchemeDataHolder<? super InspectionProfileImpl> dataHolder = this.myDataHolder;
        if (dataHolder != null) {
            this.myDataHolder = null;
            Element element = dataHolder.read();
            if (element.getName().equals("component")) {
                element = element.getChild("profile");
            }
            assert (element != null);
            this.readExternal(element);
        }
        if (this.myBaseProfile != null) {
            this.myBaseProfile.initInspectionTools(project);
        }
        try {
            tools = this.createTools(project);
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        THashMap dependencies = new THashMap();
        for (InspectionToolWrapper toolWrapper : tools) {
            this.addTool(project, toolWrapper, (Map<String, List<String>>)dependencies);
        }
        DFSTBuilder builder2 = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)new InboundSemiGraph<String>((Map)dependencies){
            final /* synthetic */ Map val$dependencies;
            {
                this.val$dependencies = map2;
            }

            @NotNull
            public Collection<String> getNodes() {
                return this.val$dependencies.keySet();
            }

            @NotNull
            public Iterator<String> getIn(String n) {
                return ((List)this.val$dependencies.get(n)).iterator();
            }
        }));
        if (builder2.isAcyclic()) {
            this.myScopesOrder = ArrayUtil.toStringArray((Collection)builder2.getSortedNodes());
        }
        this.copyToolsConfigurations(project);
        this.initialized = true;
        if (dataHolder != null) {
            dataHolder.updateDigest(this);
        }
    }

    protected void copyToolsConfigurations(@Nullable Project project) {
    }

    public void addTool(@Nullable Project project, @NotNull InspectionToolWrapper toolWrapper, @NotNull Map<String, List<String>> dependencies) {
        String shortName = toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            InspectionEP extension = toolWrapper.getExtension();
            Computable.PredefinedValueComputable computable = extension == null ? new Computable.PredefinedValueComputable((Object)toolWrapper.getDisplayName()) : () -> ((InspectionEP)extension).getDisplayName();
            key = toolWrapper instanceof LocalInspectionToolWrapper ? HighlightDisplayKey.register((String)shortName, (Computable)computable, (String)toolWrapper.getID(), (String)((LocalInspectionToolWrapper)toolWrapper).getAlternativeID()) : HighlightDisplayKey.register((String)shortName, (Computable)computable);
        }
        if (key == null) {
            LOG.error(shortName + " ; number of initialized tools: " + this.myTools.size());
            return;
        }
        HighlightDisplayLevel baseLevel = this.myBaseProfile != null && this.myBaseProfile.getToolsOrNull(shortName, project) != null ? this.myBaseProfile.getErrorLevel(key, project) : HighlightDisplayLevel.DO_NOT_SHOW;
        HighlightDisplayLevel defaultLevel = toolWrapper.getDefaultLevel();
        HighlightDisplayLevel level = baseLevel.getSeverity().compareTo(defaultLevel.getSeverity()) > 0 ? baseLevel : defaultLevel;
        boolean enabled = this.myBaseProfile != null ? this.myBaseProfile.isToolEnabled(key) : toolWrapper.isEnabledByDefault();
        ToolsImpl toolsList = new ToolsImpl(toolWrapper, level, !this.myLockedProfile && enabled, enabled);
        Element element = this.myUninitializedSettings.remove(shortName);
        try {
            if (element != null) {
                element = element.clone();
                this.getPathMacroManager().expandPaths(element);
                toolsList.readExternal(element, this.getProfileManager(), dependencies);
            } else if (!this.myUninitializedSettings.containsKey(InspectionElementsMergerBase.getMergedMarkerName(shortName))) {
                Element merged;
                InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(shortName);
                Element element2 = merged = merger == null ? null : merger.merge(this.myUninitializedSettings);
                if (merged != null) {
                    this.getPathMacroManager().expandPaths(merged);
                    toolsList.readExternal(merged, this.getProfileManager(), dependencies);
                } else if (this.isProfileLocked()) {
                    toolsList.setEnabled(false);
                    if (toolsList.getNonDefaultTools() == null) {
                        toolsList.getDefaultState().setEnabled(false);
                    }
                }
            }
        }
        catch (InvalidDataException e) {
            LOG.error("Can't read settings for " + toolWrapper, (Throwable)e);
        }
        this.myTools.put(shortName, toolsList);
    }

    @Nullable
    private static InspectionElementsMergerBase getMerger(@NotNull String shortName) {
        final InspectionElementsMerger merger = InspectionElementsMerger.getMerger((String)shortName);
        if (merger instanceof InspectionElementsMergerBase) {
            return (InspectionElementsMergerBase)merger;
        }
        return merger == null ? null : new InspectionElementsMergerBase(){

            @NotNull
            public String getMergedToolName() {
                return merger.getMergedToolName();
            }

            @NotNull
            public String[] getSourceToolNames() {
                return merger.getSourceToolNames();
            }
        };
    }

    @Transient
    @Nullable
    public String[] getScopesOrder() {
        return this.myScopesOrder;
    }

    public void setScopesOrder(@NotNull String[] scopesOrder) {
        this.myScopesOrder = scopesOrder;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    private HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, @Nullable Project project) {
        return this.getTools(key.toString(), project).getLevel();
    }

    @NotNull
    public InspectionProfileModifiableModel getModifiableModel() {
        return new InspectionProfileModifiableModel(this);
    }

    public void cleanup(@NotNull Project project) {
        if (!this.wasInitialized()) {
            return;
        }
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            toolList.cleanupTools(project);
        }
    }

    public void enableTool(@NotNull String toolShortName, @Nullable Project project) {
        this.setToolEnabled(toolShortName, true, project);
    }

    public void enableTool(@NotNull String inspectionTool, @NotNull NamedScope namedScope, @NotNull Project project) {
        this.getTools(inspectionTool, project).enableTool(namedScope, project);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void enableTools(@NotNull List<String> inspectionTools, @NotNull NamedScope namedScope, @NotNull Project project) {
        for (String inspectionTool : inspectionTools) {
            this.enableTool(inspectionTool, namedScope, project);
        }
    }

    public void disableTools(@NotNull List<String> inspectionTools, @NotNull NamedScope namedScope, @NotNull Project project) {
        for (String inspectionTool : inspectionTools) {
            this.getTools(inspectionTool, project).disableTool(namedScope, project);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key, @NotNull HighlightDisplayLevel level, Project project) {
        this.getTools(key.toString(), project).setLevel(level);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public boolean isToolEnabled(@Nullable HighlightDisplayKey key, @Nullable PsiElement element) {
        if (key == null) {
            return false;
        }
        ToolsImpl toolState = this.getToolsOrNull(key.toString(), element == null ? null : element.getProject());
        return toolState != null && toolState.isEnabled(element);
    }

    public boolean isExecutable(@Nullable Project project) {
        this.initInspectionTools(project);
        for (Tools tools : this.myTools.values()) {
            if (!tools.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Tag
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = StringUtil.nullize((String)description);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void resetToBase(@NotNull String toolId, NamedScope scope, @NotNull Project project) {
        ToolsImpl tools = this.myBaseProfile.getToolsOrNull(toolId, project);
        if (tools == null) {
            return;
        }
        InspectionToolWrapper baseDefaultWrapper = tools.getDefaultState().getTool();
        ScopeToolState state = this.myTools.get(toolId).getTools().stream().filter(s -> scope == s.getScope(project)).findFirst().orElseThrow(IllegalStateException::new);
        state.setTool(InspectionProfileImpl.copyToolSettings(baseDefaultWrapper));
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void convert(@NotNull Element element, @NotNull Project project) {
        Element scopes = element.getChild("scopes");
        if (scopes == null) {
            return;
        }
        this.initInspectionTools(project);
        for (Element scopeElement : scopes.getChildren("scope")) {
            NamedScope scope;
            String profile2 = scopeElement.getAttributeValue("profile");
            InspectionProfileImpl inspectionProfile = profile2 == null ? null : this.getProfileManager().getProfile(profile2);
            NamedScope namedScope = scope = inspectionProfile == null ? null : this.getProfileManager().getScopesManager().getScope(scopeElement.getAttributeValue("name"));
            if (scope == null) continue;
            for (InspectionToolWrapper toolWrapper : inspectionProfile.getInspectionTools(null)) {
                HighlightDisplayKey key = HighlightDisplayKey.find((String)toolWrapper.getShortName());
                try {
                    InspectionToolWrapper toolWrapperCopy = InspectionProfileImpl.copyToolSettings(toolWrapper);
                    HighlightDisplayLevel errorLevel = inspectionProfile.getErrorLevel(key, null, project);
                    this.getTools(toolWrapper.getShortName(), project).addTool(scope, toolWrapperCopy, inspectionProfile.isToolEnabled(key), errorLevel);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        this.reduceConvertedScopes();
    }

    private void reduceConvertedScopes() {
        for (ToolsImpl tools : this.myTools.values()) {
            ScopeToolState toolState = tools.getDefaultState();
            List<ScopeToolState> nonDefaultTools = tools.getNonDefaultTools();
            if (nonDefaultTools == null) continue;
            boolean equal = true;
            boolean isEnabled = toolState.isEnabled();
            for (ScopeToolState state : nonDefaultTools) {
                isEnabled |= state.isEnabled();
                if (state.equalTo(toolState)) continue;
                equal = false;
            }
            tools.setEnabled(isEnabled);
            if (!equal) continue;
            tools.removeAllScopes();
        }
    }

    @NotNull
    public List<ScopeToolState> getAllTools() {
        this.initInspectionTools();
        NotNullList result2 = new NotNullList();
        for (Tools tools : this.myTools.values()) {
            tools.collectTools((List)result2);
        }
        return result2;
    }

    @NotNull
    public List<ScopeToolState> getDefaultStates(@Nullable Project project) {
        this.initInspectionTools(project);
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getDefaultState());
        }
        return result2;
    }

    @NotNull
    public List<ScopeToolState> getNonDefaultTools(@NotNull String shortName, Project project) {
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        List<ScopeToolState> nonDefaultTools = this.getTools(shortName, project).getNonDefaultTools();
        if (nonDefaultTools != null) {
            result2.addAll(nonDefaultTools);
        }
        return result2;
    }

    public boolean isToolEnabled(@NotNull HighlightDisplayKey key, NamedScope namedScope, Project project) {
        return this.getTools(key.toString(), project).isEnabled(namedScope, project);
    }

    public void removeScope(@NotNull String toolShortName, @NotNull String scopeName, Project project) {
        this.getTools(toolShortName, project).removeScope(scopeName);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void removeScopes(@NotNull List<String> shortNames, @NotNull String scopeName, Project project) {
        for (String shortName : shortNames) {
            this.removeScope(shortName, scopeName, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Set<String> getChangedToolNames() {
        if (this.myBaseProfile == null) {
            return null;
        }
        if (this.myChangedToolNames == null) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myChangedToolNames == null) {
                    this.initInspectionTools(null);
                    Set<String> names = this.myTools.keySet();
                    THashSet map2 = new THashSet(names.size());
                    for (String toolId : names) {
                        if (InspectionProfileImpl.toolSettingsAreEqual(toolId, this.myBaseProfile, this)) continue;
                        map2.add(toolId);
                    }
                    this.myChangedToolNames = map2;
                    return map2;
                }
            }
        }
        return this.myChangedToolNames;
    }

    public void profileChanged() {
        this.myChangedToolNames = null;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @Transient
    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, NamedScope scope, Project project) {
        ToolsImpl tools = this.getToolsOrNull(key.toString(), project);
        return tools != null ? tools.getLevel(scope, project) : HighlightDisplayLevel.WARNING;
    }

    public ScopeToolState addScope(@NotNull InspectionToolWrapper toolWrapper, NamedScope scope, @NotNull HighlightDisplayLevel level, boolean enabled, Project project) {
        return this.getTools(toolWrapper.getShortName(), project).prependTool(scope, toolWrapper, enabled, level);
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key, @NotNull HighlightDisplayLevel level, String scopeName, Project project) {
        this.getTools(key.toString(), project).setLevel(level, scopeName, project);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void setErrorLevel(@NotNull List<? extends HighlightDisplayKey> keys, @NotNull HighlightDisplayLevel level, String scopeName, Project project) {
        for (HighlightDisplayKey highlightDisplayKey : keys) {
            this.setErrorLevel(highlightDisplayKey, level, scopeName, project);
        }
    }

    @Override
    @Nullable
    public ToolsImpl getToolsOrNull(@NotNull String name, @Nullable Project project) {
        this.initInspectionTools(project);
        return this.myTools.get(name);
    }

    public void enableAllTools(Project project) {
        for (InspectionToolWrapper entry : this.getInspectionTools(null)) {
            this.enableTool(entry.getShortName(), project);
        }
    }

    public void disableAllTools(Project project) {
        for (InspectionToolWrapper entry : this.getInspectionTools(null)) {
            this.setToolEnabled(entry.getShortName(), false, project);
        }
    }
}

