/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class InspectionToolRegistrar
implements Supplier<List<InspectionToolWrapper>> {
    private static final Logger LOG = Logger.getInstance(InspectionToolRegistrar.class);
    @NotNull
    private final NotNullLazyValue<List<Supplier<InspectionToolWrapper>>> myInspectionToolFactories = NotNullLazyValue.createValue(() -> {
        THashSet providers = new THashSet();
        providers.addAll(((ComponentManagerImpl)ApplicationManager.getApplication()).getComponentInstancesOfType(InspectionToolProvider.class));
        providers.addAll(InspectionToolProvider.EXTENSION_POINT_NAME.getExtensionList());
        ArrayList<Supplier<InspectionToolWrapper>> factories = new ArrayList<Supplier<InspectionToolWrapper>>();
        InspectionToolRegistrar.registerTools((Collection<? extends InspectionToolProvider>)providers, factories);
        boolean isInternal = ApplicationManager.getApplication().isInternal();
        THashMap shortNames = new THashMap();
        for (LocalInspectionEP ep : LocalInspectionEP.LOCAL_INSPECTION.getExtensionList()) {
            InspectionToolRegistrar.checkForDuplicateShortName((InspectionEP)ep, (Map<String, InspectionEP>)shortNames);
            if (!isInternal && ep.isInternal) continue;
            factories.add(() -> new LocalInspectionToolWrapper(ep));
        }
        for (InspectionEP ep : (InspectionEP[])InspectionEP.GLOBAL_INSPECTION.getExtensions()) {
            InspectionToolRegistrar.checkForDuplicateShortName(ep, (Map<String, InspectionEP>)shortNames);
            if (!isInternal && ep.isInternal) continue;
            factories.add(() -> new GlobalInspectionToolWrapper(ep));
        }
        return factories;
    });

    private static void checkForDuplicateShortName(InspectionEP ep, Map<String, InspectionEP> shortNames) {
        String shortName = ep.getShortName();
        InspectionEP duplicate = shortNames.put(shortName, ep);
        if (duplicate != null) {
            PluginDescriptor descriptor = ep.getPluginDescriptor();
            LOG.error((Throwable)new PluginException("Short name '" + shortName + "' is not unique\nclass '" + ep.instantiateTool().getClass().getCanonicalName() + "' in " + descriptor + "\nand\nclass'" + duplicate.instantiateTool().getClass().getCanonicalName() + "' in " + duplicate.getPluginDescriptor() + "\nconflict", descriptor.getPluginId()));
        }
    }

    @NotNull
    public static InspectionToolWrapper wrapTool(@NotNull InspectionProfileEntry profileEntry) {
        if (profileEntry instanceof LocalInspectionTool) {
            return new LocalInspectionToolWrapper((LocalInspectionTool)profileEntry);
        }
        if (profileEntry instanceof GlobalInspectionTool) {
            return new GlobalInspectionToolWrapper((GlobalInspectionTool)profileEntry);
        }
        throw new RuntimeException("unknown inspection class: " + profileEntry + "; " + profileEntry.getClass());
    }

    private static void registerTools(@NotNull Collection<? extends InspectionToolProvider> providers, @NotNull List<Supplier<InspectionToolWrapper>> factories) {
        for (InspectionToolProvider inspectionToolProvider : providers) {
            for (Class aClass : inspectionToolProvider.getInspectionClasses()) {
                factories.add(() -> {
                    InspectionProfileEntry entry = (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool((Class)aClass);
                    return entry == null ? null : InspectionToolRegistrar.wrapTool(entry);
                });
            }
        }
    }

    public static InspectionToolRegistrar getInstance() {
        return (InspectionToolRegistrar)ServiceManager.getService(InspectionToolRegistrar.class);
    }

    @Override
    @NotNull
    public List<InspectionToolWrapper> get() {
        return this.createTools();
    }

    @NotNull
    public List<InspectionToolWrapper> createTools() {
        List inspectionToolFactories = (List)this.myInspectionToolFactories.getValue();
        ArrayList<InspectionToolWrapper> tools = new ArrayList<InspectionToolWrapper>(inspectionToolFactories.size());
        for (Supplier factory : inspectionToolFactories) {
            ProgressManager.checkCanceled();
            InspectionToolWrapper toolWrapper = (InspectionToolWrapper)factory.get();
            if (toolWrapper == null || InspectionToolRegistrar.checkTool(toolWrapper) != null) continue;
            tools.add(toolWrapper);
        }
        return tools;
    }

    private static String checkTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        String message = null;
        try {
            String id = toolWrapper.getID();
            if (id == null || !LocalInspectionTool.isValidID((String)id)) {
                message = InspectionsBundle.message((String)"inspection.disabled.wrong.id", (Object[])new Object[]{toolWrapper.getShortName(), id, "[a-zA-Z_0-9.-]+"});
            }
        }
        catch (Throwable t) {
            message = InspectionsBundle.message((String)"inspection.disabled.error", (Object[])new Object[]{toolWrapper.getShortName(), t.getMessage()});
        }
        if (message != null) {
            LOG.error(message);
        }
        return message;
    }
}

