/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.SequentialTask;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PerformFixesModalTask
implements SequentialTask {
    @NotNull
    protected final Project myProject;
    private final List<CommonProblemDescriptor[]> myDescriptorPacks;
    private final PsiDocumentManager myDocumentManager;
    private final PostprocessReformattingAspect myReformattingAspect;
    private final int myLength;
    private int myProcessed = 0;
    private int myPackIdx = 0;
    private int myDescriptorIdx = 0;

    protected PerformFixesModalTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors) {
        this(project, Collections.singletonList(descriptors));
    }

    protected PerformFixesModalTask(@NotNull Project project, @NotNull List<CommonProblemDescriptor[]> descriptorPacks) {
        this.myProject = project;
        this.myDescriptorPacks = descriptorPacks;
        this.myLength = descriptorPacks.stream().mapToInt(ds -> ((CommonProblemDescriptor[])ds).length).sum();
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        this.myReformattingAspect = PostprocessReformattingAspect.getInstance(this.myProject);
    }

    public void prepare() {
    }

    public boolean isDone() {
        return this.myPackIdx > this.myDescriptorPacks.size() - 1;
    }

    public boolean iteration() {
        return true;
    }

    public void doRun(ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        while (!this.isDone() && !indicator.isCanceled()) {
            this.iteration(indicator);
        }
    }

    public boolean iteration(@NotNull ProgressIndicator indicator) {
        PsiElement psiElement;
        Pair<CommonProblemDescriptor, Boolean> pair = this.nextDescriptor();
        CommonProblemDescriptor descriptor = (CommonProblemDescriptor)pair.getFirst();
        boolean shouldDoPostponedOperations = (Boolean)pair.getSecond();
        indicator.setFraction((double)this.myProcessed++ / (double)this.myLength);
        String presentableText = "usages";
        if (descriptor instanceof ProblemDescriptor && (psiElement = ((ProblemDescriptor)descriptor).getPsiElement()) != null) {
            presentableText = SymbolPresentationUtil.getSymbolPresentableText(psiElement);
        }
        indicator.setText("Processing " + presentableText);
        boolean[] runInReadAction = new boolean[]{false};
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null) {
            for (QuickFix fix : fixes) {
                if (fix.startInWriteAction()) {
                    runInReadAction[0] = false;
                    break;
                }
                runInReadAction[0] = true;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myDocumentManager.commitAllDocuments();
            if (!runInReadAction[0]) {
                this.applyFix(this.myProject, descriptor);
                if (shouldDoPostponedOperations) {
                    this.myReformattingAspect.doPostponedFormatting();
                }
            }
        });
        if (runInReadAction[0]) {
            this.applyFix(this.myProject, descriptor);
        }
        return this.isDone();
    }

    public void stop() {
    }

    protected abstract void applyFix(Project var1, CommonProblemDescriptor var2);

    private Pair<CommonProblemDescriptor, Boolean> nextDescriptor() {
        CommonProblemDescriptor[] descriptors = this.myDescriptorPacks.get(this.myPackIdx);
        CommonProblemDescriptor descriptor = descriptors[this.myDescriptorIdx++];
        boolean shouldDoPostponedOperations = false;
        if (this.myDescriptorIdx == descriptors.length) {
            shouldDoPostponedOperations = true;
            ++this.myPackIdx;
            this.myDescriptorIdx = 0;
        }
        return Pair.create((Object)descriptor, (Object)shouldDoPostponedOperations);
    }
}

