/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ClickListener;
import com.intellij.util.Consumer;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class QuickFixAction
extends AnAction
implements CustomComponentAction {
    private static final Logger LOG = Logger.getInstance(QuickFixAction.class);
    public static final QuickFixAction[] EMPTY = new QuickFixAction[0];
    protected final InspectionToolWrapper myToolWrapper;

    protected static InspectionResultsView getInvoker(@NotNull AnActionEvent e) {
        return (InspectionResultsView)InspectionResultsView.DATA_KEY.getData(e.getDataContext());
    }

    protected QuickFixAction(String text, @NotNull InspectionToolWrapper toolWrapper) {
        this(text, AllIcons.Actions.IntentionBulb, null, toolWrapper);
    }

    protected QuickFixAction(String text, Icon icon, KeyStroke keyStroke, @NotNull InspectionToolWrapper toolWrapper) {
        super(text, null, icon);
        this.myToolWrapper = toolWrapper;
        if (keyStroke != null) {
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), null);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        if (view == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setVisible(false);
        e.getPresentation().setEnabled(false);
        InspectionTree tree = view.getTree();
        InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper(true);
        if (!view.isSingleToolInSelection() || toolWrapper != this.myToolWrapper) {
            return;
        }
        if (!this.isProblemDescriptorsAcceptable() && tree.getSelectedElements().length > 0 || this.isProblemDescriptorsAcceptable() && tree.getSelectedDescriptors().length > 0) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(true);
        }
    }

    protected boolean isProblemDescriptorsAcceptable() {
        return false;
    }

    public String getText() {
        return this.getTemplatePresentation().getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        InspectionTree tree = view.getTree();
        try {
            Ref descriptors = Ref.create();
            THashSet readOnlyFiles = new THashSet();
            TreePath[] paths = tree.getSelectionPaths();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> QuickFixAction.lambda$actionPerformed$1(descriptors, tree, (Set)readOnlyFiles, paths), InspectionsBundle.message((String)"preparing.for.apply.fix", (Object[])new Object[0]), true, e.getProject())) {
                return;
            }
            if (this.isProblemDescriptorsAcceptable() && ((List)descriptors.get()).size() > 0) {
                this.doApplyFix(view.getProject(), (List)descriptors.get(), (Set<VirtualFile>)readOnlyFiles, tree.getContext());
            } else {
                this.doApplyFix(QuickFixAction.getSelectedElements(view), view);
            }
            view.getTree().removeSelectedProblems();
        }
        finally {
            view.setApplyingFix(false);
        }
    }

    protected void applyFix(@NotNull Project project, @NotNull GlobalInspectionContextImpl context, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<? super PsiElement> ignoredElements) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(@NotNull Project project, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull Set<VirtualFile> readOnlyFiles, @NotNull GlobalInspectionContextImpl context) {
        if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project, readOnlyFiles)) {
            return;
        }
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            HashSet resolvedElements = new HashSet();
            this.performFixesInBatch(project, descriptors, context, resolvedElements);
            QuickFixAction.refreshViews(project, resolvedElements, this.myToolWrapper);
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    protected boolean startInWriteAction() {
        return false;
    }

    protected void performFixesInBatch(@NotNull Project project, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull GlobalInspectionContextImpl context, Set<? super PsiElement> ignoredElements) {
        String templatePresentationText = this.getTemplatePresentation().getText();
        assert (templatePresentationText != null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            boolean startInWriteAction = this.startInWriteAction();
            PerformFixesTask performFixesTask = new PerformFixesTask(project, descriptors, ignoredElements, context);
            if (startInWriteAction) {
                ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(templatePresentationText, project, null, (Consumer<? super ProgressIndicator>)((Consumer)performFixesTask::doRun));
            } else {
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, templatePresentationText, true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(performFixesTask);
                ProgressManager.getInstance().run((Task)progressTask);
            }
        }, templatePresentationText, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(@NotNull RefEntity[] refElements, @NotNull InspectionResultsView view) {
        RefManagerImpl refManager = (RefManagerImpl)view.getGlobalInspectionContext().getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            boolean[] refreshNeeded = new boolean[]{false};
            if (refElements.length > 0) {
                Project project = refElements[0].getRefManager().getProject();
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        refreshNeeded[0] = this.applyFix(refElements);
                    });
                }, this.getTemplatePresentation().getText(), null);
            }
            if (refreshNeeded[0]) {
                QuickFixAction.refreshViews(view.getProject(), refElements, this.myToolWrapper);
            }
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    public static void removeElements(@NotNull RefEntity[] refElements, @NotNull Project project, @NotNull InspectionToolWrapper toolWrapper) {
        QuickFixAction.refreshViews(project, refElements, toolWrapper);
        ArrayList deletedRefs = new ArrayList(1);
        for (RefEntity refElement : refElements) {
            if (!(refElement instanceof RefElement)) continue;
            refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
        }
    }

    private static Set<VirtualFile> getReadOnlyFiles(@NotNull RefEntity[] refElements) {
        THashSet readOnlyFiles = new THashSet();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
            if (psiElement == null || psiElement.getContainingFile() == null) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        return readOnlyFiles;
    }

    @NotNull
    private static RefEntity[] getSelectedElements(InspectionResultsView view) {
        if (view == null) {
            return RefEntity.EMPTY_ELEMENTS_ARRAY;
        }
        RefEntity[] selection = view.getTree().getSelectedElements();
        PsiDocumentManager.getInstance((Project)view.getProject()).commitAllDocuments();
        Arrays.sort(selection, InspectionResultsViewComparator::compareEntities);
        return selection;
    }

    private static void refreshViews(@NotNull Project project, @NotNull Set<? extends PsiElement> resolvedElements, @NotNull InspectionToolWrapper toolWrapper) {
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        Set<GlobalInspectionContextImpl> runningContexts = managerEx.getRunningContexts();
        for (GlobalInspectionContextImpl context : runningContexts) {
            for (PsiElement psiElement : resolvedElements) {
                context.resolveElement(toolWrapper.getTool(), psiElement);
            }
            context.refreshViews();
        }
    }

    protected static void refreshViews(@NotNull Project project, @NotNull RefEntity[] resolvedElements, @NotNull InspectionToolWrapper toolWrapper) {
        HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
        for (RefEntity element : resolvedElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = element instanceof RefElement ? ((RefElement)element).getPsiElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            ignoredElements.add(psiElement);
        }
        QuickFixAction.refreshViews(project, ignoredElements, toolWrapper);
    }

    protected boolean applyFix(@NotNull RefEntity[] refElements) {
        Project project;
        ReadonlyStatusHandler.OperationStatus operationStatus;
        Set<VirtualFile> readOnlyFiles = QuickFixAction.getReadOnlyFiles(refElements);
        return readOnlyFiles.isEmpty() || !(operationStatus = ReadonlyStatusHandler.getInstance((Project)(project = refElements[0].getRefManager().getProject())).ensureFilesWritable(readOnlyFiles)).hasReadonlyFiles();
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, final @NotNull String place) {
        final JButton button2 = new JButton(presentation.getText());
        Icon icon = presentation.getIcon();
        if (icon == null) {
            icon = AllIcons.Actions.IntentionBulb;
        }
        button2.setEnabled(presentation.isEnabled());
        button2.setIcon(IconLoader.getTransparentIcon((Icon)icon, (float)0.75f));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                ActionToolbar toolbar = (ActionToolbar)UIUtil.getParentOfType(ActionToolbar.class, (Component)button2);
                QuickFixAction.this.actionPerformed(AnActionEvent.createFromAnAction((AnAction)QuickFixAction.this, (InputEvent)event, (String)place, (DataContext)(toolbar == null ? DataManager.getInstance().getDataContext((Component)button2) : toolbar.getToolbarDataContext())));
                return true;
            }
        }.installOn((Component)button2);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 2));
        panel2.setBorder((Border)JBUI.Borders.empty((int)7, (int)0, (int)8, (int)0));
        panel2.add(button2);
        return panel2;
    }

    private static /* synthetic */ void lambda$actionPerformed$1(Ref descriptors, InspectionTree tree, Set readOnlyFiles, TreePath[] paths) {
        ReadAction.run(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setText("Checking problem descriptors...");
            descriptors.set(tree.getSelectedDescriptorPacks(true, readOnlyFiles, false, paths));
        });
    }

    private class PerformFixesTask
    extends PerformFixesModalTask {
        @NotNull
        private final GlobalInspectionContextImpl myContext;
        @NotNull
        private final Set<? super PsiElement> myIgnoredElements;

        PerformFixesTask(@NotNull Project project, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull Set<? super PsiElement> ignoredElements, GlobalInspectionContextImpl context) {
            super(project, descriptors);
            this.myContext = context;
            this.myIgnoredElements = ignoredElements;
        }

        @Override
        protected void applyFix(Project project, CommonProblemDescriptor descriptor) {
            if (descriptor instanceof ProblemDescriptor && ((ProblemDescriptor)descriptor).getStartElement() == null && ((ProblemDescriptor)descriptor).getEndElement() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalidated psi for " + descriptor);
                }
                return;
            }
            try {
                QuickFixAction.this.applyFix(this.myProject, this.myContext, new CommonProblemDescriptor[]{descriptor}, this.myIgnoredElements);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }
}

