/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFixWrapper
implements IntentionAction,
PriorityAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInspection.ex.QuickFixWrapper");
    private final ProblemDescriptor myDescriptor;
    private final LocalQuickFix myFix;

    @NotNull
    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor, int fixNumber) {
        LOG.assertTrue(fixNumber >= 0, (Object)fixNumber);
        QuickFix[] fixes = descriptor.getFixes();
        LOG.assertTrue(fixes != null && fixes.length > fixNumber);
        QuickFix fix = fixes[fixNumber];
        return fix instanceof IntentionAction ? (IntentionAction)fix : new QuickFixWrapper(descriptor, (LocalQuickFix)fix);
    }

    private QuickFixWrapper(@NotNull ProblemDescriptor descriptor, @NotNull LocalQuickFix fix) {
        this.myDescriptor = descriptor;
        this.myFix = fix;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return this.getFix().getName();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiElement psiElement = this.myDescriptor.getPsiElement();
        return psiElement != null && psiElement.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiElement element = this.myDescriptor.getPsiElement();
        PsiFile fileForUndo = element == null ? null : element.getContainingFile();
        LocalQuickFix fix = this.getFix();
        fix.applyFix(project, (CommonProblemDescriptor)this.myDescriptor);
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
        if (fileForUndo != null && !fileForUndo.equals(file2)) {
            UndoUtil.markPsiFileForUndo((PsiFile)fileForUndo);
        }
    }

    public boolean startInWriteAction() {
        return this.getFix().startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.getFix().getElementToMakeWritable(file2);
    }

    @NotNull
    public LocalQuickFix getFix() {
        return this.myFix;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.myFix instanceof PriorityAction ? ((PriorityAction)this.myFix).getPriority() : PriorityAction.Priority.NORMAL;
    }

    public ProblemHighlightType getHighlightType() {
        return this.myDescriptor.getHighlightType();
    }

    @Nullable
    public PsiFile getFile() {
        PsiElement element = this.myDescriptor.getPsiElement();
        return element != null ? element.getContainingFile() : null;
    }

    public String toString() {
        return this.getText();
    }
}

