/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RemoveExtraClosingTagIntentionAction
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getFamilyName() {
        return XmlErrorMessages.message("remove.extra.closing.tag.quickfix", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getName();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiElement psiElement = file2.findElementAt(editor.getCaretModel().getOffset());
        return psiElement instanceof XmlToken && (psiElement.getParent() instanceof XmlTag || psiElement.getParent() instanceof PsiErrorElement);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        RemoveExtraClosingTagIntentionAction.doFix(Objects.requireNonNull(file2.findElementAt(editor.getCaretModel().getOffset())).getParent());
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void doFix(@NotNull PsiElement tagElement) throws IncorrectOperationException {
        if (tagElement instanceof PsiErrorElement) {
            Collection outers = PsiTreeUtil.findChildrenOfType((PsiElement)tagElement, OuterLanguageElement.class);
            String replacement = StringUtil.join((Collection)outers, PsiElement::getText, (String)"");
            Document document = RemoveExtraClosingTagIntentionAction.getDocument(tagElement);
            if (document != null && !replacement.isEmpty()) {
                TextRange range2 = tagElement.getTextRange();
                document.replaceString(range2.getStartOffset(), range2.getEndOffset(), (CharSequence)replacement);
            } else {
                tagElement.delete();
            }
        } else {
            Document document;
            ASTNode endTagStart;
            ASTNode astNode = tagElement.getNode();
            if (astNode != null && (endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(astNode)) != null && (document = RemoveExtraClosingTagIntentionAction.getDocument(tagElement)) != null) {
                document.deleteString(endTagStart.getStartOffset(), tagElement.getLastChild().getTextRange().getEndOffset());
            }
        }
    }

    private static Document getDocument(@NotNull PsiElement tagElement) {
        return PsiDocumentManager.getInstance((Project)tagElement.getProject()).getDocument(tagElement.getContainingFile());
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof XmlToken)) {
            return;
        }
        RemoveExtraClosingTagIntentionAction.doFix(element.getParent());
    }
}

