/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.htmlInspections.XmlWrongClosingTagNameInspection;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTagBeginOrEndIntentionAction
implements IntentionAction {
    private final boolean myStart;
    private final String myTargetName;
    private final String mySourceName;

    RenameTagBeginOrEndIntentionAction(@NotNull String targetName, @NotNull String sourceName, boolean start2) {
        this.myTargetName = targetName;
        this.mySourceName = sourceName;
        this.myStart = start2;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    @NotNull
    public String getText() {
        return this.getName();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return;
        }
        if (psiElement instanceof PsiWhiteSpace) {
            psiElement = PsiTreeUtil.prevLeaf((PsiElement)psiElement);
        }
        if (psiElement instanceof XmlToken) {
            Document document;
            IElementType tokenType = ((XmlToken)psiElement).getTokenType();
            if (tokenType != XmlTokenType.XML_NAME && tokenType == XmlTokenType.XML_TAG_END && (psiElement = psiElement.getPrevSibling()) == null) {
                return;
            }
            PsiElement target2 = null;
            String text = psiElement.getText();
            target2 = !this.myTargetName.equals(text) ? psiElement : RenameTagBeginOrEndIntentionAction.findOtherSide(psiElement, this.myStart);
            if (target2 != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(file2)) != null) {
                TextRange textRange = target2.getTextRange();
                document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)this.myTargetName);
            }
        }
    }

    @Nullable
    public static PsiElement findOtherSide(PsiElement psiElement, boolean start2) {
        XmlToken target2 = null;
        PsiElement parent = psiElement.getParent();
        if (parent instanceof PsiErrorElement) {
            parent = parent.getParent();
        }
        if (parent instanceof XmlTag) {
            if (start2) {
                target2 = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)parent));
            } else {
                target2 = XmlTagUtil.getEndTagNameElement((XmlTag)((XmlTag)parent));
                if (target2 == null) {
                    PsiErrorElement errorElement = (PsiErrorElement)PsiTreeUtil.getChildOfType((PsiElement)parent, PsiErrorElement.class);
                    target2 = XmlWrongClosingTagNameInspection.findEndTagName(errorElement);
                }
            }
        }
        return target2;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getName() {
        return this.myStart ? XmlErrorMessages.message("rename.start.tag.name.intention", this.mySourceName, this.myTargetName) : XmlErrorMessages.message("rename.end.tag.name.intention", this.mySourceName, this.myTargetName);
    }
}

